// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _StepData_Simple_HeaderFile
#define _StepData_Simple_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_StepData_Simple_HeaderFile
#include <Handle_StepData_Simple.hxx>
#endif

#ifndef _StepData_FieldListN_HeaderFile
#include <StepData_FieldListN.hxx>
#endif
#ifndef _StepData_Described_HeaderFile
#include <StepData_Described.hxx>
#endif
#ifndef _Handle_StepData_ESDescr_HeaderFile
#include <Handle_StepData_ESDescr.hxx>
#endif
#ifndef _Standard_CString_HeaderFile
#include <Standard_CString.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
class Interface_InterfaceMismatch;
class StepData_ESDescr;
class StepData_Field;
class StepData_FieldListN;
class Interface_Check;
class Interface_EntityIterator;


//! A Simple Entity is defined by a type (which can heve super <br>
//!           types) and a list of parameters <br>
class StepData_Simple : public StepData_Described {

public:
 // Methods PUBLIC
 // 

//! Creates a Simple Entity <br>
Standard_EXPORT StepData_Simple(const Handle(StepData_ESDescr)& descr);

//! Returns description, as for simple <br>
Standard_EXPORT   Handle_StepData_ESDescr ESDescr() const;

//! Returns the recorded StepType (TypeName of its ESDescr) <br>
Standard_EXPORT   Standard_CString StepType() const;

//! Returns False <br>
Standard_EXPORT   Standard_Boolean IsComplex() const;

//! Tells if a step type is matched by <me> <br>
//!           For a Simple Entity : own type or super type <br>
//!           For a Complex Entity : one of the members <br>
Standard_EXPORT   Standard_Boolean Matches(const Standard_CString steptype) const;

//! Returns a Simple Entity which matches with a Type in <me> : <br>
//!           For a Simple Entity : me if it matches, else a null handle <br>
//!           For a Complex Entity : the member which matches, else null <br>
Standard_EXPORT   Handle_StepData_Simple As(const Standard_CString steptype) const;

//! Tells if a Field brings a given name <br>
Standard_EXPORT   Standard_Boolean HasField(const Standard_CString name) const;

//! Returns a Field from its name; read-only <br>
Standard_EXPORT  const StepData_Field& Field(const Standard_CString name) const;

//! Returns a Field from its name; read or write <br>
Standard_EXPORT   StepData_Field& CField(const Standard_CString name) ;

//! Returns the count of fields <br>
Standard_EXPORT   Standard_Integer NbFields() const;

//! Returns a field from its rank, for read-only use <br>
Standard_EXPORT  const StepData_Field& FieldNum(const Standard_Integer num) const;

//! Returns a field from its rank, in order to modify it <br>
Standard_EXPORT   StepData_Field& CFieldNum(const Standard_Integer num) ;

//! Returns the entire field list, read-only <br>
Standard_EXPORT  const StepData_FieldListN& Fields() const;

//! Returns the entire field list, read or write <br>
Standard_EXPORT   StepData_FieldListN& CFields() ;

//! Fills a Check by using its Description <br>
Standard_EXPORT   void Check(Handle(Interface_Check)& ach) const;

//! Fills an EntityIterator with entities shared by <me> <br>
Standard_EXPORT   void Shared(Interface_EntityIterator& list) const;
//Standard_EXPORT ~StepData_Simple();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
StepData_FieldListN thefields;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
