// File generated by CPPExt (Transient)
//
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TDF_DataSet_HeaderFile
#define _TDF_DataSet_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Handle_TDF_DataSet_HeaderFile
#include <Handle_TDF_DataSet.hxx>
#endif

#ifndef _TDF_LabelList_HeaderFile
#include <TDF_LabelList.hxx>
#endif
#ifndef _TDF_LabelMap_HeaderFile
#include <TDF_LabelMap.hxx>
#endif
#ifndef _TDF_AttributeMap_HeaderFile
#include <TDF_AttributeMap.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_TDF_Attribute_HeaderFile
#include <Handle_TDF_Attribute.hxx>
#endif
#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
class TDF_Label;
class TDF_LabelMap;
class TDF_Attribute;
class TDF_AttributeMap;
class TDF_LabelList;


//! This class is a set of TDF informations like <br>
//!          labels and attributes. <br>
class TDF_DataSet : public MMgt_TShared {

public:
 // Methods PUBLIC
 // 

//! Creates an  empty   DataSet  object. <br>
Standard_EXPORT TDF_DataSet();

//! Clears all information. <br>
Standard_EXPORT   void Clear() ;
//! Returns true if there is at least one label or one <br>
//!          attribute. <br>
  Standard_Boolean IsEmpty() const;
//! Adds <aLabel> in  the  current  data  set. <br>
  void AddLabel(const TDF_Label& aLabel) ;
//! Returns true if the label  <alabel>   is in the data set. <br>
  Standard_Boolean ContainsLabel(const TDF_Label& aLabel) const;
//! Returns the map of labels in this data set. <br>
//! This map can be used directly, or updated. <br>
//! <br>
  TDF_LabelMap& Labels() ;
//! Adds <anAttribute> into the current data  set. <br>
  void AddAttribute(const Handle(TDF_Attribute)& anAttribute) ;
//! Returns true if <anAttribute> is in the data set. <br>
  Standard_Boolean ContainsAttribute(const Handle(TDF_Attribute)& anAttribute) const;
//! Returns the map of attributes in the  current  data   set. <br>
//!  This map can be used directly, or updated. <br>
//! <br>
  TDF_AttributeMap& Attributes() ;
//! Adds a root label to <myRootLabels>. <br>
//! <br>
  void AddRoot(const TDF_Label& aLabel) ;
//! Returns <myRootLabels> to be used or updated. <br>
//! <br>
  TDF_LabelList& Roots() ;

//! Dumps the minimum information about <me> on <br>
//!          <aStream>. <br>
//! <br>
Standard_EXPORT   Standard_OStream& Dump(Standard_OStream& anOS) const;
  Standard_OStream& operator<<(Standard_OStream& anOS) const
{
  return Dump(anOS);
}

//Standard_EXPORT ~TDF_DataSet();




 // Type management
 //
 Standard_EXPORT const Handle(Standard_Type)& DynamicType() const;
 //Standard_EXPORT Standard_Boolean	       IsKind(const Handle(Standard_Type)&) const;

protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
TDF_LabelList myRootLabels;
TDF_LabelMap myLabelMap;
TDF_AttributeMap myAttributeMap;


};


#include <TDF_DataSet.lxx>



// other Inline functions and methods (like "C++: function call" methods)
//


#endif
