// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopOpeBRepBuild_SolidBuilder_HeaderFile
#define _TopOpeBRepBuild_SolidBuilder_HeaderFile

#ifndef _TopOpeBRepBuild_LoopSet_HeaderFile
#include <TopOpeBRepBuild_LoopSet.hxx>
#endif
#ifndef _TopOpeBRepBuild_BlockIterator_HeaderFile
#include <TopOpeBRepBuild_BlockIterator.hxx>
#endif
#ifndef _TopOpeBRepBuild_BlockBuilder_HeaderFile
#include <TopOpeBRepBuild_BlockBuilder.hxx>
#endif
#ifndef _TopOpeBRepBuild_SolidAreaBuilder_HeaderFile
#include <TopOpeBRepBuild_SolidAreaBuilder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopOpeBRepBuild_ShellFaceSet;
class TopoDS_Shape;
class TopOpeBRepBuild_ShapeSet;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif


class TopOpeBRepBuild_SolidBuilder  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT TopOpeBRepBuild_SolidBuilder();

//! Create a SolidBuilder to build the areas on <br>
//! the shapes (shells, blocks of faces) described by <LS>. <br>
Standard_EXPORT TopOpeBRepBuild_SolidBuilder(TopOpeBRepBuild_ShellFaceSet& FS,const Standard_Boolean ForceClass = Standard_False);


Standard_EXPORT   void InitSolidBuilder(TopOpeBRepBuild_ShellFaceSet& FS,const Standard_Boolean ForceClass) ;


Standard_EXPORT   Standard_Integer InitSolid() ;


Standard_EXPORT   Standard_Boolean MoreSolid() const;


Standard_EXPORT   void NextSolid() ;


Standard_EXPORT   Standard_Integer InitShell() ;


Standard_EXPORT   Standard_Boolean MoreShell() const;


Standard_EXPORT   void NextShell() ;


Standard_EXPORT   Standard_Boolean IsOldShell() const;

//! Returns current shell <br>
//! This shell may be : <br>
//! * an old shell OldShell(), which has not been reconstructed; <br>
//! * a new shell made of faces described by ...NewFace() methods. <br>
Standard_EXPORT  const TopoDS_Shape& OldShell() const;


Standard_EXPORT   Standard_Integer InitFace() ;


Standard_EXPORT   Standard_Boolean MoreFace() const;


Standard_EXPORT   void NextFace() ;

//! Returns current new face of current new shell. <br>
Standard_EXPORT  const TopoDS_Shape& Face() const;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   void MakeLoops(TopOpeBRepBuild_ShapeSet& SS) ;


 // Fields PRIVATE
 //
TopOpeBRepBuild_LoopSet myLoopSet;
TopOpeBRepBuild_BlockIterator myBlockIterator;
TopOpeBRepBuild_BlockBuilder myBlockBuilder;
TopOpeBRepBuild_SolidAreaBuilder mySolidAreaBuilder;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
