// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _TopTools_HeaderFile
#define _TopTools_HeaderFile

#ifndef _Standard_OStream_HeaderFile
#include <Standard_OStream.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class TopoDS_Shape;
class TopTools_ShapeMapHasher;
class TopTools_OrientedShapeMapHasher;
class TopTools_MapOfShape;
class TopTools_MapOfOrientedShape;
class TopTools_IndexedMapOfShape;
class TopTools_DataMapOfIntegerShape;
class TopTools_DataMapOfOrientedShapeInteger;
class TopTools_DataMapOfShapeInteger;
class TopTools_Array1OfShape;
class TopTools_HArray1OfShape;
class TopTools_Array2OfShape;
class TopTools_HArray2OfShape;
class TopTools_SequenceOfShape;
class TopTools_HSequenceOfShape;
class TopTools_ListOfShape;
class TopTools_Array1OfListOfShape;
class TopTools_HArray1OfListOfShape;
class TopTools_DataMapOfIntegerListOfShape;
class TopTools_DataMapOfShapeListOfShape;
class TopTools_DataMapOfShapeListOfInteger;
class TopTools_IndexedDataMapOfShapeShape;
class TopTools_IndexedDataMapOfShapeListOfShape;
class TopTools_DataMapOfShapeShape;
class TopTools_IndexedMapOfOrientedShape;
class TopTools_LocationSet;
class TopTools_ShapeSet;
class TopTools_StdMapNodeOfMapOfShape;
class TopTools_MapIteratorOfMapOfShape;
class TopTools_StdMapNodeOfMapOfOrientedShape;
class TopTools_MapIteratorOfMapOfOrientedShape;
class TopTools_IndexedMapNodeOfIndexedMapOfShape;
class TopTools_DataMapNodeOfDataMapOfIntegerShape;
class TopTools_DataMapIteratorOfDataMapOfIntegerShape;
class TopTools_DataMapNodeOfDataMapOfOrientedShapeInteger;
class TopTools_DataMapIteratorOfDataMapOfOrientedShapeInteger;
class TopTools_DataMapNodeOfDataMapOfShapeInteger;
class TopTools_DataMapIteratorOfDataMapOfShapeInteger;
class TopTools_SequenceNodeOfSequenceOfShape;
class TopTools_ListNodeOfListOfShape;
class TopTools_ListIteratorOfListOfShape;
class TopTools_DataMapNodeOfDataMapOfIntegerListOfShape;
class TopTools_DataMapIteratorOfDataMapOfIntegerListOfShape;
class TopTools_DataMapNodeOfDataMapOfShapeListOfShape;
class TopTools_DataMapIteratorOfDataMapOfShapeListOfShape;
class TopTools_DataMapNodeOfDataMapOfShapeListOfInteger;
class TopTools_DataMapIteratorOfDataMapOfShapeListOfInteger;
class TopTools_IndexedDataMapNodeOfIndexedDataMapOfShapeShape;
class TopTools_IndexedDataMapNodeOfIndexedDataMapOfShapeListOfShape;
class TopTools_DataMapNodeOfDataMapOfShapeShape;
class TopTools_DataMapIteratorOfDataMapOfShapeShape;
class TopTools_IndexedMapNodeOfIndexedMapOfOrientedShape;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! The  TopTools package provides   utilities for the <br>
//!          topological data structure. <br>
//! <br>
//!          * ShapeMapHasher. Hash a  Shape base on the TShape <br>
//!          and the Location. The Orientation is not used. <br>
//! <br>
//!          * OrientedShapeMapHasher. Hash a Shape base on the <br>
//!          TShape ,the Location and the Orientation. <br>
//! <br>
//!          * Instantiations of TCollection for Shapes : <br>
//!             MapOfShape <br>
//!             IndexedMapOfShape <br>
//!             DataMapOfIntegerShape <br>
//!             DataMapOfShapeInteger <br>
//!             Array1OfShape <br>
//!             HArray1OfShape <br>
//!             SequenceOfShape <br>
//!             HSequenceOfShape <br>
//!             ListOfShape <br>
//!             Array1OfListShape <br>
//!             HArray1OfListShape <br>
//!             DataMapOfIntegerListOfShape <br>
//!             DataMapOfShapeListOfShape <br>
//!             IndexedDataMapOfShapeShape <br>
//!             IndexedDataMapOfShapeListOfShape <br>
//!             DataMapOfShapeShape <br>
//!             IndexedMapOfOrientedShape <br>
//! <br>
//!          * LocationSet : to write sets of locations. <br>
//! <br>
//!          * ShapeSet : to writes sets of TShapes. <br>
//! <br>
//!          Package Methods : <br>
//! <br>
//!            Dump : To dump the topology of a Shape. <br>
//! <br>
class TopTools  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Dumps the topological structure  of <Sh>  on the <br>
//!          stream <S>. <br>
Standard_EXPORT static  void Dump(const TopoDS_Shape& Sh,Standard_OStream& S) ;

//! This is to bypass an extraction bug. It will force <br>
//!          the  inclusion    of  Standard_Integer.hxx  itself <br>
//!          including Standard_OStream.hxx  at   the   correct <br>
//!          position. <br>
Standard_EXPORT static  void Dummy(const Standard_Integer I) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //

friend class TopTools_ShapeMapHasher;
friend class TopTools_OrientedShapeMapHasher;
friend class TopTools_MapOfShape;
friend class TopTools_MapOfOrientedShape;
friend class TopTools_IndexedMapOfShape;
friend class TopTools_DataMapOfIntegerShape;
friend class TopTools_DataMapOfOrientedShapeInteger;
friend class TopTools_DataMapOfShapeInteger;
friend class TopTools_Array1OfShape;
friend class TopTools_HArray1OfShape;
friend class TopTools_Array2OfShape;
friend class TopTools_HArray2OfShape;
friend class TopTools_SequenceOfShape;
friend class TopTools_HSequenceOfShape;
friend class TopTools_ListOfShape;
friend class TopTools_Array1OfListOfShape;
friend class TopTools_HArray1OfListOfShape;
friend class TopTools_DataMapOfIntegerListOfShape;
friend class TopTools_DataMapOfShapeListOfShape;
friend class TopTools_DataMapOfShapeListOfInteger;
friend class TopTools_IndexedDataMapOfShapeShape;
friend class TopTools_IndexedDataMapOfShapeListOfShape;
friend class TopTools_DataMapOfShapeShape;
friend class TopTools_IndexedMapOfOrientedShape;
friend class TopTools_LocationSet;
friend class TopTools_ShapeSet;
friend class TopTools_StdMapNodeOfMapOfShape;
friend class TopTools_MapIteratorOfMapOfShape;
friend class TopTools_StdMapNodeOfMapOfOrientedShape;
friend class TopTools_MapIteratorOfMapOfOrientedShape;
friend class TopTools_IndexedMapNodeOfIndexedMapOfShape;
friend class TopTools_DataMapNodeOfDataMapOfIntegerShape;
friend class TopTools_DataMapIteratorOfDataMapOfIntegerShape;
friend class TopTools_DataMapNodeOfDataMapOfOrientedShapeInteger;
friend class TopTools_DataMapIteratorOfDataMapOfOrientedShapeInteger;
friend class TopTools_DataMapNodeOfDataMapOfShapeInteger;
friend class TopTools_DataMapIteratorOfDataMapOfShapeInteger;
friend class TopTools_SequenceNodeOfSequenceOfShape;
friend class TopTools_ListNodeOfListOfShape;
friend class TopTools_ListIteratorOfListOfShape;
friend class TopTools_DataMapNodeOfDataMapOfIntegerListOfShape;
friend class TopTools_DataMapIteratorOfDataMapOfIntegerListOfShape;
friend class TopTools_DataMapNodeOfDataMapOfShapeListOfShape;
friend class TopTools_DataMapIteratorOfDataMapOfShapeListOfShape;
friend class TopTools_DataMapNodeOfDataMapOfShapeListOfInteger;
friend class TopTools_DataMapIteratorOfDataMapOfShapeListOfInteger;
friend class TopTools_IndexedDataMapNodeOfIndexedDataMapOfShapeShape;
friend class TopTools_IndexedDataMapNodeOfIndexedDataMapOfShapeListOfShape;
friend class TopTools_DataMapNodeOfDataMapOfShapeShape;
friend class TopTools_DataMapIteratorOfDataMapOfShapeShape;
friend class TopTools_IndexedMapNodeOfIndexedMapOfOrientedShape;

};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
