// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _Transfer_FindHasher_HeaderFile
#define _Transfer_FindHasher_HeaderFile

#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Transfer_Finder_HeaderFile
#include <Handle_Transfer_Finder.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
class Transfer_Finder;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! FindHasher defines HashCode for Finder, which is : ask a <br>
//!           Finder its HashCode !  Because this is the Finder itself which <br>
//!           brings the HashCode for its Key <br>
//! <br>
//!           This class complies to the template given in TCollection by <br>
//!           MapHasher itself <br>
class Transfer_FindHasher  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 

//! Returns a HashCode in the range <0,Upper> for a Finder : <br>
//!           asks the Finder its HashCode then transforms it to be in the <br>
//!           required range <br>
Standard_EXPORT static  Standard_Integer HashCode(const Handle(Transfer_Finder)& K,const Standard_Integer Upper) ;

//! Returns True if two keys are the same. <br>
//!           The test does not work on the Finders themselves but by <br>
//!           calling their methods Equates <br>
Standard_EXPORT static  Standard_Boolean IsEqual(const Handle(Transfer_Finder)& K1,const Handle(Transfer_Finder)& K2) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
