// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _WOKAPI_Session_HeaderFile
#define _WOKAPI_Session_HeaderFile

#ifndef _Handle_WOKUtils_Path_HeaderFile
#include <Handle_WOKUtils_Path.hxx>
#endif
#ifndef _WOKUtils_Param_HeaderFile
#include <WOKUtils_Param.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _WOKAPI_Entity_HeaderFile
#include <WOKAPI_Entity.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _WOKAPI_Factory_HeaderFile
#include <WOKAPI_Factory.hxx>
#endif
#ifndef _WOKAPI_Workshop_HeaderFile
#include <WOKAPI_Workshop.hxx>
#endif
#ifndef _WOKAPI_Warehouse_HeaderFile
#include <WOKAPI_Warehouse.hxx>
#endif
#ifndef _WOKAPI_Parcel_HeaderFile
#include <WOKAPI_Parcel.hxx>
#endif
#ifndef _WOKAPI_Workbench_HeaderFile
#include <WOKAPI_Workbench.hxx>
#endif
#ifndef _WOKAPI_Unit_HeaderFile
#include <WOKAPI_Unit.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Handle_Standard_Failure_HeaderFile
#include <Handle_Standard_Failure.hxx>
#endif
#ifndef _Handle_WOKernel_Entity_HeaderFile
#include <Handle_WOKernel_Entity.hxx>
#endif
#ifndef _Handle_WOKernel_Factory_HeaderFile
#include <Handle_WOKernel_Factory.hxx>
#endif
#ifndef _Handle_WOKernel_Warehouse_HeaderFile
#include <Handle_WOKernel_Warehouse.hxx>
#endif
#ifndef _Handle_WOKernel_Parcel_HeaderFile
#include <Handle_WOKernel_Parcel.hxx>
#endif
#ifndef _Handle_WOKernel_Workshop_HeaderFile
#include <Handle_WOKernel_Workshop.hxx>
#endif
#ifndef _Handle_WOKernel_Workbench_HeaderFile
#include <Handle_WOKernel_Workbench.hxx>
#endif
#ifndef _Handle_WOKernel_DevUnit_HeaderFile
#include <Handle_WOKernel_DevUnit.hxx>
#endif
class WOKUtils_Path;
class TCollection_HAsciiString;
class Standard_Failure;
class WOKAPI_Entity;
class WOKAPI_SequenceOfFactory;
class WOKUtils_Param;
class WOKernel_Entity;
class WOKernel_Factory;
class WOKernel_Warehouse;
class WOKernel_Parcel;
class WOKernel_Workshop;
class WOKernel_Workbench;
class WOKernel_DevUnit;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Manages Session API for WOK <br>
class WOKAPI_Session  : public WOKAPI_Entity {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT WOKAPI_Session();


Standard_EXPORT   Standard_Integer Open(const Handle(TCollection_HAsciiString)& alocation = NULL,const Handle(TCollection_HAsciiString)& astation = NULL) ;


Standard_EXPORT virtual  void Open(const WOKAPI_Session& aSession,const Handle(TCollection_HAsciiString)& aPath) ;


Standard_EXPORT virtual  void Close() ;


Standard_EXPORT   void GeneralFailure(const Handle(Standard_Failure)& afailure) ;


Standard_EXPORT virtual  Standard_Boolean IsValid() const;


Standard_EXPORT   Handle_WOKUtils_Path Path() const;


Standard_EXPORT   void SetPath(const Handle(WOKUtils_Path)& apath) ;


Standard_EXPORT   Handle_TCollection_HAsciiString CWEntityName() const;


Standard_EXPORT   WOKAPI_Entity GetCWEntity() const;


Standard_EXPORT   void SetCWEntity(const WOKAPI_Entity& anent) ;


Standard_EXPORT   void Factories(WOKAPI_SequenceOfFactory& factseq) const;


Standard_EXPORT   Handle_TCollection_HAsciiString Station() const;


Standard_EXPORT   Standard_Boolean SetStation(const Handle(TCollection_HAsciiString)& astation) ;


Standard_EXPORT   Handle_TCollection_HAsciiString DBMSystem() const;


Standard_EXPORT   Standard_Boolean SetDBMSystem(const Handle(TCollection_HAsciiString)& adbms) ;


Standard_EXPORT   Standard_Boolean DebugMode() const;


Standard_EXPORT   void SetDebugMode(const Standard_Boolean amode) ;


Standard_EXPORT   Standard_Boolean IsValidPath(const Handle(TCollection_HAsciiString)& apath) const;


Standard_EXPORT virtual  Standard_Boolean Destroy() ;


friend 

Standard_EXPORT WOKAPI_Entity::WOKAPI_Entity(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);
friend 

Standard_EXPORT WOKAPI_Factory::WOKAPI_Factory(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);
friend 

Standard_EXPORT WOKAPI_Workshop::WOKAPI_Workshop(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);
friend 

Standard_EXPORT WOKAPI_Warehouse::WOKAPI_Warehouse(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);
friend 

Standard_EXPORT WOKAPI_Parcel::WOKAPI_Parcel(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);
friend 

Standard_EXPORT WOKAPI_Workbench::WOKAPI_Workbench(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);
friend 

Standard_EXPORT WOKAPI_Unit::WOKAPI_Unit(const WOKAPI_Session& asession,const Handle(TCollection_HAsciiString)& aname,const Standard_Boolean verbose,const Standard_Boolean getit);



protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


Standard_EXPORT   WOKUtils_Param Param() const;

//! Sauve les parametres de session dans le fichier <br>
Standard_EXPORT   void SaveToFile() const;


Standard_EXPORT   Handle_WOKernel_Entity OpenPath(const Handle(TCollection_HAsciiString)& apath,const Standard_Boolean besilent = Standard_False) const;


Standard_EXPORT   Handle_WOKernel_Entity GetEntity(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True) const;


Standard_EXPORT   Handle_WOKernel_Factory GetFactory(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True,const Standard_Boolean getit = Standard_True) const;


Standard_EXPORT   Handle_WOKernel_Warehouse GetWarehouse(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True,const Standard_Boolean getit = Standard_True) const;


Standard_EXPORT   Handle_WOKernel_Parcel GetParcel(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True,const Standard_Boolean getit = Standard_True) const;


Standard_EXPORT   Handle_WOKernel_Workshop GetWorkshop(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True,const Standard_Boolean getit = Standard_True) const;


Standard_EXPORT   Handle_WOKernel_Workbench GetWorkbench(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True,const Standard_Boolean getit = Standard_True) const;


Standard_EXPORT   Handle_WOKernel_DevUnit GetDevUnit(const Handle(TCollection_HAsciiString)& ahumanpath,const Standard_Boolean fatal = Standard_True,const Standard_Boolean getit = Standard_True) const;


 // Fields PRIVATE
 //
Handle_WOKUtils_Path mypath;
WOKUtils_Param myparams;
Handle_TCollection_HAsciiString mycwe;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
