// File generated by CPPExt (Value)
//
//                     Copyright (C) 1991 - 2000 by  
//                      Matra Datavision SA.  All rights reserved.
//  
//                     Copyright (C) 2001 - 2004 by
//                     Open CASCADE SA.  All rights reserved.
// 
// This file is part of the Open CASCADE Technology software.
//
// This software may be distributed and/or modified under the terms and
// conditions of the Open CASCADE Public License as defined by Open CASCADE SA
// and appearing in the file LICENSE included in the packaging of this file.
//  
// This software is distributed on an "AS IS" basis, without warranty of any
// kind, and Open CASCADE SA hereby disclaims all such warranties,
// including without limitation, any warranties of merchantability, fitness
// for a particular purpose or non-infringement. Please see the License for
// the specific terms and conditions governing rights and limitations under the
// License.

#ifndef _XCAFPrs_Style_HeaderFile
#define _XCAFPrs_Style_HeaderFile

#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Quantity_Color_HeaderFile
#include <Quantity_Color.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
class Quantity_Color;


#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

//! Represents a set of styling settings applicable to <br>
//!          a (sub)shape <br>
class XCAFPrs_Style  {

public:

    void* operator new(size_t,void* anAddress) 
      {
        return anAddress;
      }
    void* operator new(size_t size) 
      { 
        return Standard::Allocate(size); 
      }
    void  operator delete(void *anAddress) 
      { 
        if (anAddress) Standard::Free((Standard_Address&)anAddress); 
      }
 // Methods PUBLIC
 // 


Standard_EXPORT XCAFPrs_Style();


Standard_EXPORT   Standard_Boolean IsSetColorSurf() const;


Standard_EXPORT   Quantity_Color GetColorSurf() const;


Standard_EXPORT   void SetColorSurf(const Quantity_Color& col) ;

//! Manage surface color setting <br>
Standard_EXPORT   void UnSetColorSurf() ;


Standard_EXPORT   Standard_Boolean IsSetColorCurv() const;


Standard_EXPORT   Quantity_Color GetColorCurv() const;


Standard_EXPORT   void SetColorCurv(const Quantity_Color& col) ;

//! Manage curve color setting <br>
Standard_EXPORT   void UnSetColorCurv() ;


Standard_EXPORT   void SetVisibility(const Standard_Boolean visibility) ;

//! Manage visibility <br>
//!          Note: Setting visibility to False makes colors undefined <br>
//!          This is necessary for HashCode <br>
Standard_EXPORT   Standard_Boolean IsVisible() const;

//! Returs True if styles are the same <br>//! Methods for using Style as key in maps <br>
Standard_EXPORT   Standard_Boolean IsEqual(const XCAFPrs_Style& other) const;
  Standard_Boolean operator ==(const XCAFPrs_Style& other) const
{
  return IsEqual(other);
}


//! Returns a HasCode value  for  the  Key <K>  in the <br>
//!          range 0..Upper. <br>
Standard_EXPORT static  Standard_Integer HashCode(const XCAFPrs_Style& S,const Standard_Integer Upper) ;

//! Returns True  when the two  keys are the same. Two <br>
//!          same  keys  must   have  the  same  hashcode,  the <br>
//!          contrary is not necessary. <br>
Standard_EXPORT static  Standard_Boolean IsEqual(const XCAFPrs_Style& S1,const XCAFPrs_Style& S2) ;





protected:

 // Methods PROTECTED
 // 


 // Fields PROTECTED
 //


private: 

 // Methods PRIVATE
 // 


 // Fields PRIVATE
 //
Standard_Boolean defColorSurf;
Standard_Boolean defColorCurv;
Standard_Boolean myVisibility;
Quantity_Color myColorSurf;
Quantity_Color myColorCurv;


};





// other Inline functions and methods (like "C++: function call" methods)
//


#endif
