/* MA1NOC.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Subroutine */ int mma1noc_(dfuvin, ndimen, iordre, cntrin, duvout, isofav, 
	ideriv, cntout)
doublereal *dfuvin;
integer *ndimen, *iordre;
doublereal *cntrin, *duvout;
integer *isofav, *ideriv;
doublereal *cntout;
{
    /* System generated locals */
    integer i__1;
    doublereal d__1;

    /* Builtin functions */
    double pow__di();

    /* Local variables */
    static doublereal rider, riord;
    static integer nd, ibb;
    static doublereal bid;
    extern integer mnfndeb_();
    extern /* Subroutine */ int mgenmsg_(), mgsomsg_();




/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ********************************************************************** 
*/

/*     FONCTION : */
/*     ---------- */
/*     Normalisation des contraintes de derivees, definies sur DFUVIN */
/*     sur le pave DUVOUT. */

/*     MOTS CLES : */
/*     ----------- */
/*     TOUS, AB_SPECIFI::VECTEUR&,DERIVEE&,NORMALISATION,&VECTEUR */

/*     ARGUMENTS D'ENTREE : */
/*     ------------------ */
/*     DFUVIN: Bornes du pave de definition en U et en V ou sont definies 
*/
/*             les contraintes CNTRIN. */
/*     NDIMEN: Dimension de l' espace. */
/*     IORDRE: Ordre de contrainte impose aux extremites de l'iso. */
/*             (Si Iso-U, on doit calculer les derivees en V et vice */
/*             versa). */
/*             = 0, on a calcule les extremites de l'iso */
/*             = 1, on a calcule, en plus, la derivee 1ere dans le sens */
/*                  de l'iso */
/*             = 2, on a calcule, en plus, la derivee 2nde dans le sens */
/*                  de l'iso */
/*     CNTRIN: Contient, si IORDRE>=0, les IORDRE+1 derivees */
/*             d'ordre IORDRE de F(Uc,v) ou de F(u,Vc), suivant la */
/*             valeur de ISOFAV, RENORMALISEES pour u et v dans (-1,1). */
/*     DUVOUT: Bornes du pave de definition en U et en V ou seront */
/*             definies les contraintes CNTOUT. */
/*     ISOFAV: Isoparametre fixe pour la discretisation; */
/*             = 1, on discretise a U=Uc fixe et V variable. */
/*             = 2, on discretise a V=Vc fixe et U variable. */
/*     IDERIV: Ordre de derivee transverse a l'iso fixee (Si Iso-U=Uc */
/*             fixee, on discretise la derivee d'ordre IDERIV en U de */
/*             F(Uc,v). Idem si on fixe une iso-V). */
/*             Varie de 0 (positionnement) a 2 (derivee 2nde). */

/*     ARGUMENTS DE SORTIE : */
/*     ------------------- */
/*     CNTOUT: Contient, si IORDRE>=0, les IORDRE+1 derivees */
/*             d'ordre IORDRE de F(Uc,v) ou de F(u,Vc), suivant la */
/*             valeur de ISOFAV, RENORMALISEES pour u et v dans DUVOUT. */

/*     COMMONS UTILISES   : */
/*     ---------------- */

/*     REFERENCES APPELEES   : */
/*     ----------------------- */

/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */
/*     CNTRIN peut etre un argument d'entree/sortie, */
/*     c'est a dire que l'appel: */

/*      CALL MMA1NOC(DFUVIN,NDIMEN,IORDRE,CNTRIN,DUVOUT */
/*     1           ,ISOFAV,IDERIV,CNTRIN) */

/*     est correct. */

/* $    HISTORIQUE DES MODIFICATIONS   : */
/*     -------------------------------- */
/*     10-02-1992: RBD; Creation. */
/* > */
/* ********************************************************************** 
*/

/*   Le nom de la routine */


    /* Parameter adjustments */
    dfuvin -= 3;
    --cntout;
    --cntrin;
    duvout -= 3;

    /* Function Body */
    ibb = mnfndeb_();
    if (ibb >= 3) {
	mgenmsg_("MMA1NOC", 7L);
    }

/* --------------- Determination des coefficients de normalisation -------
 */

    if (*isofav == 1) {
	d__1 = (dfuvin[4] - dfuvin[3]) / (duvout[4] - duvout[3]);
	rider = pow__di(&d__1, ideriv);
	d__1 = (dfuvin[6] - dfuvin[5]) / (duvout[6] - duvout[5]);
	riord = pow__di(&d__1, iordre);

    } else {
	d__1 = (dfuvin[6] - dfuvin[5]) / (duvout[6] - duvout[5]);
	rider = pow__di(&d__1, ideriv);
	d__1 = (dfuvin[4] - dfuvin[3]) / (duvout[4] - duvout[3]);
	riord = pow__di(&d__1, iordre);
    }

/* ------------- Renormalisation du vecteur de contrainte --------------- 
*/

    bid = rider * riord;
    i__1 = *ndimen;
    for (nd = 1; nd <= i__1; ++nd) {
	cntout[nd] = bid * cntrin[nd];
/* L100: */
    }

/* ------------------------------ The end ------------------------------- 
*/

    if (ibb >= 3) {
	mgsomsg_("MMA1NOC", 7L);
    }
    return 0;
} /* mma1noc_ */

