// File:	GeomConvert_ApproxCurve.cxx
// Created:	Thu Sep 11 15:50:30 1997
// Author:	Roman BORISOV
//		<rbv@toctox.nnov.matra-dtv.fr>


#include <Geom2dConvert_ApproxCurve.ixx>
#include <gp_Pnt2d.hxx>
#include <gp_Vec2d.hxx>
#include <Geom2dAdaptor_HCurve.hxx>
#include <TColStd_HArray1OfReal.hxx>
#include <AdvApprox_PrefAndRec.hxx>
#include <AdvApprox_ApproxAFunction.hxx>
#include <TColgp_Array1OfPnt2d.hxx>
#include <Precision.hxx>

static Handle(Adaptor2d_HCurve2d) fonct;
static Standard_Real StartEndSav[2];

extern "C" void myEval2d(Standard_Integer * Dimension,
		    	// Dimension
			Standard_Real    * StartEnd,
			// StartEnd[2]
			Standard_Real    * Param,
			// Parameter at which evaluation
			Standard_Integer * Order,
			// Derivative Request
			Standard_Real    * Result,
			// Result[Dimension]
			Standard_Integer * ErrorCode)
                        // Error Code
{
  *ErrorCode = 0;
  Standard_Real par = *Param;

// Dimension is incorrect
  if (*Dimension!=2) {
    *ErrorCode = 1;
  }
// Parameter is incorrect
  if ( par < StartEnd[0] || par > StartEnd[1] ) {
    *ErrorCode = 2;
  }
  if(StartEnd[0] != StartEndSav[0] || StartEnd[1]!= StartEndSav[1]) 
    {
      fonct = fonct->Trim(StartEnd[0],StartEnd[1],Precision::PConfusion());
      StartEndSav[0]=StartEnd[0];
      StartEndSav[1]=StartEnd[1];
    }

  gp_Pnt2d pnt;
  gp_Vec2d v1, v2;

  switch (*Order) {
  case 0:
    pnt = fonct->Value(par);
    Result[0] = pnt.X();
    Result[1] = pnt.Y();
    break;
  case 1:
    fonct->D1(par, pnt, v1);
    Result[0] = v1.X();
    Result[1] = v1.Y();
    break;
  case 2:
    fonct->D2(par, pnt, v1, v2);
    Result[0] = v2.X();
    Result[1] = v2.Y();
    break;
  default:
    Result[0] = Result[1] = 0.;
    *ErrorCode = 3;
    break;
  }
}

Geom2dConvert_ApproxCurve::Geom2dConvert_ApproxCurve(const Handle(Geom2d_Curve)& Curve,const Standard_Real Tol2d,const GeomAbs_Shape Order,const Standard_Integer MaxSegments,const Standard_Integer MaxDegree)
{
  Handle(Geom2dAdaptor_HCurve) HCurve = new Geom2dAdaptor_HCurve (Curve);

  // Initialisation of input parameters of AdvApprox

  Standard_Integer Num1DSS=0, Num2DSS=1, Num3DSS=0;
  Handle(TColStd_HArray1OfReal) OneDTolNul, ThreeDTolNul; 
  Handle(TColStd_HArray1OfReal) TwoDTol  = new TColStd_HArray1OfReal(1,Num2DSS);
  TwoDTol->Init(Tol2d); 

  fonct = HCurve;
  Standard_Real First = Curve->FirstParameter();
  Standard_Real Last  = Curve->LastParameter();
  StartEndSav[0]=First;
  StartEndSav[1]=Last;

  Standard_Integer NbInterv_C2 = HCurve->NbIntervals(GeomAbs_C2);
  TColStd_Array1OfReal CutPnts_C2(1, NbInterv_C2+1);
  HCurve->Intervals(CutPnts_C2,GeomAbs_C2);
  Standard_Integer NbInterv_C3 = HCurve->NbIntervals(GeomAbs_C3);
  TColStd_Array1OfReal CutPnts_C3(1, NbInterv_C3+1);
  HCurve->Intervals(CutPnts_C3,GeomAbs_C3);
  AdvApprox_PrefAndRec CutTool(CutPnts_C2,CutPnts_C3);

  myMaxError = 0;

//POP pour NT
  AdvApprox_EvaluatorFunction ev = myEval2d;
  AdvApprox_ApproxAFunction aApprox (Num1DSS, Num2DSS, Num3DSS, 
				     OneDTolNul, TwoDTol, ThreeDTolNul,
				     First, Last, Order,
				     MaxDegree, MaxSegments,
				     ev, CutTool);
//				     myEval2d, CutTool);

  myIsDone = aApprox.IsDone();
  myHasResult = aApprox.HasResult();

  if (myHasResult) {
    TColgp_Array1OfPnt2d Poles(1,aApprox.NbPoles());
    aApprox.Poles2d(1,Poles);
    Handle(TColStd_HArray1OfReal)    Knots = aApprox.Knots();
    Handle(TColStd_HArray1OfInteger) Mults = aApprox.Multiplicities();
    Standard_Integer Degree = aApprox.Degree();
    myBSplCurve = new Geom2d_BSplineCurve(Poles, Knots->Array1(), Mults->Array1(), Degree);
    myMaxError = aApprox.MaxError(2, 1);
  } 
}

 Handle(Geom2d_BSplineCurve) Geom2dConvert_ApproxCurve::Curve() const
{
  return myBSplCurve;
}

 Standard_Boolean Geom2dConvert_ApproxCurve::IsDone() const
{
  return myIsDone; 
}

 Standard_Boolean Geom2dConvert_ApproxCurve::HasResult() const
{
  return myHasResult; 
}

 Standard_Real Geom2dConvert_ApproxCurve::MaxError() const
{
  return myMaxError;
}

 void Geom2dConvert_ApproxCurve::Dump(Standard_OStream& o) const
{
  o << "******* Dump of ApproxCurve *******" << endl;
  o << "******* Error   " << MaxError() << endl;
}

