
#define VIRTUAL

// File		Graphic3d_GraphicDriver_703.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>
#include <Aspect_TypeOfMarker.hxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Marker (const Graphic3d_CGroup& , const Graphic3d_Vertex& , const Standard_Boolean ) {
#else
void Graphic3d_GraphicDriver::Marker (const Graphic3d_CGroup& ACGroup, const Graphic3d_Vertex& APoint, const Standard_Boolean EvalMinMax) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp1) (Graphic3d_CGroup *, CALL_DEF_MARKER *) = NULL;

	//if (! fp1) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_marker");
	    //fp1 = (void (*)(Graphic3d_CGroup *, CALL_DEF_MARKER *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

//static void (*fp3) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp3) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_markercontextgroup");
	    //fp3 = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

CALL_DEF_MARKER amarker;

	amarker.x	= float (APoint.X ());
	amarker.y	= float (APoint.Y ());
	amarker.z	= float (APoint.Z ());

Standard_Real R, G, B;
Aspect_TypeOfMarker AMType;
Standard_Real AScale;

	R	= Standard_Real (MyCGroup.GroupContextMarker.Color.r);
	G	= Standard_Real (MyCGroup.GroupContextMarker.Color.g);
	B	= Standard_Real (MyCGroup.GroupContextMarker.Color.b);
	AMType	= Aspect_TypeOfMarker (MyCGroup.GroupContextMarker.MarkerType);
	AScale	= Standard_Real (MyCGroup.GroupContextMarker.Scale);

int noinsert	= 0;
Standard_Real H, L, S;
Standard_Real LastS;
Standard_Real Limit, Delta;

	switch (AMType) {

		case Aspect_TOM_POINT :
		case Aspect_TOM_PLUS :
		case Aspect_TOM_STAR :
		case Aspect_TOM_O :
		case Aspect_TOM_X :
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);
		break;

		case Aspect_TOM_O_POINT :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);

			// we draw the point
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_POINT);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);
		break;

		case Aspect_TOM_O_PLUS :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);

			// we draw the plus
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_PLUS);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);
		break;

		case Aspect_TOM_O_STAR :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);

			// we draw the star
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_STAR);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);
		break;

		case Aspect_TOM_O_X :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);

			// we draw the cross
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_X);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker (&MyCGroup, &amarker);
		break;

		case Aspect_TOM_BALL :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw a set of circles
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			Delta	= 0.1;
			while (AScale > 0.0) {
				Quantity_Color::RgbHls (R, G, B, H, L, S);
				// Modification de la saturation de 5 %
				LastS	= S;
				S	= S - S * 0.05;
				if (S < 0.0) S = LastS;
				Quantity_Color::HlsRgb (H, L, S, R, G, B);
				MyCGroup.GroupContextMarker.Color.r	=
					Standard_ShortReal (R);
				MyCGroup.GroupContextMarker.Color.g	=
					Standard_ShortReal (G);
				MyCGroup.GroupContextMarker.Color.b	=
					Standard_ShortReal (B);
				MyCGroup.GroupContextMarker.Scale	=
					float (AScale);
				call_togl_markercontextgroup (&MyCGroup, noinsert);

				MyCGroup.GroupContextMarker.IsSet	= 1;

				if (MyTraceLevel) {
					PrintFunction ("call_togl_marker");
					PrintCGroup (MyCGroup, 1);
				}
				call_togl_marker (&MyCGroup, &amarker);
				AScale	-= Delta;
			}
		break;

		case Aspect_TOM_RING1 :
		case Aspect_TOM_RING2 :
		case Aspect_TOM_RING3 :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw a set of circles
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			if (AMType == Aspect_TOM_RING1)
				Limit	= AScale - AScale * 0.8;
			if (AMType == Aspect_TOM_RING2)
				Limit	= AScale - AScale * 0.5;
			if (AMType == Aspect_TOM_RING3)
				Limit	= AScale - AScale * 0.2;
			Delta	= 0.1;
			while (AScale > Limit) {
				MyCGroup.GroupContextMarker.Scale	=
					float (AScale);
				call_togl_markercontextgroup (&MyCGroup, noinsert);

				MyCGroup.GroupContextMarker.IsSet	= 1;

				if (MyTraceLevel) {
					PrintFunction ("call_togl_marker");
					PrintCGroup (MyCGroup, 1);
				}
				call_togl_marker (&MyCGroup, &amarker);
				AScale	-= Delta;
			}
		break;

	}

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::MarkerSet (const Graphic3d_CGroup& , const Graphic3d_Array1OfVertex& , const Standard_Boolean ) {
#else
void Graphic3d_GraphicDriver::MarkerSet (const Graphic3d_CGroup& ACGroup, const Graphic3d_Array1OfVertex& ListVertex, const Standard_Boolean EvalMinMax) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp2) (Graphic3d_CGroup *, CALL_DEF_LISTMARKERS *) = NULL;

	//if (! fp2) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_marker_set");
	    //fp2 = (void (*)(Graphic3d_CGroup *, CALL_DEF_LISTMARKERS *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

//static void (*fp3) (Graphic3d_CGroup *, int) = NULL;

	//if (! fp3) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_markercontextgroup");
	    //fp3 = (void (*)(Graphic3d_CGroup *, int)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

Standard_Integer Lower	= ListVertex.Lower ();
Standard_Integer Upper	= ListVertex.Upper ();

CALL_DEF_LISTMARKERS almarkers;

	almarkers.NbMarkers	= int (ListVertex.Length ());
	almarkers.Markers	= (CALL_DEF_MARKER *) &ListVertex (Lower);

Standard_Real R, G, B;
Aspect_TypeOfMarker AMType;
Standard_Real AScale;

	R	= Standard_Real (MyCGroup.GroupContextMarker.Color.r);
	G	= Standard_Real (MyCGroup.GroupContextMarker.Color.g);
	B	= Standard_Real (MyCGroup.GroupContextMarker.Color.b);
	AMType	= Aspect_TypeOfMarker (MyCGroup.GroupContextMarker.MarkerType);
	AScale	= Standard_Real (MyCGroup.GroupContextMarker.Scale);

int noinsert	= 0;
Standard_Real H, L, S;
Standard_Real LastS;
Standard_Real Limit, Delta;

	switch (AMType) {

		case Aspect_TOM_POINT :
		case Aspect_TOM_PLUS :
		case Aspect_TOM_STAR :
		case Aspect_TOM_O :
		case Aspect_TOM_X :
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);
		break;

		case Aspect_TOM_O_POINT :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);

			// we draw the point
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_POINT);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);
		break;

		case Aspect_TOM_O_PLUS :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);

			// we draw the plus
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_PLUS);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);
		break;

		case Aspect_TOM_O_STAR :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);

			// we draw the star
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_STAR);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);
		break;

		case Aspect_TOM_O_X :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw the circle
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			call_togl_markercontextgroup (&MyCGroup, noinsert);

			MyCGroup.GroupContextMarker.IsSet	= 1;

			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);

			// we draw the cross
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_X);
			call_togl_markercontextgroup (&MyCGroup, noinsert);
			if (MyTraceLevel) {
				PrintFunction ("call_togl_marker_set");
				PrintCGroup (MyCGroup, 1);
			}
			call_togl_marker_set (&MyCGroup, &almarkers);
		break;

		case Aspect_TOM_BALL :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw a set of circles
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			Delta	= 0.1;
			while (AScale > 0.0) {
				Quantity_Color::RgbHls (R, G, B, H, L, S);
				// Modification de la saturation de 5 %
				LastS	= S;
				S	= S - S * 0.05;
				if (S < 0.0) S = LastS;
				Quantity_Color::HlsRgb (H, L, S, R, G, B);
				MyCGroup.GroupContextMarker.Color.r	=
					Standard_ShortReal (R);
				MyCGroup.GroupContextMarker.Color.g	=
					Standard_ShortReal (G);
				MyCGroup.GroupContextMarker.Color.b	=
					Standard_ShortReal (B);
				MyCGroup.GroupContextMarker.Scale	=
					float (AScale);
				call_togl_markercontextgroup (&MyCGroup, noinsert);

				MyCGroup.GroupContextMarker.IsSet	= 1;

				if (MyTraceLevel) {
					PrintFunction ("call_togl_marker_set");
					PrintCGroup (MyCGroup, 1);
				}
				call_togl_marker_set (&MyCGroup, &almarkers);
				AScale	-= Delta;
			}
		break;

		case Aspect_TOM_RING1 :
		case Aspect_TOM_RING2 :
		case Aspect_TOM_RING3 :
			MyCGroup.GroupContextMarker.IsDef	= 1;

			// we draw a set of circles
			MyCGroup.GroupContextMarker.MarkerType	=
						int (Aspect_TOM_O);
			if (AMType == Aspect_TOM_RING1)
				Limit	= AScale - AScale * 0.8;
			if (AMType == Aspect_TOM_RING2)
				Limit	= AScale - AScale * 0.5;
			if (AMType == Aspect_TOM_RING3)
				Limit	= AScale - AScale * 0.2;
			Delta	= 0.1;
			while (AScale > Limit) {
				MyCGroup.GroupContextMarker.Scale	=
					float (AScale);
				call_togl_markercontextgroup (&MyCGroup, noinsert);

				MyCGroup.GroupContextMarker.IsSet	= 1;

				if (MyTraceLevel) {
					PrintFunction ("call_togl_marker_set");
					PrintCGroup (MyCGroup, 1);
				}
				call_togl_marker_set (&MyCGroup, &almarkers);
				AScale	-= Delta;
			}
		break;

	}

#endif
}
