
#define VIRTUAL

// File		Graphic3d_GraphicDriver_710.cxx
// Created	Mardi 28 janvier 1997
// Author	CAL
//      02.15.100 : JR : Clutter

//-Copyright	MatraDatavision 1997

//-Version	

//-Design	Declaration des variables specifiques aux Drivers

//-Warning	Un driver encapsule les Pex et OpenGl drivers

//-References	

//-Language	C++ 2.0

//-Declarations

// for the class
#include <Graphic3d_GraphicDriver.jxx>
#include <TCollection_AsciiString.hxx>

#include <Aspect_DriverDefinitionError.hxx>

extern "C" {
#include <InterfaceGraphic_Cextern.hxx>
}

//-Aliases

//-Global data definitions

//-Methods, in order

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ,
                       const Standard_CString ,
                       const Graphic3d_Vertex& ,
                       const Standard_Real ,
                       const Quantity_PlaneAngle ,
                       const Graphic3d_TextPath ,
                       const Graphic3d_HorizontalTextAlignment ,
                       const Graphic3d_VerticalTextAlignment ,
                       const Standard_Boolean 
                      ) {
#else
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const Standard_CString AText,
                       const Graphic3d_Vertex& APoint,
                       const Standard_Real AHeight,
                       const Quantity_PlaneAngle AAngle,
                       const Graphic3d_TextPath ATp,
                       const Graphic3d_HorizontalTextAlignment AHta,
                       const Graphic3d_VerticalTextAlignment AVta,
                       const Standard_Boolean EvalMinMax
                      ) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, CALL_DEF_TEXT *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_text");
	    //fp = (void (*)(Graphic3d_CGroup *, CALL_DEF_TEXT *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

Standard_Real X, Y, Z;

CALL_DEF_TEXT atext;
	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (AAngle);
	atext.Path		= int (ATp);
	atext.HAlign		= int (AHta);
	atext.VAlign		= int (AVta);
	atext.string		= (char *) AText;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ,
                       const Standard_CString , 
                       const Graphic3d_Vertex& , 
                       const Standard_Real , 
                       const Standard_Boolean 
                      ) {
#else
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const Standard_CString AText, 
                       const Graphic3d_Vertex& APoint, 
                       const Standard_Real AHeight, 
                       const Standard_Boolean EvalMinMax
                      ) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, CALL_DEF_TEXT *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_text");
	    //fp = (void (*)(Graphic3d_CGroup *, CALL_DEF_TEXT *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

Standard_Real X, Y, Z;

CALL_DEF_TEXT atext;
	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (Standard_PI / 2.);
	atext.Path		= int (Graphic3d_TP_RIGHT);
	atext.HAlign		= int (Graphic3d_HTA_NORMAL);
	atext.VAlign		= int (Graphic3d_VTA_NORMAL);
	atext.string		= (char *) AText;

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ,
                       const TCollection_ExtendedString& , 
                       const Graphic3d_Vertex& , 
                       const Standard_Real , 
                       const Quantity_PlaneAngle , 
                       const Graphic3d_TextPath , 
                       const Graphic3d_HorizontalTextAlignment , 
                       const Graphic3d_VerticalTextAlignment , 
                       const Standard_Boolean 
                      ) {
#else
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const TCollection_ExtendedString& AText, 
                       const Graphic3d_Vertex& APoint, 
                       const Standard_Real AHeight, 
                       const Quantity_PlaneAngle AAngle, 
                       const Graphic3d_TextPath ATp, 
                       const Graphic3d_HorizontalTextAlignment AHta, 
                       const Graphic3d_VerticalTextAlignment AVta, 
                       const Standard_Boolean EvalMinMax
                      ) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, CALL_DEF_TEXT *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_text");
	    //fp = (void (*)(Graphic3d_CGroup *, CALL_DEF_TEXT *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

Standard_Real X, Y, Z;

CALL_DEF_TEXT atext;
	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (AAngle);
	atext.Path		= int (ATp);
	atext.HAlign		= int (AHta);
	atext.VAlign		= int (AVta);
	atext.string	= TCollection_AsciiString (AText).ToCString ();

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);

#endif
}

#ifdef VIRTUAL
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ,
                       const TCollection_ExtendedString& , 
                       const Graphic3d_Vertex& , 
                       const Standard_Real , 
                       const Standard_Boolean 
                      ) {
#else
void Graphic3d_GraphicDriver::Text (
                       const Graphic3d_CGroup& ACGroup,
                       const TCollection_ExtendedString& AText, 
                       const Graphic3d_Vertex& APoint, 
                       const Standard_Real AHeight, 
                       const Standard_Boolean EvalMinMax
                      ) {

Graphic3d_CGroup MyCGroup = ACGroup;

//static void (*fp) (Graphic3d_CGroup *, CALL_DEF_TEXT *) = NULL;

	//if (! fp) {
	    //OSD_Function osdfp = NULL;
	    //osdfp = MySharedLibrary.DlSymb ("call_togl_text");
	    //fp = (void (*)(Graphic3d_CGroup *, CALL_DEF_TEXT *)) osdfp;
	    //if (! osdfp)
		//Aspect_DriverDefinitionError::Raise
			//(MySharedLibrary.DlError ());
	//}

Standard_Real X, Y, Z;

CALL_DEF_TEXT atext;
	APoint.Coord (X, Y, Z);
	atext.Position.x	= float (X);
	atext.Position.y	= float (Y);
	atext.Position.z	= float (Z);
	atext.Height		= float (AHeight);
	atext.Angle		= float (Standard_PI / 2.);
	atext.Path		= int (Graphic3d_TP_RIGHT);
	atext.HAlign		= int (Graphic3d_HTA_NORMAL);
	atext.VAlign		= int (Graphic3d_VTA_NORMAL);
	atext.string	= TCollection_AsciiString (AText).ToCString ();

	if (MyTraceLevel) {
		PrintFunction ("call_togl_text");
		PrintCGroup (MyCGroup, 1);
	}
	call_togl_text (&MyCGroup, &atext);

#endif
}
