// File:	IntImpParGen_Tool.cxx
// Created:	Wed Jun 10 15:06:44 1992
// Author:	Laurent BUCHARD
//		<lbr@sdsun2>

#include <IntImpParGen_Tool.hxx>
#include <gp.hxx>


#define TOLERANCE_ANGULAIRE 0.00000001

//----------------------------------------------------------------------
Standard_Real NormalizeOnDomain(Standard_Real& Param,const IntRes2d_Domain& TheDomain) {
  Standard_Real modParam = Param;
  if(TheDomain.IsClosed()) {
    Standard_Real Periode,t;
    TheDomain.EquivalentParameters(t,Periode);
    Periode-=t;
    if(TheDomain.HasFirstPoint()) {
      while(modParam<TheDomain.FirstParameter()) {
	modParam+=Periode;
      }
    }
    if(TheDomain.HasLastPoint()) {
      if(modParam>TheDomain.LastParameter()) {
	modParam-=Periode;
      }
    }
  }
  return(modParam);
}
//----------------------------------------------------------------------
void Determine_Position(IntRes2d_Position& Pos1,
			const IntRes2d_Domain& TheDomain,
			const gp_Pnt2d& Pnt1,
			const Standard_Real Param1) {
  
  Pos1=IntRes2d_Middle;

  if(TheDomain.HasFirstPoint()) { 
    if(Pnt1.Distance(TheDomain.FirstPoint()) 
       <= TheDomain.FirstTolerance()) {
      Pos1=IntRes2d_Head; 	
    }
  }
   
  if(TheDomain.HasLastPoint()) {
    if(Pnt1.Distance(TheDomain.LastPoint()) 
       <= TheDomain.LastTolerance()) {
      if(Pos1==IntRes2d_Head) {
	if(Abs(Param1-TheDomain.LastParameter())
	   < Abs(Param1-TheDomain.FirstParameter()))
	  Pos1=IntRes2d_End; 	
      }
      else {
	Pos1=IntRes2d_End; 
      }
    } 
  }
}   
//----------------------------------------------------------------------
void Determine_Transition(const IntRes2d_Position    Pos1,
			  gp_Vec2d&                  Tan1,
			  const gp_Vec2d&            Norm1,
			  IntRes2d_Transition&       T1,
			  const IntRes2d_Position    Pos2,
			  gp_Vec2d&                  Tan2,
			  const gp_Vec2d&            Norm2,
			  IntRes2d_Transition&       T2,
//			  const Standard_Real        Tolerance_Angulaire) {
			  const Standard_Real        ) {
  
  Standard_Boolean courbure1=Standard_True;
  Standard_Boolean courbure2=Standard_True;
  Standard_Boolean decide=Standard_True;
  if (Tan1.Magnitude()<=gp::Resolution()) {
    Tan1=Norm1;
    courbure1=Standard_False;
    if (Tan1.Magnitude()<=gp::Resolution()) {    // transition undecided
      decide=Standard_False;
    }
  }
  
  if (Tan2.Magnitude()<=gp::Resolution()) {
    Tan2=Norm2;
    courbure2=Standard_False;
    if (Tan2.Magnitude()<=gp::Resolution()) {    // transition undecided
      decide=Standard_False;
    }
  }
  
  if (!decide) {
    T1.SetValue(Pos1);
    T2.SetValue(Pos2);
  }
  else {
    Standard_Real sgn=Tan1.Crossed(Tan2);
    Standard_Real norm=Tan1.Magnitude()*Tan2.Magnitude();

    if (Abs(sgn)<=TOLERANCE_ANGULAIRE*norm) {   // Transition TOUCH #########
      Standard_Boolean opos=(Tan1.Dot(Tan2))<0;
      if (!(courbure1||courbure2)) {
	T1.SetValue(Standard_True,Pos1,IntRes2d_Unknown,opos);
	T2.SetValue(Standard_True,Pos2,IntRes2d_Unknown,opos);
      }
      else {
	gp_Vec2d Norm;
	Tan1.Normalized();
	Norm.SetCoord(-Tan1.Y(),Tan1.X());
	Standard_Real Val1,Val2;
	if (!courbure1) {
	  Val1=0.0;
	}
	else {
	  Val1=Norm.Dot(Norm1);
	}
	if (!courbure2) {
	  Val2=0.0;
	}
	else {
	  Val2=Norm.Dot(Norm2);
	}
	
	if (Abs(Val1-Val2) <= gp::Resolution()) {
	  T1.SetValue(Standard_True,Pos1,IntRes2d_Unknown,opos);
	  T2.SetValue(Standard_True,Pos2,IntRes2d_Unknown,opos);
	}
	else if (Val2 > Val1) {
	  T2.SetValue(Standard_True,Pos2,IntRes2d_Inside,opos);
	  if (opos) {
	    T1.SetValue(Standard_True,Pos1,IntRes2d_Inside,opos);
	  }
	  else {
	    T1.SetValue(Standard_True,Pos1,IntRes2d_Outside,opos);
	  }
	}
	else {         // Val1 > Val2
	  T2.SetValue(Standard_True,Pos2,IntRes2d_Outside,opos);
	  if (opos) {
	    T1.SetValue(Standard_True,Pos1,IntRes2d_Outside,opos);
	  }
	  else {
	    T1.SetValue(Standard_True,Pos1,IntRes2d_Inside,opos);
	  }
	}
      }
    }
    else if (sgn<0) {
      T1.SetValue(Standard_False,Pos1,IntRes2d_In);
      T2.SetValue(Standard_False,Pos2,IntRes2d_Out);
    }
    else {     // sgn>0
      T1.SetValue(Standard_False,Pos1,IntRes2d_Out);
      T2.SetValue(Standard_False,Pos2,IntRes2d_In);
    }
  }
}

