// File:	MeshVS_TwoNodes.cxx
// Created:	Mon Jan 24 2005
// Author:	Alexander SOLOVYOV
// Copyright:	 Open CASCADE 2005

#include <MeshVS_TwoNodes.hxx>


//================================================================
// Function : HashCode
// Purpose  :
//================================================================
Standard_Integer HashCode( const MeshVS_TwoNodes& obj,
                           const Standard_Integer Upper )
{
  // symmetrical with respect to obj.First and obj.Second
  const Standard_Integer aKey = obj.First + obj.Second;
  return HashCode (aKey, Upper);
}

//================================================================
// Function : operator ==
// Purpose  :
//================================================================
Standard_Boolean operator==( const MeshVS_TwoNodes& obj1,
                             const MeshVS_TwoNodes& obj2 )
{
  return ( ( obj1.First == obj2.First  ) && ( obj1.Second == obj2.Second ) ) ||
         ( ( obj1.First == obj2.Second ) && ( obj1.Second == obj2.First  ) );
}
