/* MASEMH.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Table of constant values */

static integer c__63 = 63;

/* Subroutine */ int mmasemh_(ndimen, nbrpnt, ndecop, ncoefs, ordher, dimmat, 
	nistoc, tparam, hdecal, tpospt, typept, tdecop, tasemh, aposit, math1,
	 math2, math3, tpoint, tbpoid, poids, matsys, vecsys, iercod)
integer *ndimen, *nbrpnt, *ndecop, *ncoefs, *ordher, *dimmat, *nistoc;
doublereal *tparam;
integer *hdecal, *tpospt, *typept;
doublereal *tdecop;
integer *tasemh, *aposit;
doublereal *math1, *math2, *math3, *tpoint, *tbpoid, *poids, *matsys, *vecsys;
integer *iercod;
{
    /* System generated locals */
    integer tasemh_dim1, tasemh_offset, tpoint_dim1, tpoint_offset, i__1, 
	    i__2, i__3;
    doublereal d__1, d__2;

    /* Builtin functions */
    double pow__di();

    /* Local variables */
    static logical ldbg;
    static doublereal base[21];
    static doublereal vdif, vsom;
    static integer dimh0;
    static doublereal cteh2, cteh3, math0[441];
    static integer iaux1, iaux2, iaux3, e, i__, j, k, l;
    static doublereal mfact;
    static integer dimva, nderi, order, istoc;
    static long int iofva, ivec; /* Variable offset pmn */
    static doublereal auxil, mfact1, mfact2, mfact3;
    static integer ig, jg;
    static doublereal sparam;
    static logical stocke;
    static doublereal ctenor, vecaux[63];
    extern /* Subroutine */ int macrar8_(), macrdr8_();
    static integer ier;
    extern integer mnfndeb_();
    static integer ipt;
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mmpobas_(), mswrdbg_()
	    , msrfill_(), mgsomsg_(), mvriraz_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       ASSEMBLAGE DE LA MATRICE HESSIENNE */

/*     MOTS CLES : */
/*     ----------- */
/*      RESERVE, LISSAGE, ASSEMBLAGE, HESSIEN */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*       NDIMEN: DIMENSION DE L'ESPACE */
/*       NBRPNT : NOMBRE DE POINTS */
/*       NDECOP: NOMBRE DE DECOUPE */
/*       NCOEFS: DEGRE DU POLYNOME */
/*       ORDHER: ORDRE D'HERMITE */
/*       DIMMAT: DIMENSION DE LA MATRICE HESSIENNE */
/*       NISTOC: NOMBRE DE TERMES DANS LE PRODIL DE LA MATRICE HESSIENNE 
*/
/*       TPARAM: TABLE DES PARAMETRES DES POINTS */
/*       HDECAL: DECALAGE PERMETTANT DE CALCULER LES INDICES GLOBAUX */
/*               DE LA MATRICE HESSIENNE POUR AUTRES COMPOSANTES */
/*       TPOSPT: TABLE DONNANT LA POSITION DES POINTS */
/*       TYPEPT: TABLE DONNANT LE TYPE DE POINT ((0) A LISSER OU */
/*               (1) CONTRAINT) */
/*       TDECOP: TABLE DE DECOUPE DU DOMAINE DE DEFINITION (0,1) */
/*               DE LA COURBE */
/*               U(0)=0<U(1)<...<U(NDECOP)=1 */

/*       TASEMH: TABLE D'ASSEMBLLAGE DE LA MATRICE HESSIENNE */
/*       APOSIT: TABLE DONNANT LA LARGEUR DE BANDE ET L'INDICE DE */
/*               STOCKAGE DES TERMES DIAGONAUX DE LA MATRICE HESSIENNE */
/*       MATH1,MATH2,MATH3: MATRICE DES FORMES QUADRATIQUES SUR (-1,1) */
/*                          DES CRITERES DE QUALITE */
/*       TPOINT: TABLE DES COORDONNEES DES POINTS */
/*       POIDS(): COEFFICIENT DE POIDS */
/*                POIDS(1) POIDS ASSOCIE AU CRITERE DES MOINDRES CARRES */
/*                POIDS(2) POIDS ASSOCIEE A LA COMBINAISON LINEAIRE DES */
/*                         CRITERES DE QUALITES */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*       MATSYS: MATRICE DE STOCKAGE DE LA MATRICE HESSIENNE */
/*       VECSYS: VECTEUR DU SECOND MEMBRE CORRESPONDANT */

/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     25-08-95 : KHN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */




/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    --tbpoid;
    tpoint_dim1 = *ndimen;
    tpoint_offset = tpoint_dim1 + 1;
    tpoint -= tpoint_offset;
    --typept;
    --tpospt;
    --tparam;
    --math3;
    --math2;
    --math1;
    tasemh_dim1 = *ndecop;
    tasemh_offset = tasemh_dim1 + 1;
    tasemh -= tasemh_offset;
    --vecsys;
    aposit -= 3;
    --matsys;
    --poids;

    /* Function Body */
    ldbg = mnfndeb_() >= 3;
    if (ldbg) {
	mgenmsg_("MMASEMH", 7L);
    }
    *iercod = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */

    if (*nistoc <= 0) {
	goto L9101;
    }

    dimh0 = *ncoefs * (*ncoefs + 1) / 2;

    if (*ncoefs > 21) {
	goto L9101;
    }
    if (dimh0 > 441) {
	goto L9101;
    }

    dimva = *ndimen * *ncoefs;
    macrar8_(&dimva, &c__63, vecaux, &iofva, &ier);
    if (ier > 0) {
	goto L9102;
    }


    mvriraz_(&dimh0, math0);
    mvriraz_(&c__63, vecaux);

    mvriraz_(nistoc, &matsys[1]);
    mvriraz_(dimmat, &vecsys[1]);

    ipt = 1;
    stocke = FALSE_;
    iaux1 = *ordher + 1;
    iaux3 = iaux1 + 1;
    iaux2 = iaux1 << 1;
    nderi = 0;


    i__1 = *ndecop;
    for (e = 1; e <= i__1; ++e) {

	vsom = tdecop[e - 1] + tdecop[e];
	vdif = 1. / (tdecop[e] - tdecop[e - 1]);

/*      CALCUL LA MATRICE MATH0 DES CRITERES DES MOINDRES CARRES */
/*      EN ABMSCISSE */
/*      ET LE VECTEUR DU SECOND MEMBRE CORRESPONDANT */

	while(ipt <= *nbrpnt && tpospt[ipt] == e) {
	    if (typept[ipt] == 0) {
		stocke = TRUE_;
		sparam = (tparam[ipt] * 2. - vsom) * vdif;
		mmpobas_(&sparam, ordher, ncoefs, &nderi, base, &ier);
		if (ier > 0) {
		    goto L9101;
		}

		k = 0;
		i__2 = *ncoefs;
		for (i__ = 1; i__ <= i__2; ++i__) {
		    auxil = base[i__ - 1] * tbpoid[ipt];
		    i__3 = i__;
		    for (j = 1; j <= i__3; ++j) {
			++k;
			math0[k - 1] += auxil * base[j - 1];
		    }
		    ivec = i__ + iofva;
		    i__3 = *ndimen;
		    for (l = 1; l <= i__3; ++l) {
			vecaux[ivec - 1] += tpoint[l + ipt * tpoint_dim1] * 
				auxil;
			ivec += *ncoefs;
		    }
		}
	    }

	    ++ipt;
	}



	ctenor = (tdecop[e] - tdecop[e - 1]) / 2;
/* Computing 3rd power */
	d__1 = ctenor, d__2 = d__1;
	cteh2 = 1. / (d__2 * (d__1 * d__1));
/* Computing 5th power */
	d__1 = ctenor, d__2 = d__1, d__1 *= d__1;
	cteh3 = 1. / (d__2 * (d__1 * d__1));



	k = 0;
	i__2 = *ncoefs;
	for (i__ = 1; i__ <= i__2; ++i__) {
	    ig = tasemh[e + i__ * tasemh_dim1];

	    if (i__ <= iaux1) {
		order = i__ - 1;
	    } else {
		if (i__ <= iaux2) {
		    order = i__ - iaux3;
		} else {
		    order = 0;
		}
	    }

	    mfact1 = pow__di(&ctenor, &order);
	    mfact3 = mfact1 * 2 * poids[1];


	    i__3 = i__;
	    for (j = 1; j <= i__3; ++j) {
		jg = tasemh[e + j * tasemh_dim1];

		if (j <= iaux1) {
		    order = j - 1;
		} else {
		    if (j <= iaux2) {
			order = j - iaux3;
		    } else {
			order = 0;
		    }
		}

		mfact2 = pow__di(&ctenor, &order);
		++k;


		if (ig >= jg) {
		    istoc = aposit[(ig << 1) + 2] - ig + jg;
		} else {
		    istoc = aposit[(jg << 1) + 2] - jg + ig;
		}
		mfact = mfact1 * 2 * mfact2;

/*     STOKAGE DES CRITERES DES MC */

		if (stocke) {
		    matsys[istoc] += math0[k - 1] * mfact * poids[1];
		}

/*      STOCKAGE DES CRITERES INTEGRAUX */

		auxil = math1[k] * (mfact / ctenor) + math2[k] * (mfact * 
			cteh2) + math3[k] * (mfact * cteh3);
		matsys[istoc] += auxil * poids[2];
	    }

/*      STOCKAGE DANS LE VECTEUR SECOND MEMBRE DES TERMES */
/*      CORRESPONDANTS AUX CRITERES DES MC */

	    if (stocke) {
		istoc = ig;
		ivec = i__ + iofva;
		i__3 = *ndimen;
		for (l = 1; l <= i__3; ++l) {
		    vecsys[istoc] += mfact3 * vecaux[ivec - 1];
		    istoc += *hdecal;
		    ivec += *ncoefs;
		}
	    }


	}



	mvriraz_(&dimh0, math0);
	mvriraz_(&dimva, &vecaux[iofva]);
	stocke = FALSE_;
    }



/*        Pour les dimensions suivante on recopie */

    i__1 = *ndimen;
    for (l = 2; l <= i__1; ++l) {
	istoc = (l - 1) * aposit[(*hdecal << 1) + 2] + 1;
	msrfill_(&aposit[(*hdecal << 1) + 2], &matsys[1], &matsys[istoc]);
    }





    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */


L9101:
    *iercod = 1;
    goto L9999;

L9102:
    mswrdbg_("MODELE : PROBLEME AVEC DIMVEC", 29L);
    *iercod = 2;

/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:

/* ___ DESALLOCATION, ... */
    macrdr8_(&dimva, &c__63, vecaux, &iofva, &ier);
    if (*iercod == 0 && ier > 0) {
	*iercod = 3;
    }

    maermsg_("MMASEMH", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMASEMH", 7L);
    }
 return 0 ;
} /* mmasemh_ */

