/* MLIACR.f -- translated by f2c (version 19960827).
   You must link the resulting object file with the libraries:
	-lf2c -lm   (in that order)
*/

#include "Data_f2c.h"

/* Table of constant values */

static integer c__100 = 100;

/* Subroutine */ int mmliacr_(ndimen, ncflim, nbrpnt, nbcntr, typcnt, tabpar, 
	nbcrbe, ncftab, crbtab, tabint, epslon, decima, cblong, iercod)
integer *ndimen, *ncflim, *nbrpnt, *nbcntr, *typcnt;
doublereal *tabpar;
integer *nbcrbe, *ncftab;
doublereal *crbtab, *tabint, *epslon;
integer *decima;
doublereal *cblong;
integer *iercod;
{
    /* System generated locals */
    integer crbtab_dim1, crbtab_dim2, crbtab_offset, i__1, i__2;

    /* Local variables */
    static logical ldbg;
    static integer icrb, iold;
    static doublereal lold, tcrb;
    static integer icnt, pold;
    static doublereal sold, told, uold;
    static integer pcnt, ipnt;
    static doublereal snew, unew, clong, dlong, tpara, ratio, dtinv, xlong[
	    100], vtest;
    static integer ii;
    static doublereal deltat;
    static long int iofset;
    static doublereal erreur;
    extern /* Subroutine */ int mmcglc1_(), macrar8_(), macrdr8_();
    static integer ier;
    extern integer mnfndeb_();
    extern /* Subroutine */ int maermsg_(), mgenmsg_(), mgsomsg_();



/* < */
/* **NOTICE */
/*  THIS SOFTWARE IS THE PROPERTY OF CISIGRAPH. */
/*  THIS CODE MUST NOT BE DISTRIBUTED OR COPIED WITHOUT THE PRIOR */
/*  WRITTEN PERMISSION OF CISIGRAPH AND IS ONLY TO BE USED ON THE */
/*  SITE WHERE IT IS INSTALLED BY CISIGRAPH */
/* **NOTICE */

/* ***********************************************************************
 */

/*     FONCTION : */
/*     ---------- */
/*       Cacul des parametres ACR correspondant aux points. */

/*     MOTS CLES : */
/*     ----------- */
/*      RESERVE, LISSAGE, VARIATIONNEL, COURBE, ACR, EN_DEVELOPPEMENT */

/*     ARGUMENTS D'ENTREE : */
/*     -------------------- */
/*     NDIMEN : Dimension de l'espace */
/*     NCFLIM : Nombre max de coeff des courbes */
/*     NBRPNT : Nombre de points a lisser  (>= 2) */
/*     NBCNTR : Nombre de point contraints (<= NBRPNT) */
/*     TYPCNT : Tableau caracterisant les points contraints */
/*     TYPCNT(1,i) :  Indice du point contraints */
/*     TYPCNT(2,i) :  Type de la contrainte */
/*                    0 -> de passage (G0) */
/*                    1 -> de tangence (G1) */
/*                    2 -> de courbure (G2) */
/*     TABPAR : Tableaux des paramtres corespondant aux points a lisser */
/*     NBCRBE : Nombre de courbes polynomiales creees. */
/*     NCFTAB : Table des nombres de coeff. significatifs des NBCRBE */
/*              "courbes" calculees. */
/*     CRBTAB : Tableau des coeff. des "courbes" polynomiales calculees. 
*/
/*     TABINT : Table des NBCRBE + 1 bornes des intervalles de decoupe */

/*     ARGUMENTS DE SORTIE : */
/*     --------------------- */
/*     TABPAR : Tableaux des ACR corespondant aux points a lisser */
/*     TABINT : Table des NBCRBE + 1 ACR des intervalles de decoupe */
/*     CBLONG : Longueur de la super courbe lissee. */
/*     IERCOD : code d'erreur */
/*     - 1 : Imprecision dans le calcul de l'ACR */
/*     0   : Ok */
/*     > 0 : Echec */

/*     COMMONS UTILISES : */
/*     ------------------ */


/*     REFERENCES APPELEES : */
/*     --------------------- */


/*     DESCRIPTION/REMARQUES/LIMITATIONS : */
/*     ----------------------------------- */


/* $    HISTORIQUE DES MODIFICATIONS : */
/*     ------------------------------ */
/*     4-10-1996 : PMN; ATTENTION AUX DIVISION PAR ZERO POUR OSF ET SUN */
/*     10-10-1995: PMN; ECRITURE VERSION ORIGINALE. */
/* > */
/* ***********************************************************************
 */
/*                            DECLARATIONS */
/* ***********************************************************************
 */





/* ***********************************************************************
 */
/*                      INITIALISATIONS */
/* ***********************************************************************
 */

    /* Parameter adjustments */
    --tabpar;
    typcnt -= 3;
    crbtab_dim1 = *ndimen;
    crbtab_dim2 = *ncflim;
    crbtab_offset = crbtab_dim1 * (crbtab_dim2 + 1) + 1;
    crbtab -= crbtab_offset;
    --ncftab;

    /* Function Body */
    ldbg = mnfndeb_() >= 2;
    if (ldbg) {
	mgenmsg_("MMLIACR", 7L);
    }
    *iercod = 0;

/* ***********************************************************************
 */
/*                     TRAITEMENT */
/* ***********************************************************************
 */


    macrar8_(nbcrbe, &c__100, xlong, &iofset, &ier);
    if (ier > 0) {
	goto L9103;
    }

/*     (1) Calcul de la longueur des courbes */

    *cblong = 0.;
    i__1 = *nbcrbe;
    for (icrb = 1; icrb <= i__1; ++icrb) {

	sold = -1.;
	if (icrb == 1) {
	    sold = (tabpar[1] * 2 - tabint[1]) / tabint[1];
	}

	snew = 1.;
	if (icrb == *nbcrbe) {
	    snew = (tabpar[*nbrpnt] * 2 - tabint[*nbcrbe - 1] - 1.) / (1. - 
		    tabint[*nbcrbe - 1]);
	}

	mmcglc1_(ndimen, ndimen, &ncftab[icrb], &crbtab[(icrb * crbtab_dim2 + 
		1) * crbtab_dim1 + 1], &sold, &snew, epslon, &xlong[icrb + 
		iofset - 1], &erreur, &ier);
	if (ier == 1) {
	    *iercod = -1;
	}
	if (ier > 1) {
	    goto L9102;
	}

	*cblong += xlong[icrb + iofset - 1];

    }


/*     (2)  Mise de l'acr dans TABPAR */

    if (*nbrpnt >= 2) {

/*     (2.0) Initialisation */
	deltat = (tabpar[*nbrpnt] - tabpar[1]) / *decima;
	vtest = tabpar[1] + deltat;
	if (*nbcntr > 0) {
	    pcnt = typcnt[3];
	    icnt = 1;
	} else {
	    pcnt = *nbrpnt + 1;
	}

	uold = 0.;
	clong = 0.;
	lold = 0.;
	sold = (tabpar[1] * 2 - tabint[1]) / tabint[1];
	iold = 0;
	tcrb = 0.;
	icrb = 0;
	told = tabpar[1];
	pold = 1;

	tabpar[1] = 0.;

	i__1 = *nbrpnt;
	for (ipnt = 2; ipnt <= i__1; ++ipnt) {

/*        (2.1) Recheche de la prochaine contrainte */

	    while(icnt < *nbcntr && pcnt < ipnt) {
		++icnt;
		pcnt = typcnt[(icnt << 1) + 1];
	    }




	    tpara = tabpar[ipnt];

	    if (pcnt == ipnt || tpara >= vtest) {

/*          Si on trop proche du bout on prend le tout */
/*          sinon on s'expose a des divisions par zero.   */

            if ( tabpar[*nbrpnt]-tpara <= 1.e-2*deltat) {
	      ipnt = *nbrpnt;
              tpara = tabpar[ipnt];
	    }

/*        (2.2) Cacul la longueur des precedentes courbes */

		while(tpara > tabint[icrb + 1] && icrb < *nbcrbe - 1) {
		    ++icrb;
		    clong += xlong[icrb + iofset - 1];
		    tcrb = tabint[icrb];
		}

		if (icrb > iold) {
		    sold = -1.;
		    lold = clong / *cblong;
		}

/*         (2.3) Calcul la longueur du dernier morceau de cour
be */

		snew = (tpara * 2 - tabint[icrb + 1] - tcrb) / (tabint[icrb + 
			1] - tcrb);
		ii = icrb + 1;

		mmcglc1_(ndimen, ndimen, &ncftab[ii], &crbtab[(ii * 
			crbtab_dim2 + 1) * crbtab_dim1 + 1], &sold, &snew, 
			epslon, &dlong, &erreur, &ier);
		if (ier == 1) {
		    *iercod = -1;
		}
		if (ier > 1) {
		    goto L9102;
		}

		unew = lold + dlong / *cblong;

/*         (2.4) Mise a jours des parametres de decoupe */

		dtinv = 1. / (tpara - told);

		i__2 = icrb;
		for (ii = iold + 1; ii <= i__2; ++ii) {
		    ratio = (tabint[ii] - told) * dtinv;
		    tabint[ii] = uold + ratio * (unew - uold);
		}

/*           (2.5) Mise a jours des parametres de points. */

		i__2 = ipnt - 1;
		for (ii = pold + 1; ii <= i__2; ++ii) {
		    ratio = (tabpar[ii] - told) * dtinv;
		    tabpar[ii] = uold + ratio * (unew - uold);
		}

		tabpar[ipnt] = unew;

		uold = unew;
		lold = unew;
		sold = snew;
		iold = icrb;
		told = tpara;
		pold = ipnt;

	    }

/*        --> Nouveau seuil parametrique pour le decimage */

	    if (tpara >= vtest) {
		ii = (integer) ((tpara - vtest + 1e-8) / deltat);
		vtest += (ii + 1) * deltat;
		if (vtest > .99999998999999995) {
		    vtest = 1.;
		}
	    }

	}

    }

/*     --- On ajuste les valeurs extremes */

    tabpar[1] = 0.;
    tabpar[*nbrpnt] = 1.;
    ii = *nbrpnt-1;
    while ( tabpar[ii] > tabint[*nbcrbe]) {
      tabpar[ii] = 1.;
      --ii;
    }
    tabint[0] = 0.;
    tabint[*nbcrbe] = 1.;

    goto L9999;

/* ***********************************************************************
 */
/*                   TRAITEMENT DES ERREURS */
/* ***********************************************************************
 */

L9102:
    *iercod = 2;
    goto L9999;

L9103:
    *iercod = 3;

/* ***********************************************************************
 */
/*                   RETOUR PROGRAMME APPELANT */
/* ***********************************************************************
 */

L9999:

    macrdr8_(nbcrbe, &c__100, xlong, &iofset, &ier);
    if (ier > 0 && *iercod <= 0) {
	*iercod = 3;
    }

    maermsg_("MMLIACR", iercod, 7L);
    if (ldbg) {
	mgsomsg_("MMLIACR", 7L);
    }
 return 0 ;
} /* mmliacr_ */

