// File:	StepToGeom_MakeBSplineSurface.cxx
// Created:	Fri Jul  2 12:05:11 1993
// Author:	Martine LANGLOIS
//		<mla@mastox>

#include <StepToGeom_MakeBSplineSurface.ixx>
#include <StepGeom_BSplineSurfaceWithKnots.hxx>
#include <StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface.hxx>
#include <TColStd_Array1OfInteger.hxx>
#include <TColStd_Array1OfReal.hxx>
#include <TColgp_Array2OfPnt.hxx>
#include <TColStd_HArray1OfInteger.hxx>
#include <TColStd_HArray1OfReal.hxx>
#include <TColStd_HArray2OfReal.hxx>
#include <StepGeom_HArray2OfCartesianPoint.hxx>
#include <StepGeom_CartesianPoint.hxx>
#include <StepToGeom_MakeCartesianPoint.hxx>
#include <Geom_CartesianPoint.hxx>
#include <gp_Pnt.hxx>
#include <StdFail_NotDone.hxx>

//=============================================================================
// Creation d' une BSplineSurface de Geom a partir d' une
// BSplineSurface de Step
//=============================================================================

StepToGeom_MakeBSplineSurface::StepToGeom_MakeBSplineSurface
  ( const Handle(StepGeom_BSplineSurface)& S)

{
  Standard_Integer                    i, j, UDeg, VDeg, NUPoles, NVPoles;
  Standard_Integer                    NUKnots, NVKnots, Itampon;
  Standard_Real                       Tampon;
  Handle(StepGeom_CartesianPoint) P;
  Handle(Geom_CartesianPoint)         P1;
  gp_Pnt                              P2;
  Handle(StepGeom_HArray2OfCartesianPoint) aControlPointsList;
  Handle(TColStd_HArray1OfInteger)             aUMultiplicities;
  Handle(TColStd_HArray1OfInteger)             aVMultiplicities; 
  Handle(TColStd_HArray1OfReal)                aUKnots;
  Handle(TColStd_HArray2OfReal)                aWeight;
  Handle(TColStd_HArray1OfReal)                aVKnots;
  Handle(StepGeom_BSplineSurfaceWithKnots) BS;
  Handle(StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface) BSR;

  if (S->
      IsKind(STANDARD_TYPE(StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface))) {
    BSR = 
      Handle(StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface)
	::DownCast(S);
    BS = 
      Handle(StepGeom_BSplineSurfaceWithKnots)
	::DownCast(BSR->BSplineSurfaceWithKnots());
  }
  else
    BS = Handle(StepGeom_BSplineSurfaceWithKnots)::DownCast(S);
  
  UDeg = BS->UDegree();
  VDeg = BS->VDegree();
  NUPoles = BS->NbControlPointsListI();
  NVPoles = BS->NbControlPointsListJ();
  aControlPointsList = new 
    StepGeom_HArray2OfCartesianPoint(1,NUPoles,1,NVPoles);
  aControlPointsList = BS->ControlPointsList();
  TColgp_Array2OfPnt Poles(1,NUPoles,1,NVPoles);
  for (i=1; i<=NUPoles; i++) {
    for (j=1; j<=NVPoles; j++) {
      P  = aControlPointsList->Value(i,j);
      StepToGeom_MakeCartesianPoint MkPoint(P);
      P1 = MkPoint.Value();
      P2 = P1->Pnt();
      Poles.SetValue(i,j,P2);
    }
  }
  NUKnots = BS->NbUMultiplicities();
  aUMultiplicities = new TColStd_HArray1OfInteger(1,NUKnots);
  aUMultiplicities = BS->UMultiplicities();
  TColStd_Array1OfInteger UMult(1,NUKnots);
  for (i=1; i<=NUKnots; i++) {
    Itampon = aUMultiplicities->Value(i);
    UMult.SetValue(i,Itampon);
  }
  NVKnots = BS->NbVMultiplicities();
  
  aVMultiplicities = new TColStd_HArray1OfInteger(1,NVKnots);
  aVMultiplicities = BS->VMultiplicities();
  TColStd_Array1OfInteger VMult(1,NVKnots);
  for (i=1; i<=NVKnots; i++) {
    Itampon = aVMultiplicities->Value(i);
    VMult.SetValue(i,Itampon);
  }
  aUKnots = new TColStd_HArray1OfReal(1,NUKnots);
  aUKnots = BS->UKnots();
  TColStd_Array1OfReal KUn(1,NUKnots);
  for (i=1; i<=NUKnots; i++) {
    Tampon = aUKnots->Value(i);
    KUn.SetValue(i,Tampon);
  }
  aVKnots = new TColStd_HArray1OfReal(1,NVKnots);
  aVKnots = BS->VKnots();
  TColStd_Array1OfReal KVn(1,NVKnots);
  for (i=1; i<=NVKnots; i++) {
    Tampon = aVKnots->Value(i);
    KVn.SetValue(i,Tampon);
  }
  
  // --- Does the Surface Descriptor LOOKS like a U and/or V Periodic ---
  // --- Descriptor ? ---
  
  Standard_Boolean shouldBeUPeriodic = Standard_False;
  Standard_Boolean shouldBeVPeriodic = Standard_False;

  // --- U Periodic ? ---
  
  Itampon = 0;
  for (i=1; i<=NUKnots; i++) {
    Itampon = Itampon + aUMultiplicities->Value(i);
  }
  
  if (Itampon == (NUPoles + UDeg + 1)) {
    shouldBeUPeriodic = Standard_False;
  }
  else if ((aUMultiplicities->Value(1) == 
	    aUMultiplicities->Value(NUKnots)) &&
	   ((Itampon - aUMultiplicities->Value(1))== NUPoles)) {
    shouldBeUPeriodic = Standard_True;
  }
  else {  // --- What is that ??? ---
    shouldBeUPeriodic = Standard_False;
#ifdef DEBUG
    cout << "Strange BSpline Surface Descriptor" << endl;
#endif
  }
  
  // --- V Periodic ? ---
  
  Itampon = 0;
  for (i=1; i<=NVKnots; i++) {
    Itampon = Itampon + aVMultiplicities->Value(i);
  }
  
  if (Itampon == (NVPoles + VDeg + 1)) {
    shouldBeVPeriodic = Standard_False;
  }
  else if ((aVMultiplicities->Value(1) == 
	    aVMultiplicities->Value(NVKnots)) &&
	   ((Itampon - aVMultiplicities->Value(1)) == NVPoles)) {
    shouldBeVPeriodic = Standard_True;
  }
  else {  // --- What is that ??? ---
    shouldBeVPeriodic = Standard_False;
#ifdef DEBUG
    cout << "Strange BSpline Surface Descriptor" << endl;
#endif
  }
  
  if (S->IsKind(STANDARD_TYPE(StepGeom_BSplineSurfaceWithKnotsAndRationalBSplineSurface))) {
    aWeight = new TColStd_HArray2OfReal(1,NUPoles,1,NVPoles);
    aWeight = BSR->WeightsData();
    TColStd_Array2OfReal W(1,NUPoles,1,NVPoles);
    for (i=1; i<=NUPoles; i++) {
      for (j=1; j<=NVPoles; j++) {
	Tampon = aWeight->Value(i,j);
	W.SetValue(i,j,Tampon);
      }
    }
    theBSplineSurface = new Geom_BSplineSurface(Poles, W, KUn, KVn, UMult,
						VMult, UDeg, VDeg,
						shouldBeUPeriodic,
						shouldBeVPeriodic);
    done = Standard_True;
  }
  else {
    theBSplineSurface = new Geom_BSplineSurface(Poles, KUn, KVn, UMult,
						VMult, UDeg, VDeg,
						shouldBeUPeriodic,
						shouldBeVPeriodic);
    done = Standard_True;
  }
}


//=============================================================================
// renvoi des valeurs
//=============================================================================

const Handle(Geom_BSplineSurface) &
      StepToGeom_MakeBSplineSurface::Value() const
{
  StdFail_NotDone_Raise_if(!done == Standard_True,"");
  return theBSplineSurface;
}
