// File:	TDataStd.cxx
// Created:	Wed Jul 30 15:57:49 1997
// Author:	Denis PASCAL
//		<dp@dingox.paris1.matra-dtv.fr>


#include <TDataStd.ixx>

#include <TDF_AttributeIterator.hxx>
#include <TDF_AttributeList.hxx>
#include <TDF_Tool.hxx>
#include <TDF_TagSource.hxx>
#include <TDF_Reference.hxx>
#include <TDF_ListIteratorOfAttributeList.hxx>
#include <TDF_ListIteratorOfLabelList.hxx>
#include <TDF_MapIteratorOfLabelMap.hxx>
#include <TDF_DataSet.hxx>  
#include <TDF_ChildIterator.hxx>
#include <TDataStd_Integer.hxx>
#include <TDataStd_Real.hxx>
#include <TDataStd_Name.hxx>
#include <TDataStd_Constraint.hxx>
#include <TDataStd_Placement.hxx>
#include <TDataStd_UAttribute.hxx>
#include <TDataStd_IntegerArray.hxx>
#include <TDataStd_RealArray.hxx>
#include <TDataStd_Shape.hxx>
#include <TDataStd_ExtStringArray.hxx>

#include <Standard_GUID.hxx>
#include <TNaming_NamedShape.hxx>
#include <TNaming_Tool.hxx>
#include <TopoDS_Compound.hxx>
#include <BRep_Builder.hxx>



//=======================================================================
//function : IDList
//purpose  : 
//=======================================================================

void TDataStd::IDList(TDF_IDList& anIDList)
{  
  anIDList.Append(TDF_TagSource::GetID());  
  anIDList.Append(TDF_Reference::GetID());
  anIDList.Append(TDataStd_Constraint::GetID());  
  anIDList.Append(TDataStd_Integer::GetID()); 
  anIDList.Append(TDataStd_Name::GetID());  
  anIDList.Append(TDataStd_Placement::GetID());   
  anIDList.Append(TDataStd_Real::GetID());  
  anIDList.Append(TDataStd_IntegerArray::GetID());
  anIDList.Append(TDataStd_RealArray::GetID());
  anIDList.Append(TDataStd_ExtStringArray::GetID());
  anIDList.Append(TDataStd_Shape::GetID());
  
}

//=======================================================================
//function : 
//purpose  : print the name of the constraint
//=======================================================================

Standard_OStream& TDataStd::Print(const TDataStd_ConstraintEnum C,  Standard_OStream& s)
{
  switch (C) {
    
  //2d planar constraints
 
  case TDataStd_RADIUS         : { s << "RADIUS"; break;}
  case TDataStd_DIAMETER       : { s << "DIAMETER"; break;}
  case TDataStd_MINOR_RADIUS   : { s << "MINOR_RADIUS"; break;}
  case TDataStd_MAJOR_RADIUS   : { s << "MAJOR_RADIUS"; break;}
  case TDataStd_TANGENT        : { s << "TANGENT"; break;}
  case TDataStd_PARALLEL       : { s << "PARALLEL"; break;}
  case TDataStd_PERPENDICULAR  : { s << "PERPENDICULAR"; break;}
  case TDataStd_CONCENTRIC     : { s << "CONCENTRIC"; break;}
  case TDataStd_COINCIDENT     : { s << "COINCIDENT"; break;}
  case TDataStd_DISTANCE       : { s << "DISTANCE"; break;}
  case TDataStd_ANGLE          : { s << "ANGLE"; break;}
  case TDataStd_EQUAL_RADIUS   : { s << "EQUAL_RADIUS"; break;}
  case TDataStd_SYMMETRY       : { s << "SYMMETRY"; break;}
  case TDataStd_MIDPOINT       : { s << "MIDPOINT"; break;} 
  case TDataStd_EQUAL_DISTANCE : { s << "EQUAL_DISTANCE"; break;} 
  case TDataStd_FIX            : { s << "FIX"; break;}
  case TDataStd_RIGID          : { s << "RIGID"; break;}

  // placement constraint

  case TDataStd_FROM           : { s << "FROM"; break;}  
  case TDataStd_AXIS           : { s << "AXIS"; break;}  
  case TDataStd_MATE           : { s << "MATE"; break;}
  case TDataStd_ALIGN_FACES    : { s << "ALIGN_FACES"; break;}
  case TDataStd_ALIGN_AXES     : { s << "ALIGN_AXES"; break;}
  case TDataStd_AXES_ANGLE     : { s << "AXES_ANGLE"; break;}
  case TDataStd_FACES_ANGLE    : { s << "FACES_ANGLE"; break;}
  case TDataStd_ROUND          : { s << "ROUND"; break;}
  case TDataStd_OFFSET         : { s << "OFFSET"; break;} 
 
    
    default :
      {
	s << "UNKNOWN"; break;
      }
  }
  return s;
}


//=======================================================================
//function : 
//purpose  : print the name of the real dimension
//=======================================================================

Standard_OStream& TDataStd::Print(const TDataStd_RealEnum C,  Standard_OStream& s)
{
  switch (C) {
  case TDataStd_SCALAR :
    {
      s << "SCALAR";  break;
    }
  case  TDataStd_LENGTH :
    {  
      s << "LENGTH"; break;
    }  
  case TDataStd_ANGULAR :
    { 
      s << "ANGULAR"; break;
    }
    default :
      {
	s << "UNKNOWN"; break;
      }
  }
  return s;
}


//=======================================================================
//function : 
//purpose  : print the name of the real dimension
//=======================================================================

Standard_OStream& TDataStd::Print(const TDataStd_GeometryEnum G,  Standard_OStream& s)
{
  switch (G) {  
  case TDataStd_ANY_GEOM :
    { 
      s << "ANY_GEOM"; break;
    }
  case TDataStd_POINT :
    {
      s << "POINT";  break;
    }
  case  TDataStd_LINE :
    {  
      s << "LINE"; break;
    }  
  case TDataStd_CIRCLE :
    { 
      s << "CIRCLE"; break;
    }  
  case TDataStd_ELLIPSE :
    { 
      s << "ELLIPSE"; break;
    }  
  case TDataStd_SPLINE :
    { 
      s << "SPLINE"; break;
    }  
  case TDataStd_PLANE :
    { 
      s << "PLANE"; break;
    }  
  case TDataStd_CYLINDER :
    { 
      s << "CYLINDER"; break;
    }
    default :
      {
	s << "UNKNOWN"; break;
      }
  }
  return s;
}
