// File:	TopoDS_Iterator.cxx
// Created:	Thu Jan 21 09:11:16 1993
// Author:	Remi LEQUETTE
//		<rle@phylox>

#define No_Standard_NoSuchObject
#include <TopoDS_Iterator.ixx>

//=======================================================================
//function : TopoDS_Iterator
//purpose  : 
//=======================================================================

TopoDS_Iterator::TopoDS_Iterator()
{}

//=======================================================================
//function : TopoDS_Iterator
//purpose  : 
//=======================================================================

TopoDS_Iterator::TopoDS_Iterator(const TopoDS_Shape& S,
				 const Standard_Boolean cumOri,
				 const Standard_Boolean cumLoc) 
{
  Initialize(S,cumOri,cumLoc);
}

//=======================================================================
//function : Initialize
//purpose  : 
//=======================================================================

void TopoDS_Iterator::Initialize(const TopoDS_Shape& S,
				 const Standard_Boolean cumOri,
				 const Standard_Boolean cumLoc) 
{
  if (cumLoc)
    myLocation = S.Location();
  else
    myLocation.Identity();
  if (cumOri)
    myOrientation   = S.Orientation();
  else
    myOrientation = TopAbs_FORWARD;

  myShapes.Initialize(S.TShape()->Shapes());
  if (More()) {
    myShape = myShapes.Value();
    myShape.Orientation(TopAbs::Compose(myOrientation,myShape.Orientation()));
    myShape.Move(myLocation);
  }
}

//=======================================================================
//function : Next
//purpose  : 
//=======================================================================

void TopoDS_Iterator::Next()
{
  myShapes.Next();
  if (More()) {
    myShape = myShapes.Value();
    myShape.Orientation(TopAbs::Compose(myOrientation,myShape.Orientation()));
    myShape.Move(myLocation);
  }
}
