/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		RTCPFlowControlModule.h

	Contains:	Uses information in RTCP packers to throttle back the server
				when it's pumping out too much data to a given client
	
	$Log: RTCPFlowControlModule.h,v $
	
*/

#ifndef _RTCPFLOWCONTROLMODULE_H_
#define _RTCPFLOWCONTROLMODULE_H_

#include "RTPModule.h"
#include "StreamDictionary.h"

//Turns on printfs that are useful for debugging
#define FLOW_CONTROL_DEBUGGING 0

class RTCPFlowControlModule : public RTPModule
{
public:

	RTCPFlowControlModule();
	virtual ~RTCPFlowControlModule(){}
	
	virtual void ProcessRTCPPacket(RTPStream* inStream, StrPtrLen* inPacket);
	
private:

	void	InitializeDictionaryItems(StreamDictionary* inDictionary);

	//Dictionary ID for a parameter we've added to the stream dictionary
	UInt32 fNumLossesAboveTolerance;
	UInt32 fNumLossesBelowTolerance;
	UInt32 fNumGettingWorses;
	UInt32 fNumGettingBetters;
	UInt32 fMoreBandwidthMultiple;
	
	FILE*	fLogFile;

};
#endif //_RTCPFLOWCONTROLMODULE_H_
