/*
 * Copyright (c) 1999 Apple Computer, Inc. All rights reserved.
 *
 * @APPLE_LICENSE_HEADER_START@
 * 
 * Portions Copyright (c) 1999 Apple Computer, Inc.  All Rights
 * Reserved.  This file contains Original Code and/or Modifications of
 * Original Code as defined in and that are subject to the Apple Public
 * Source License Version 1.1 (the "License").  You may not use this file
 * except in compliance with the License.  Please obtain a copy of the
 * License at http://www.apple.com/publicsource and read it before using
 * this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE OR NON- INFRINGEMENT.  Please see the
 * License for the specific language governing rights and limitations
 * under the License.
 * 
 * @APPLE_LICENSE_HEADER_END@
 */
/*
	File:		TCPSocket.cpp

	Contains:	implements TCPSocket class
					
	
	$Log: TCPSocket.cpp,v $
	Revision 1.2  1999/02/19 23:13:22  ds
	Created
	
	
*/

#ifndef __MW_
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <sys/errno.h>
#endif

#include "TCPSocket.h"
#include "SocketUtils.h"
#include "OS.h"

void TCPSocket::Set(int inSocket, struct sockaddr_in* remoteaddr, TCPSocket *listener, Task* inTask)
{
	Assert(fSocket == Socket::kInvalidSocket);//we shouldn't be overwriting another socket
	fSocket = inSocket;
	fRemoteAddr = *remoteaddr;
	fListener = listener;
	fTask = inTask;
	fNonblocking = true;
	
	//make sure to find out what IP address this connection is actually occuring on. That
	//way, we can report correct information to clients asking what the connection's IP is
	int len = sizeof(fLocalAddr);
	int err = ::getsockname(fSocket, (struct sockaddr*)&fLocalAddr, &len);
	AssertV(err == 0, OSThread::GetErrno());
	
	fState |= kBound;
	fState |= kConnected;

	InitNonblocking();
}

StrPtrLen*	TCPSocket::GetRemoteAddrStr()
{
	if (fRemoteStr.Len == kIPAddrBufSize)
		SocketUtils::ConvertAddrToString(fRemoteAddr.sin_addr, &fRemoteStr);
	return &fRemoteStr;
}

QTSS_ErrorCode  TCPSocket::Connect(UInt32 inRemoteAddr, UInt16 inRemotePort)
{
	::memset(&fRemoteAddr, 0, sizeof(fRemoteAddr));
    fRemoteAddr.sin_family = AF_INET;        /* host byte order */
    fRemoteAddr.sin_port = htons(inRemotePort); /* short, network byte order */
    fRemoteAddr.sin_addr.s_addr = htonl(inRemoteAddr);

    /* don't forget to error check the connect()! */
    int err = ::connect(fSocket, (sockaddr *)&fRemoteAddr, sizeof(fRemoteAddr));
	
	if (err == -1)
	{
		fRemoteAddr.sin_port = 0;
		fRemoteAddr.sin_addr.s_addr = 0;
		//When connecting, we are waiting for the socket to go writeable (indicates 
		//that the connection is successful).
		this->Modwatch(EV_RE | EV_WR);
		return (QTSS_ErrorCode)OSThread::GetErrno();
	}
	
	fState |= kConnected;
	return QTSS_NoErr;

}
