/* ######### BETA!!!! ####### */
/* ########################### */
/* #           rpl           # */
/* #     by Joe Laffey       # */
/* # joe@laffeycomputer.com  # */
/* #                         # */
/* ########################### */

/* 
 # Last Modified:  $Date: 2001/07/03 20:43:10 $                  
 # by:             $Author: joe $     
 # Revision:	   $Revision: 1.28.2.3 $         
*/


/*  rpl v1.3.0b3 by Joe Laffey, LAFFEY Computer Imaging. 							*/
/*  Visit http://www.laffeycomputer.com for updates 								*/
/*  This software is copyright 1998, 1999, 2000, 2001 by Joe Laffey.   				*/
    
/*  Permission is granted to any individual, institution, or company to use, 		*/
/*  copy, or redistribute rpl in source code or binary form so long as it is 		*/
/*  not modified in any way (beyond modifications required to compile or */
/*  "package"), and it is not sold by itself for a profit. 							*/
/*  Permission is also granted to bundle rpl in software distributions which 		*/
/*  are sold for a profit (e.g. CD-ROMs, etc.), as long as there are at least 		*/
/*  ten programs included in the distribution.  									*/
/*  In other words, please do NOT release updates or modified verions yourself.     */
/*  If you modify the source code and would like to see your changes incorporated 	*/
/*  please submit your source code to shareware@laffeycomputer.com 					*/
/*  Please report bugs to that address as well. 									*/

/*  rpl IS PROVIDED AS IS AND COMES WITH NO WARRANTY OF ANY KIND, EITHER EXPRESSED 	*/
/*  OR IMPLIED. IN NO EVENT WILL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DAMAGES 	*/
/*  RESULTING FROM THE USE OF THIS SOFTWARE. 										*/




/* #TODO: 			*/
/* # 				*/
/* # Grep Matching? */
/* # 				*/
/* # 			 	*/
/* Check for incompatible options */

#undef DEBUG
#undef DEBUG2


#include <sys/types.h>
#include <utime.h>
#include <sys/stat.h>
#include <sys/errno.h> 
#include <sys/param.h>
#include <errno.h>
#include <sysexits.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <sys/uio.h>
#include <unistd.h>
#include <dirent.h>
#include <string.h>
#include <ctype.h>


#define	FIND_FIRST_CHAR		2000		/*  These numbers are arbitrary */
#define FINISH_MATCH		3000		/*  They just represent the state */
#define MATCH_STRING		4000		/*  of our search for chars. */



#define MAX_STRING_LENGTH	2048		/* The maximum size of the search or replace strings. */

#define MAX_SUFFIXES		128
#define MAX_INPUT_LINE		1024


/*  Function Prototypes */
static void usage(void);
static void License(void);
void DoInterrupt();
void AddSuffix(char*);
int SuffixIsBad(char*);

/* Externals */
extern char *optarg;   
extern int optind;



/* For a linked list to hold filename to search */
/*  We use a linked list to avoid recursion... */
typedef struct fileList {
							char*				name;
							struct fileList*	next;
						}fileList;
						


static	int	interrupted = 0;
char		*suffixes[MAX_SUFFIXES];
int			suffixLens[MAX_SUFFIXES];
int			minSuffixLength =0;
int			numSuffixes = 0;

int main(int argc, char** argv)
{

	register 	int 	i,
						currentChar,
						prevChar,
						currentState;
			
					
		
	int	verbose = 0,				/*							*/
		force = 0,					/*		These are the		*/
		useTmp = 0,					/*		modes from the		*/
		quiet = 0,					/*		command-line		*/
		whole_words = 0,			/*		switches.			*/
		recursive = 0,				/*							*/
		ignore_case = 0,			/*							*/
		keepDates = 0,				/*							*/
		useSuffixes = 0,			/*							*/
		doneFlag,
		stringChanged = 0,
		simulationMode = 0,
		prompt = 0,
		replaceStringLength,
		pathLength,
		ch,
		good,
		seen =0,
		skipIt = 0,
		my_fd;
	

		
	unsigned long 	fileMatches = 0,	/* These are counts for tallies */
					totalMatches = 0,
					filecount = 0,
					lineCount = 1;
		
		
	unsigned	char	searchString[MAX_STRING_LENGTH],	/* The actual string we are looking for */
						replaceString[MAX_STRING_LENGTH],	/* The string we will use to replace the search string */
						replaceBuffer[MAX_STRING_LENGTH],	/* holds the string that gets written to the modified file. */
															/* we use this so we can write out new lines inplace of spaces, etc. */
						buff[MAX_STRING_LENGTH],		/* Buffer we read data into */
						line[MAX_INPUT_LINE];

	char 	absPathIn[MAXPATHLEN],	/* absolute path of the original file */
			absPathOut[MAXPATHLEN];	/*absolute path of the temp file we are writing to */
			

		
	
	FILE	*INFILE,
			*OUTFILE;
	
	struct stat		fileStat;
				
	fileList 		*firstItem,
					*currentItem,
					*nextItem,
					*oldItem;
					
	DIR		*dirp;
	
	struct dirent	*dp;
	
#ifdef DEBUG		/* debug stuff */
	unsigned long	memSize,
					totalMem =0;
#endif


	


	while ((ch = getopt(argc, argv, "iwqvRLx:hpsftd")) != -1)		/* get our options */
		switch(ch) {
		case 'i':
				 ignore_case = 1;
				 break;
		case 'v':
				verbose = 1;
				break;
		case 'q':
				quiet = 1;
				break;
		case 'w':
				whole_words = 1;
				break;
		case 'R':
				recursive = 1;
				break;
		case 'L':
				License();
				break;
		case 'p':
				prompt = 1;
				break;
		case 's':
				simulationMode = 1;
				break;
		case 'f':
				force = 1;
				break;
		case 't':
				useTmp = 1;
				break;
		case 'd':
				keepDates = 1;
				break;
		case 'x':
				useSuffixes = 1;
				AddSuffix(optarg);
				break;
		case 'h':
		default:
				 usage();
	 }
	 argc -= optind;
	 argv += optind;

	if( argc < 3 )						/* We Need at least three arguments */
		usage();
		
	if(argv[0] == 0)					/*  old_string can't be null */
		usage();
	
	for(i=2; i < argc ; i++)
	{
		if(stat(argv[i], &fileStat))	/* be sure files exist */
		{	
			fprintf(stderr, "\nrpl: File \"%s\" not found.\n", argv[i] );
			exit(EX_IOERR);
		}	
	}

	if(strlen(argv[0]) < MAX_STRING_LENGTH)
	{
		strcpy(searchString,argv[0]);		/* old_string */
	}
	else
	{
		fprintf( stderr, "\nrpl: old_string is too long!\nMaximum string length is %d.", MAX_STRING_LENGTH);
		exit(EX_SOFTWARE);
	}

	argv++;
	argc--;

	if(argv[0] != 0)	/* Ok for replacestring to be null */
	{
		if( strlen(argv[0]) < MAX_STRING_LENGTH )
		{
			strcpy(replaceString,argv[0]);	/*  but can't strcpy it if it is!! */
		}
		else
		{
			fprintf( stderr, "\nrpl: old_string is too long!\nMaximum string length is %d.", MAX_STRING_LENGTH);
			exit(EX_SOFTWARE);
		}

	}
	else
		replaceString[0] = '\0';			/* the solution... */
		
	replaceStringLength = strlen(replaceString);
	
	strcpy( replaceBuffer, replaceString); 	/*  replaceBuffer lets us change the text that gets */
											/* written in the case where a match is over a line break. */
											/* This lets us replace a space with a line break, etc. */

	argv++; /*  Move down... */
	argc--;	/*  Another cup of tea... */


	/* Set up our linked list */
#ifdef DEBUG
	memSize = sizeof(fileList);
	
	firstItem = malloc( memSize );
	
	totalMem += memSize; printf("\nTotal Allocated: %lu\n", totalMem);
	
	printf("\nAllocated: %lu\n", memSize);
#else
	firstItem = malloc( sizeof(fileList) );
#endif
	if(firstItem == NULL)
	{
		fprintf(stderr, "\nrpl: Unable to allocate memory.\n");
		exit(EX_OSERR);
	}
	
	
	currentItem = firstItem;
	
	for(i=0; i<argc; )/* i++ below */
	{
		
		pathLength = strlen(argv[i]);
		
		if(argv[i][pathLength-1] == '/')	/*drop trailing slash */
			argv[i][pathLength-1] = '\0';
		
		
#ifdef DEBUG
			memSize =  strlen(argv[i])+3;
			
			currentItem->name = malloc( memSize );
			totalMem += memSize; printf("\nTotal Allocated: %lu\n", totalMem);
			printf("\nAllocated: %lu\n", memSize);
#else
			currentItem->name = malloc( strlen(argv[i])+3); /* length + / null */
#endif
		
		if(currentItem->name == NULL)
		{
			fprintf(stderr, "\nrpl: Unable to allocate memory.\n");
			exit(EX_OSERR);
		}
		
		strcpy( currentItem->name, argv[i]);
		
		
		if( ++i < argc )
		{
		
#ifdef DEBUG
				memSize = sizeof(fileList) ;
				
				nextItem = malloc( memSize);
				totalMem += memSize; printf("\nTotal Allocated: %lu\n", totalMem);
				printf("\nAllocated: %lu\n", memSize);
#else
				nextItem = malloc( sizeof(fileList) );
#endif
			
			if(nextItem == NULL)
			{
				fprintf(stderr, "\nrpl: Unable to allocate memory.\n");
				exit(EX_OSERR);
			}
			
			currentItem->next = nextItem;
			
			currentItem = nextItem;
		}
		else
		{
			currentItem->next = 0;
			break;
		}
	
	}
	

	
	if(replaceString[0] == '\0')	/* Try to protect users from deleteing strings */
	{
		if( quiet == 0)
		{
			fprintf(stderr, "Really DELETE all occurences of %s ",searchString);
			if(ignore_case == 1)
			{
				fprintf(stderr,"(ignoring case)? (Y/[N]) ");
				
			}
			else
			{
				fprintf(stderr,"(case sensitive)? (Y/[N]) ");
			}
	
			fgets(line, 255, stdin);	/*read in response */
				
			
			if( line[0] != 'y' && line[0] != 'Y' )
			{
				fprintf(stderr,"\nrpl:  User cancelled operation.\n");
				exit(EX_TEMPFAIL);
			}
		}
	}


	/*  Set up our Interrupt (control-C) handler... */
	signal(SIGINT, DoInterrupt);

	if( simulationMode )
		fprintf(stderr, "Simulating replacement of \"%s\" with \"%s\" ",searchString,replaceString);
	else
		fprintf(stderr, "Replacing \"%s\" with \"%s\" ",searchString,replaceString);
	
	
	if(ignore_case == 1)
	{
		fprintf(stderr, "(ignoring case) ");
		
		
		for(i = 0; searchString[i] != '\0'; i++)						/* upcase the whole thing */
			searchString[i] = toupper(searchString[i]);
	}
	else
	{
		fprintf(stderr, "(case sensitive) ");
	}
	
	if(whole_words == 1)
	{
		fprintf(stderr, "(whole words only)\n");
	}
	else
	{
		fprintf(stderr, "(partial words matched)\n");
	}



	if( simulationMode )
		fprintf(stderr, "The files listed below would be modified in a replace operation.\n");
	



	currentItem = firstItem;
	

	while( 1 )	/* loop forever... breaking is at the end of the loop if there are no */
	{			/* more items in our linked list... */
	

	
		
		if(realpath(currentItem->name, absPathIn) == 0) 	/* get the absolute path to the file */
		{
			fprintf(stderr, "\nrpl: Could not get realpath of %s.\nrpl: Error: %s\nrpl: SKIPPING %s\n\n", absPathIn, strerror(errno), absPathIn);
			oldItem = currentItem;
			if(currentItem->next)
			{
				currentItem = currentItem->next;				
#ifdef DEBUG
				printf("I Feel Free");
#endif
				free(oldItem->name);	/*   won't be needing */
				free(oldItem);  		/*   these... */
			}
			else
				break;	/* break if there are no more files */
				
						
			continue;
		}

		
		
		if(stat(absPathIn, &fileStat))		/* read the original permissions so our new file can match */
		{	
			fprintf(stderr, "\nrpl: Unable to read permissions of %s.\nrpl: Error: %s\nrpl: SKIPPING %s\n\n!",absPathIn, strerror(errno), absPathIn );
			oldItem = currentItem;
			if(currentItem->next)
			{
				currentItem = currentItem->next;				
#ifdef DEBUG
				printf("I Feel Free");
#endif
				free(oldItem->name);	/*   won't be needing */
				free(oldItem);  		/*   these... */
			}
			else
				break;	/* break if there are no more files */
				
						
			continue;
			
		}
	
	
	
		/* Check for directory */
		if( (fileStat.st_mode) & S_IFDIR)
		{
			
			
			if(!recursive)	/* If we're not doing a recursive search then just  */
			{				/* ignore directories... */
			
				if(verbose)
					fprintf(stderr, "Directory: %s skipped.\n",currentItem->name);
			
				oldItem = currentItem;
				if(currentItem->next)
				{
					currentItem = currentItem->next;				
#ifdef DEBUG
					printf("I Feel Free");
#endif
					free(oldItem->name);	/*   won't be needing */
					free(oldItem);  		/*   these... */
				}
				else
					break;	/* break if there are no more files */
							
				continue;
			
			}
			else	/* we have a directory */
			{
				if(verbose)
					fprintf(stderr, "Scanning Directory: %s\n",currentItem->name);
					
		
				
				dirp = opendir(absPathIn); /* open sesame! */
				
				
				
				
				if( ( readdir(dirp)) != NULL )		/*  These two reads skip the "." */
					if( ( readdir(dirp)) != NULL )	/*  and ".." entries... */
					{
							
						if( (dp = readdir(dirp)) != NULL )	/* be sure something is in there */
						{
						
							/* Set up our linked list */
							oldItem = currentItem;
							
#ifdef DEBUG
								memSize =  sizeof(fileList);
								
								firstItem = malloc( memSize );
								totalMem += memSize; printf("\nTotal Allocated: %lu\n", totalMem);
								printf("\nAllocated: %lu\n", memSize);
#else
								firstItem = malloc( sizeof(fileList) );
#endif
							
							if(firstItem == NULL)
							{
								fprintf(stderr, "\nrpl: Unable to allocate memory.\n");
								exit(EX_OSERR);
							}
							/* currentItem->next = firstItem; */
							
							currentItem = firstItem;
						
						
							pathLength = strlen(oldItem->name) + 1;
							oldItem->name[pathLength - 1] = '/';
							oldItem->name[pathLength] = '\0';
						
						
							while (1)
							{
								
								
#ifdef DEBUG
									memSize =  strlen(dp->d_name) + pathLength+3;
									
									currentItem->name = malloc( memSize);
									totalMem += memSize; printf("\nTotal Allocated: %lu\n", totalMem);
									
									printf("\nAllocated: %lu\n", memSize);
#else
									currentItem->name = malloc( strlen(dp->d_name) + pathLength+3);
							
#endif
								
								if(currentItem->name == NULL)
								{
									fprintf(stderr, "\nrpl: Unable to allocate memory.\n");
									exit(EX_OSERR);
								}
								strcpy( currentItem->name, oldItem->name);
							
								strcat( currentItem->name, dp->d_name);
								
								
								if( (dp = readdir(dirp)) != NULL )
								{
									
#ifdef DEBUG
										memSize =  sizeof(fileList) ;
										
										nextItem = malloc( memSize );
								
										totalMem += memSize; printf("\nTotal Allocated: %lu\n", totalMem);
										printf("\nAllocated: %lu\n", memSize);
#else
										nextItem = malloc( sizeof(fileList) );
#endif
									
									
									
									if(nextItem == NULL)
									{
										fprintf(stderr, "\nrpl: Unable to allocate memory.\n");
										exit(EX_OSERR);
									}
									currentItem->next = nextItem;
									
									currentItem = nextItem;
								}
								else
									break;
								
							}
							
							
							
						
				
			
							currentItem->next = oldItem->next;  /*  fix up links in the */
							oldItem->next = firstItem;			/*  list */
							
							currentItem = oldItem;		/* Get back in place */
							
						}/* end the first two dps */
					}
					
				
				
				
				if(closedir(dirp))	/* cleanup */
				{
					fprintf( stderr, "\nrpl: Unable to close directory!\nError: %s\n", strerror(errno));
					exit(EX_OSERR);
				}
				

				oldItem = currentItem;
				if(currentItem->next)
				{
					currentItem = currentItem->next;				
#ifdef DEBUG
					printf("I Feel Free");
#endif
					free(oldItem->name);	/*   won't be needing */
					free(oldItem);  		/*   these... */
				}
				else
					break;	/* break if there are no more files */
					
							
				continue;
			}
			
		} /* end if this is a dir */
		else
		{
			/* We have a file. Be sure we should process this file by checking suffix list if needed. */
		
			if(useSuffixes && SuffixIsBad(absPathIn))	/* If we are using suffix matching and this file has a bad suffix */
			{
				if(verbose)
					fprintf(stderr, "Skipping: %s. (suffix not in list)\n",currentItem->name);
					
				oldItem = currentItem;
				if(currentItem->next)
				{
					currentItem = currentItem->next;				
#ifdef DEBUG
					printf("I Feel Free");
#endif
					free(oldItem->name);	/*   won't be needing */
					free(oldItem);  		/*   these... */
				}
				else
					break;	/* break if there are no more files */
				
						
				continue;
			}
		}
		
		INFILE = fopen( absPathIn, "rb");  /* open up the input file */
		
		if(INFILE == NULL){
			fprintf(stderr, "\nrpl: Unable to open %s for reading.\nrpl: Error: %s\nrpl: SKIPPING %s\n", absPathIn, strerror(errno), absPathIn);

			oldItem = currentItem;
			if(currentItem->next)
			{
				currentItem = currentItem->next;				
#ifdef DEBUG
				printf("I Feel Free");
#endif
				free(oldItem->name);	/*   won't be needing */
				free(oldItem);  		/*   these... */
			}
			else
				break;	/* break if there are no more files */
				
						
			continue;

		}
	
	
		
		
		if( useTmp )
		{
			
			if(getenv("TMPDIR") != NULL )
			{
				strcpy(absPathOut,getenv("TMPDIR"));
			}
			else
			{
				strcpy(absPathOut,absPathIn);
			}
				
		}
		else
		{
			strcpy(absPathOut,absPathIn);
		}
		
#ifdef DEBUG2
	printf("Tmp file location:%s\n",absPathOut);
#endif
		strcat(absPathOut, ".tmp.XXXXXX");		/* set up our temp file name */
		

		my_fd = mkstemp(absPathOut); /* Make the tempfile */

		if(my_fd == -1)
		{
			fprintf(stderr, "\nrpl: Unable to create temp file %s.\nrpl: Error: %s\nrpl: (Type \"rpl -h\" and consider \"-t\" to specify temp file location.)\nrpl: SKIPPING %s.\n\n",absPathOut, strerror(errno), absPathIn);

			oldItem = currentItem;
			if(currentItem->next)
			{
				currentItem = currentItem->next;				
#ifdef DEBUG
				printf("I Feel Free");
#endif
				free(oldItem->name);	/*   won't be needing */
				free(oldItem);  		/*   these... */
			}
			else
				break;	/* break if there are no more files */		
			
			continue;
		}

		OUTFILE = fdopen( my_fd, "wb");  /* open up the tempfile to write to */
			
		if(OUTFILE == NULL)
		{
			fprintf(stderr, "\nrpl: Unable to open temp file %s for writing.\nrpl: Error: %s\nrpl: Aborting. Some files may not have been processed.\n\n", absPathOut, strerror(errno));
			exit(EX_IOERR);
		}
		
		if(chown(absPathOut,fileStat.st_uid,fileStat.st_gid))	/* and its owner & group ids */
		{
			if( force )		/*we don't care that permissions don't match */
			{	
				fprintf( stderr, "\nrpl: Unable to set owner/group of %s.\nError: %s\nrpl: New owner/group may not match!\n\n",absPathIn, strerror(errno) ); /* only root cant change the owner id, though */
			}
			else
			{
				fprintf( stderr, "\nrpl: Unable to set owner/group of %s.\nrpl: Error: %s\nrpl: SKIPPING %s!\n\n",absPathIn, strerror(errno), absPathIn); /* only root cant change the owner id, though */
				skipIt = 1; /* so we don't overwrite the file later */
			}
		}

		if(chmod(absPathOut,fileStat.st_mode))		/* set up its permissions */
		{
			if( force )		/*we don't care that permissions don't match */
			{	
				fprintf( stderr, "\nrpl: Unable to set permissions of %s.\nrpl: Error: %s\nrpl: WARNING: New permissions may not match!\n",absPathIn, strerror(errno) );
			}
			else
			{
				fprintf( stderr, "\nrpl: Unable to set permissions of %s.\nrpl: Error: %s\nrpl: SKIPPING %s!\n",absPathIn, strerror(errno), absPathIn );
				skipIt = 1; /* so we don't overwrite the file later */
			}
		}
	
		
		
		if(verbose == 1 && simulationMode == 0)
		{
			fprintf(stderr, "Processing:  %s\n", currentItem->name);	/* print the current filename */
		}
		else if( quiet != 1 )
		{
			if( !simulationMode )
				fprintf(stderr,".");		/* print one dot per file for standard (non-quiet, non-verbose) mode */
		}
	
		
		
		/* Set our current state (What we are looking for) */
		currentState = FIND_FIRST_CHAR;	
	
		currentChar = 0; /* start at the first char of the string */
	
		prevChar = ' '; /* set this up so match whole words will work at the begining of a file */
		
		doneFlag = 0;
		
		
		
		
		while( !doneFlag ) 
		{
			
				
			if( interrupted )
			{
				fprintf(stderr, "\nrpl:  User cancelled.\n");
				if( simulationMode )
					fprintf(stderr, "      A Total of %lu matches found in %lu file(s) serached.\n      None replaced (simulation mode).\n", totalMatches > 0 ? (totalMatches - fileMatches): fileMatches, filecount+1);
				else
				{
					fprintf(stderr, "      A Total of %lu matches replaced in %lu file(s) searched.\n", totalMatches > 0 ? (totalMatches - fileMatches): fileMatches, filecount);
					fprintf(stderr, "      Changes to file \"%s\" not saved.\n",currentItem->name);
				}
				
				if(unlink(absPathOut))
				{
					fprintf(stderr, "\nrpl: An error occured deleting temp file %s.\nrpl: Error: %s\n\n",absPathOut, strerror(errno));
					exit(EX_IOERR);
				}	
				exit(EX_TEMPFAIL);
			
			}
			
			ch = fgetc(INFILE);
			
			if(ch == EOF )
			{
				/* probably just EOF, but check for error */
				if(ferror(INFILE))
					fprintf(stderr, "\nrpl: An error occurred reading %s.\nrpl: Error: %s\n\n",absPathIn, strerror(errno));
					
				if( currentState != MATCH_STRING )
					break; /* we're done with this file */
				else
					currentState = FINISH_MATCH;
			}
			else if(ch == '\n')
			{
				lineCount++;
				seen = 0; 		/*mark line as not seen */
			}
			
			
				
			
			switch(currentState) 
			{
				case FIND_FIRST_CHAR:
						/* if we're not looking for whole words then it doesn't matter what */
						/* prevChar is. But if we are, then we have to be sure it was whitespace */
						
						if(whole_words == 0 || prevChar == ' ' || prevChar == '\n' ||
							prevChar == '\t' || prevChar == '\r')
						{
							if( searchString[0] == ch || (ignore_case &&  searchString[0] == toupper(ch)))	/* we found the first character of the searchstring */
							{
								currentState = MATCH_STRING; /* change state */
								currentChar = 0;
								/* buff[currentChar] = ch;  //copy ch into buffer in case we need to write it later */
								fseek(INFILE, -1,SEEK_CUR); /* let's read that char again */
								if( ch == '\n' )
									lineCount--;
								break; /* we're done this pass */
							}
						}
						
						fputc( ch, OUTFILE);  /* write out the char */
						
						break;
						
				case MATCH_STRING:
					
						if(searchString[currentChar] == '\0')  /* we're at the end of searchString */
						{										/*  must be a match */
							
							if(whole_words == 0 || ch == ' ' || ch == '\n' ||	/* be sure we have whitespace */
							ch == '\t' || ch == '\r' )							/*  next if looking for whole words */
							{
								fwrite( replaceBuffer, replaceStringLength,1, OUTFILE); /* write the replacement out */
							
								if(stringChanged)
								{
									strcpy( replaceBuffer, replaceString);
									stringChanged = 0;
								}
							
								
		
							
								fileMatches++;
							
								fseek(INFILE, -1,SEEK_CUR);  /* let's read that char again */
								if( ch == '\n' )
									lineCount--;
							}
							else /* not a whole word */
							{
								buff[currentChar++] = ch;  /* copy ch into buffer to write it later */
						
								fwrite( buff, currentChar,1, OUTFILE); /* write the buff out */
							}
							
							currentState = FIND_FIRST_CHAR;  /* change state */
							
							if(verbose == 1)
							{
								if( !seen ) /* if we have not already listed this line */
								{
									/*curPos = ftell(INFILE);*/
									if( simulationMode )
										printf( "  Line: %ld String Found\n", lineCount);	/* print position found */
									else
										printf( "  Line: %ld String Found and Replaced\n", lineCount);	/* print position found */
								
									seen = 1; /* Mark this line as seen*/
								}
							}
							
							break;
						}
						
						buff[currentChar] = ch;  /* copy ch into buffer in case we need to write it later */
						
						
						if( (searchString[currentChar] == ' ') &&     /* if searchString has a space in it */
							(ch == '\n' || ch == '\r') )			/*  consider any newlines as a match and keep matching */
						{
							
							for(i=0; i < replaceStringLength; i++ )
							{
								if(replaceBuffer[i] == ' ')
								{
									replaceBuffer[i] = ch; /* replace spaces with the actual char (newline, etc.) */
									
									stringChanged = 1;     /* mark string as changed */
									
									break;
									
								}
							}
							
							
							if(i >= replaceStringLength)
							{
								if(replaceStringLength+1 > MAX_STRING_LENGTH)
								{
										/* This is possible. Should rework to avoid this */
										fprintf( stderr, "\nrpl: old_string has too many spaces at the end. Be sure the length of the new_string plus the number of spaces at the end of old_string is less than %d.\n", MAX_STRING_LENGTH);
										exit(EX_SOFTWARE);
								}
								
								replaceBuffer[replaceStringLength] = ch; 	/* This will add a newline after the replace string */
								replaceStringLength++;						/* if the search string has a space and the located */
																			/* string has a newline */
							}	
							currentChar++;
							break;
							
						}
						
						if( searchString[currentChar] != ch && !(ignore_case &&  searchString[currentChar] == toupper(ch)))/* we don't match the whole string		 */
						{
							
							currentState = FIND_FIRST_CHAR;  /* change state */
							
							fwrite( buff, currentChar + 1,1, OUTFILE); /* write the buff out */
							
							if(stringChanged)
							{
								strcpy( replaceBuffer, replaceString);  /* refresh the buffer */
								stringChanged = 0;
							}
						}
						
						
					
						currentChar++;
						
						break;	
						
				case FINISH_MATCH:
						if(searchString[currentChar] == '\0')  /* we're at the end of searchString */
						{										/*  must be a match */
							
							
							fwrite( replaceBuffer, replaceStringLength,1, OUTFILE); /* write the replacement out */
						
							fileMatches++;
						
							 /* fseek(INFILE, -1,SEEK_CUR); */ /* let's read that char again */
							
							
							doneFlag = 1; /* done with this file */
								
								
							if(verbose == 1)
							{
								if( !seen ) /* if we have not already listed this line */
								{
									/*curPos = ftell(INFILE);*/
									if( simulationMode )
										printf( "  Line: %ld String Found\n", lineCount);	/* print position found */
									else
										printf( "  Line: %ld String Found and Replaced\n", lineCount);	/* print position found */
								
									seen = 1; /* Mark this line as seen*/
								}
							}
		
							break;
						}
						
					
						doneFlag = 1; /* done with this file */
						
						fwrite( buff, currentChar,1, OUTFILE); /* write the buff out */
						
						
						
						break;
				
				default:
						;
			 }/*  end switch(currentState) */
					
		
			prevChar = ch; /* copy this char for whole word searches. */
		
		
		}/* end while not eof */

		fclose(INFILE);
		fclose(OUTFILE);
		
		if( interrupted )
		{
			fprintf(stderr, "\nrpl:  User cancelled.\n");
			if( simulationMode )
				fprintf(stderr, "      A Total of %lu matches found in %lu file(s) searched.\n      None replaced (simulation mode).\n", totalMatches , filecount+1);
			else
			{
				fprintf(stderr, "      A Total of %lu matches replaced in %lu file(s) searched.\n", totalMatches > 0 ? (totalMatches - fileMatches): fileMatches, filecount);
			}
			
			if(unlink(absPathOut))
				fprintf( stderr, "\nrpl: An error occured deleting %s.\nError: %s\n",absPathOut, strerror(errno));
				
			exit(EX_IOERR);
		
		}
		
		
		if(fileMatches > 0)
		{
			
			if( simulationMode )
			{
				fprintf( stderr, "  %s\n",absPathIn);	/*list the file*/
				/* delete tmp file */
				if(unlink(absPathOut))
					fprintf(stderr, "\nrpl: An error occured deleting temp file %s.\nrpl: Error: %s\n\n",absPathOut, strerror(errno));
				totalMatches += fileMatches;		/* handle our count */
			}
			else
			{
				
				
				if( prompt )	/* User must decide to process this file or not */
				{				
					good = 0;
					while( !good )
					{
						fprintf(stderr, "\nSave '%s' ? ([Y]/N) ",absPathIn);
					
						fgets(line, 255, stdin);	/*read in response */
				
						
						if( line[0] == 'y' || line[0] == 'Y' || line[0] == '\n' )
						{
							good = 1; 		/*we got what we were looking for */
							fprintf(stderr, "Saved.\n");
							
						}
						else if( line[0] == 'n' || line[0] == 'N' )
						{
							fprintf(stderr, "Not Saved.\n");		/*We need to skip this file */
							good = 1;
							skipIt = 1;  /*mark file to be skipped */
						}
					
					}
					
				}

				
				
				if( !skipIt )
				{
					/* rename tmpfile to old file */
					if(rename(absPathOut, absPathIn))
					{
						fprintf( stderr, "\nrpl: An error occured replacing %s with %s.\nrpl: Error: %s\n\n",absPathIn,absPathOut, strerror(errno));
						if(unlink(absPathOut))
							fprintf(stderr, "\nrpl: An error occured deleting temp file %s.\nrpl: Error: %s\n\n",absPathOut, strerror(errno));
		
					}
					
					/* Set mod date to old mod date if we need to */
					
					if(keepDates)
					{
						 struct utimbuf timeStruct;
						 
						 timeStruct.actime = fileStat.st_atime;
						 timeStruct.modtime = fileStat.st_mtime;
						
						 if( utime(absPathIn, &timeStruct) )
						 	fprintf(stderr, "\nrpl: An error occured setting the access time and mod time of the file %s.\nrpl: Error: %s\n\n",absPathIn, strerror(errno));

					}
					
					totalMatches += fileMatches;		/* handle our count */
				}
				else
				{
					skipIt = 0;
					if(unlink(absPathOut))
							fprintf(stderr, "\nrpl: An error occured deleting temp file %s.\nrpl: Error: %s\n\n",absPathOut, strerror(errno));
		
				}
			}
			
			fileMatches = 0;
			
			
		}
		else
		{
			/* delete tmp file */
			if(unlink(absPathOut))
				fprintf(stderr, "\nrpl: An error occured deleting temp file %s.\nrpl:Error: %s\n\n",absPathOut, strerror(errno));
		}

		lineCount = 1;
		filecount++;
		
		
		oldItem = currentItem;
		if(currentItem->next)
		{
			currentItem = currentItem->next;	
			
#ifdef DEBUG
			printf("I Feel Free");
#endif
			free(oldItem->name);	/*   won't be needing */
			free(oldItem);  		/*   these... */
		}
		else
			break;	/* break if there are no more files */
		
		
	}/*  end while there are more files */

	if( simulationMode )
		fprintf(stderr, "\nA Total of %lu matches found in %lu file(s) searched.\nNone replaced (simulation mode).\n", totalMatches, filecount);
	else
		fprintf(stderr, "\nA Total of %lu matches replaced in %lu file(s) searched.\n", totalMatches, filecount);

#ifdef DEBUG
		printf("A total of %lu bytes allocated with malloc.\n", totalMem);
#endif

	return(EX_OK); /*success*/

} /* end main */




/*****************************/
/*  Print out what we can do */
static void usage(void)
{
	fprintf(stderr, "------------------------------------------------\n");
	fprintf(stderr, "rpl v1.3.0b3 by Joe Laffey, LAFFEY Computer Imaging.\n");
	fprintf(stderr, "Visit http:// www.laffeycomputer.com for updates.\n");
	fprintf(stderr, "This software comes with ABSOLUTELY NO WARRANTY. rpl -L for license.\n");   
    fprintf(stderr, "Usage:  rpl [-iwRspfdtx [-q | -v] ] <old_string> <new_string> <target_file(s)>\n");
	fprintf(stderr, "        ( Put strings in single quotes (\') )\n");
	fprintf(stderr, "        -i   Ignore case of old_string\n");
	fprintf(stderr, "        -w   Whole words (old_string bounded by white space in file)\n");	
	fprintf(stderr, "        -q   Quiet mode (no output at all)\n");
	fprintf(stderr, "        -v   Verbose mode (lots of output)\n");
	fprintf(stderr, "        -R   Search directories recursively\n");
	fprintf(stderr, "        -x   Specify file suffix to match. (e.g. '.html')\n");
	fprintf(stderr, "             Only files with this suffix will be searched.\n");
	fprintf(stderr, "             You may specify up to %d suffixes. (e.g. -x'.html' -x'.jsp' ...)\n",MAX_SUFFIXES);
	fprintf(stderr, "        -p   Prompt to modify each file\n");
	fprintf(stderr, "        -s   Simulation mode (lists files that would be changed)\n");
	fprintf(stderr, "        -f   Force overwriting files when permissions cannot be matched\n");
	fprintf(stderr, "        -d   Don't change modification times of altered files\n");
	fprintf(stderr, "        -t   Use value of $TMPDIR for temp files instead of original file dir\n");
	fprintf(stderr, "        -L   Display the software license\n");
	fprintf(stderr, "        -h   Display this help screen\n");
	fprintf(stderr, "Returns: 0 on success.\n\n");
	fprintf(stderr, "Note: If you are using a \"-\" in either the old_string\n");
	fprintf(stderr, "or the new_string you must put a \"--\" as your last option before\n");
	fprintf(stderr, "the strings (e.g. rpl -ip -- \"-string\" \"-str\" *)\n\n");
	exit(EX_USAGE);
}



/*****************************/
/*  Print out the license */
static void License(void)
{
	fprintf(stderr, "------------------------------------------------\n");
	fprintf(stderr, "rpl v1.3.0b3 by Joe Laffey, LAFFEY Computer Imaging.\n");
	fprintf(stderr, "Visit http:// www.laffeycomputer.com for updates.\n");
	fprintf(stderr, "This software is copyright 1998, 1999, 2000, 2001 by Joe Laffey.\n\n");   
    
	fprintf(stderr, "Permission is granted to any individual, institution, or company to use, copy,\n");
	fprintf(stderr, "or redistribute rpl in source code or binary form so long as it is not\n");
	fprintf(stderr, "modified in any way (beyond modifications required to compile or \"package\"),\n");
	fprintf(stderr, "and it is not sold by itself for profit.\n\n");

	fprintf(stderr, "Permission is also granted to bundle rpl in software distributions which\n");
	fprintf(stderr, "are sold for a profit (e.g. CD-ROMs, etc.), as long as there are at least \n");
	fprintf(stderr, "ten programs included in the distribution.\n\n");

	fprintf(stderr, "If you modify the source code and would like to see your changes incorporated\n");
	fprintf(stderr, "please submit your source code to shareware@laffeycomputer.com\n");
	fprintf(stderr, "Please report bugs to that address as well.\n\n");

	fprintf(stderr, "rpl IS PROVIDED AS IS AND COMES WITH NO WARRANTY OF ANY KIND, EITHER EXPRESSED\n");
	fprintf(stderr, "OR IMPLIED;  without even the implied warranty of MERCHANTABILITY or FITNESS\n");
	fprintf(stderr, "FOR A PARTICULAR PURPOSE. IN NO EVENT WILL THE COPYRIGHT HOLDERS OR\n");
	fprintf(stderr, "CONTRIBUTORS BE LIABLE FOR ANY DAMAGES RESULTING FROM THE USE OF THIS SOFTWARE.\n\n");


	exit(EX_USAGE);
}





/****************************/
/*  Handle control-Cs       */
void DoInterrupt(void)
{
	interrupted++;						/* we got a SIG_INT */
	write(STDERR_FILENO, "\n\n*Break*\n\n", 8);
	if( interrupted > 3 )
	{
		fprintf(stderr, "\n\n*Terminating*\n\n");
		exit(EX_TEMPFAIL);
	}
	return;
}



/*****************************/
/* Check to see if we have   */
/* a file with a bad suffix. */
/* i.e. one NOT in our list  */
int SuffixIsBad(char* fName)
{
	int fileNameLen;
	int i;
	

	 fileNameLen = strlen(fName);
  
     if (fileNameLen>=minSuffixLength)	/*can't match if this is false */
     {
		for (i=0;i<numSuffixes;i++)
		{
		 
		  
		   if (!strncmp(&fName[fileNameLen-suffixLens[i]],suffixes[i],suffixLens[i]))
			 return 0;
		}
      }
      
      return 1; /* the suffix on the file _IS_ bad  not found */
}


void AddSuffix(char* theSuffix)
{
	int suffixLen;
	
   
   if (numSuffixes < MAX_SUFFIXES)
   {
		suffixLen = strlen(theSuffix);

		if(suffixLen < minSuffixLength) 
			minSuffixLength = suffixLen;
		
		suffixes[numSuffixes] = malloc(suffixLen+1);
		
   
      
	 if(suffixes[numSuffixes] == NULL)
	  {
			fprintf(stderr, "Unable to allocate memory.\n");
			exit(EX_OSERR);
	  }
      
      strcpy(suffixes[numSuffixes],theSuffix);
      suffixLens[numSuffixes] = strlen(theSuffix);
      numSuffixes++;
   }
   else
   	fprintf(stderr,"rpl: Maximum of %d suffixes exceeded. Suffix \"%s\" ignored\n",MAX_SUFFIXES,theSuffix);

	
}
