.TH calfrq 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
calfrq - frequency response discretization
.SH CALLING SEQUENCE
.nf
[frq,split]=calfrq(h,[fmin,fmax])
.fi
.SH PARAMETERS
.TP 10
h    
: SISO linear system (\fVsyslin\fR list)
.TP
fmin,fmax 
: real scalars (min and max frequencies)
.TP
frq  
: row vector (discretization of interval)
.TP
split 
: vector of frq splitting points indexes
.SH DESCRIPTION
frequency response discretization ; \fVfrq\fR is the discretization of  
\fV[fmin,fmax]\fR 
such that the peaks in the frequency response are well represented. 
.LP
Default values for \fVfmin\fR and \fVfmax\fR are
\fV1.d-3\fR, \fV1.d+3\fR if \fVh\fR is continuous-time
or \fV1.d-3\fR, \fV1/(2*h('dt'))\fR if \fVh\fR is discrete-time.
.LP
Singularities are located between \fVfrq(split(k))\fR and \fVfrq(split(k)+1)\fR
for \fVk>1\fR.

.SH EXAMPLE
.nf
s=poly(0,'s')
h=syslin('c',(s^2+2*0.9*10*s+100)/(s^2+2*0.3*10.1*s+102.01))
h1=h*syslin('c',(s^2+2*0.1*15.1*s+228.01)/(s^2+2*0.9*15*s+225)) 
[f1,spl]=calfrq(h1,0.01,1000);
rf=repfreq(h1,f1);
plot2d(real(rf)',imag(rf)')
.fi
.SH SEE ALSO
bode, black, nyquist, freq, repfreq, logspace
