.TH ddp 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
ui_observer - unknown input observer
.SH CALLING SEQUENCE
.nf
[UIobs,J,N]=ui_observer(Sys,reject,C1,D1)
[UIobs,J,N]=ui_observer(Sys,reject,C1,D1,flag,alfa,beta)
.fi
.SH PARAMETERS
.TP
Sys
: \fVsyslin\fR list containing the matrices \fV(A,B,C2,D2)\fR.
.TP
reject
: integer vector, indices of inputs of \fVSys\fR which are unknown.
.TP
C1
: real matrix
.TP
D1
: real matrix. \fVC1\fR and \fVD1\fR have the same number of rows.
.TP
flag
: string \fV'ge'\fR or \fV'st'\fR (default) or \fV'pp'\fR.
.TP
alfa 
: real or complex vector (loc. of closed loop poles)
.TP
beta
: real or complex vector (loc. of closed loop poles)
.SH DESCRIPTION
Unknown input observer.

\fVSys: (w,u) --> y\fR is a \fV(A,B,C2,D2)\fR syslin linear system with 
two inputs w and u, w being the unknown input.
The  matrices B and D2 of Sys are (implicitly) partitioned as:
\fVB=[B1,B2]\fR and \fVD2=[D21,D22]\fR  with \fVB1=B(:,reject)\fR  and 
\fVD21=D2(:,reject)\fR where reject = indices of unknown inputs.
The matrices \fVC1\fR and \fVD1\fR define \fVz = C1 x + D1 (w,u)\fR,
the to-be-estimated output.
.LP
The matrix \fVD1\fR is (implicitly) partitioned as \fVD1=[D11,D12]\fR
with \fVD11=D(:,reject)\fR
.LP
The data (Sys, reject,C1, D1)   define a 2-input 2-output system:
.nf
  xdot =  A x + B1  w + B2  u
     z = C1 x + D11 w + D12 u
     y = C2 x + D21 w + D22 u
.fi
An observer \fV(u,y) --> zhat\fR is looked for the output z.
.LP
\fVflag='ge'\fR no stability constraints
\fVflag='st'\fR stable observer    (default) 
\fVflag='pp'\fR observer with pole placement
alfa,beta = desired location of closed loop poles  (default -1, -2)
J=y-output to x-state injection.
N=y-output to z-estimated output injection.
.LP
UIobs = linear system (u,y) --> zhat such that:
The transfer function: (w,u) --> z  equals the composed transfer function:
            [0,I;        UIobs
             Sys]
      (w,u) -----> (u,y) -----> zhat
i.e. transfer function of system {A,B,C1,D1} equals transfer function 
\fVUIobs*[0,I; Sys]\fR
.LP
Stability (resp. pole placement) requires detectability
(resp. observability) of (A,C2).
.SH EXAMPLE
.nf
A=diag([3,-3,7,4,-4,8]);
B=[eye(3,3);zeros(3,3)];
C=[0,0,1,2,3,4;0,0,0,0,0,1];
D=[1,2,3;0,0,0];
rand('seed',0);w=ss2ss(syslin('c',A,B,C,D),rand(6,6));
[A,B,C,D]=abcd(w);
B=[B,matrix(1:18,6,3)];D=[D,matrix(-(1:6),2,3)];
reject=1:3;
Sys=syslin('c',A,B,C,D);
N1=[-2,-3];C1=-N1*C;D1=-N1*D;
nw=length(reject);nu=size(Sys('B'),2)-nw;
ny=size(Sys('C'),1);nz=size(C1,1);
[UIobs,J,N]=ui_observer(Sys,reject,C1,D1);

W=[zeros(nu,nw),eye(nu,nu);Sys];UIobsW=UIobs*W;   
//(w,u) --> z=UIobs*[0,I;Sys](w,u)
clean(ss2tf(UIobsW));
wu_to_z=syslin('c',A,B,C1,D1);clean(ss2tf(wu_to_z));
clean(ss2tf(wu_to_z)-ss2tf(UIobsW),1.d-7)
/////2nd example//////
nx=2;ny=3;nwu=2;Sys=ssrand(ny,nwu,nx);
C1=rand(1,nx);D1=[0,1];
UIobs=ui_observer(Sys,1,C1,D1);
.fi
.SH AUTHOR
F.D.
.SH SEE ALSO
cainv, ddp, abinv



