.TH binomial 2 "April 1993" "Scilab Group" "Scilab Function"
.SH NAME
binomial - binomial distribution
.SH CALLING SEQUENCE
.nf
pr=binomial(p,n)
.fi
.SH PARAMETERS
.TP
pr
: vector, pr(k) = probability (X=k) , with X=B(n,p).
.TP
p
: real number
.TP
n
:
integer
.SH DESCRIPTION
\fVpr=binomial(p,n)\fR return a binomial probability vector.
pr(k) = probability (X=k) , with X=B(n,p) i.e the
probability of k success in n independent trials, (p = proba. of one success).
\fVpr(k) = C(n,k) p^k (1-p)^(n-k)\fR with 
C(n,k)= n!/(k!(n-k)!) = prod(1:n)/(prod(1:k)*prod(1:n-k)).
.SH EXAMPLE
.nf
n=10;p=0.3;plot2d3(0:n,binomial(p,n));
n=100;p=0.3;
mea=n*p;sigma=sqrt(n*p*(1-p));
x=( (0:n)-mea )/sigma;
plot2d(x,sigma*binomial(p,n));
deff('y=Gauss(x)','y=1/sqrt(2*%pi)*exp(-(x.^2)/2)')
plot2d(x,Gauss(x));
.fi
.SH SEE ALSO
cdfbin
