.TH or 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
or | - logical or
.SH CALLING SEQUENCE
.nf
or(A),  or(A,'*')
or(A,'r'), or(A,1)

or(A,'c'), or(A,2)
A|B
.fi
.SH DESCRIPTION
\fVor(A)\fR  gives the  \fVor\fR of the elements of the  boolean 
matrix  \fVA\fR. \fVor(A)\fR is true (\fV%t\fR) iff at least one entry of
\fVA\fR is \fV%t\fR. 
.LP
\fVy=or(A,'r')\fR (or, equivalently, \fVy=or(A,1)\fR) is the rowwise or. It returns in each 
entry of the row vector \fVy\fR the or of the rows of \fVx\fR (The or is performed on the 
row index : \fVy(j)= or(A(i,j),i=1,m)\fR).
.LP
\fVy=or(A,'c')\fR (or, equivalently, \fVy=or(A,2)\fR) is the columnwise or. It returns 
in each entry of the column vector \fVy\fR the or of the columns of \fVx\fR 
(The or is performed on the column index:  \fVy(i)= or(A(i,j),j=1,n)\fR)).
.LP
\fVA|B\fR  gives the element-wise logical \fVor\fR of the booleans matrices
 \fVA\fR and  \fVB\fR .\fVA\fR and  \fVB\fR must be matrices with the same
 dimensions or one from them must be a single boolean.

.SH EXAMPLES
.nf
or([%t %t %f])
[%t %t %f]|[%f %t %t]
[%t %t %f]|%f
.fi
.SH SEE ALSO
and, not, find

