.TH size 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
size - size of objects
.SH CALLING SEQUENCE
.nf
y=size(x [,sel])
[nr,nc]=size(x)
.fi
.SH PARAMETERS
.TP 10
x
: matrix (including transfer matrix) or list or linear system (\fVsyslin\fR)
.TP
y
: \fV 1x2 \fR integer vector or integer number
.TP
sel
: a scalar or a character string
.TP
nr,nc
: two integers
.SH DESCRIPTION
.TP 10
Applied to :
a matrix (constant, polynomial, string, boolean, rational) \fVx\fR,
with only one lhs argument \fVsize\fR returns a \fV1\fRx\fV2\fR vector
[number of rows, number of columns].

Called with LHS=2, returns \fVnr,nc\fR = [number of rows, number of columns].

\fVsel\fR may be used to specify what dimension to get:
.RS
.TP 15
1 or 'r' 
: to get the number of rows
.TP
2 or 'c' 
: to get the number of columns
.TP
 '*' 
: to get the product of rows and column numbers
.RE
.TP 10
Applied to: 
a list it returns the number of elements. In this case only 
 \fVy=size(x)\fR syntax can be used
.TP 10
Applied to:
 a linear system,
\fVy=size(x)\fR returns in \fVy\fR the (row) vector [number of outputs, number if inputs] i.e. the dimension of the corresponding transfer matrix.
The syntax \fV[nr,nc]=size(x)\fR is also valid (with \fV(nr,nc)=(y(1),y(2)\fR).

If \fVx\fR is a linear system in state-space
form, then \fV [nr,nc,nx]=size(x) \fR returns in addition the dimension \fVnx\fR
of the \fVA\fR matrix of \fVx\fR.
.TP 10
Applied to:
an hypermatrix \fV y=size(x) \fR returns the vector of hypermatrix
dimensions. \fV [n1,n2,...nn]=size(x) \fR returns the hypermatrix
dimensions. \fV ni=size(x,i) \fR returns the ith dimension and
size(x,'*') \fR returns the product of dimensions.

.SH EXAMPLES
.nf
[n,m]=size(rand(3,2))
[n,m]=size(['a','b';'c','d'])
x=ssrand(3,2,4);[ny,nu]=size(x)
[ny,nu]=size(ss2tf(x))
[ny,nu,nx]=size(x)
.fi
.SH SEE ALSO
length, syslin


