.TH mgetl 1 "April 2000" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
mgetl - read lines from an ascii file
.SH CALLING SEQUENCE
.nf
txt=mgetl(file_desc [,m]) 
.fi
.SH PARAMETERS
.TP 10
file_desc
:a character string giving the file name or a logical unit returned by mopen
.TP
m
: an integer scalar. Default value is -1.
.TP 
txt
: a column vector of string
.SH DESCRIPTION
\fVmgetl\fR function allows to read a lines from an ascii file. 
.LP
If \fVm\fR is
omitted or is \fV-1\fR all lines till end of file occurs are read.
.LP
If \fVm\fR is given \fVmgetl\fR tries to read exactly m lines, if an
end of file occurs before \fVm\fR lines are read an error is
issued. This option is useful to sequentialy read part of a file
as follow

.LP
\fVmgetl\fR allows to read files coming from Unix, Windows, or Mac
operating systems.

.SH EXAMPLE
.nf
mgetl('SCI/scilab.star',5)

mgetl SCI/macros/elem/and.sci

fd=mopen('SCI/scilab.star','r')
mgetl(fd,10)
mclose(fd)
.fi
.SH SEE ALSO
mputl, mclose,  mfscanf, mget, mgetstr, mopen, read
.SH AUTHOR
S. Steer
