.TH Sgrayplot 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
Sgrayplot - smooth 2D plot of a surface using colors
.SH CALLING SEQUENCE
.nf
Sgrayplot(x,y,z,[strf,rect,nax])
.fi
.SH DESCRIPTION
\fVSgrayplot\fR is the same as \fVgrayplot\fR but the plot is smoothed.
The function \fVfec\fR is used for smoothing.
The surface is plotted assuming that it is linear on a set of
triangles built from the grid:
.nf
    ______ 
    | /| /| 
    |/_|/_|  
    | /| /|
    |/_|/_|
.fi

Enter the command \fVSgrayplot()\fR to see a demo.
.SH EXAMPLE
.nf
x=-10:10; y=-10:10;m =rand(21,21);
Sgrayplot(x,y,m,"111",[-20,-20,20,20])
t=-%pi:0.1:%pi; m=sin(t)'*cos(t);
xbasc()
Sgrayplot(t,t,m)
.fi
.SH SEE ALSO
fec, fgrayplot, grayplot, Sfgrayplot
.SH AUTHOR
J.Ph.C.
