.TH champ 2 "April 1993" "Scilab Group" "Scilab Function" 
.so ../sci.an
.SH NAME
champ - 2D vector field plot
.SH CALLING SEQUENCE
.nf
champ(x,y,fx,fy,[arfact,rect,strf])
champ(x,y,fx,fy,<opt_args>)
.fi
.SH PARAMETERS
.TP 8
x,y
: two vectors which define the grid.
.TP
fx
: a matrix which describes the x component of the vector field. \fVfx(i,j)\fR
is the x component of the vector field at point \fV(x(i),y(j))\fR.
.TP 
fy
: a matrix which describes the y component of the vector field. \fVfy(i,j)\fR
is the y component of the vector field at point \fV(x(i),y(j))\fR.
.TP
<opt_args>
: This represents a sequence of statements \fVkey1=value1,
key2=value2\fR,... where \fVkey1\fR, \fVkey2,...\fR can be one of the
following: arfact, rect, strf (see below).
.TP
arfact
: an optional argument of type real which gives a scale factor for the display of the arrow heads on the plot (default value is 1.0).
.TP
rect
: a vector \fVrect=[xmin,ymin,xmax,ymax]\fR which gives the boundaries of the 
graphics frame to use.
.TP
strf 
: a string of length 3 "xyz" which has the same meaning as the \fVstrf\fR
parameter of \fVplot2d\fR. The first character x has no effect with \fVchamp\fR.
.SH DESCRIPTION 
\fVchamp\fR draws a 2D vector field. The length 
of the arrows is proportional to the intensity of the field.

If you want colored arrows with the color of the arrows depending on the 
intensity of the field, use \fVchamp1\fR.

Enter the command \fVchamp()\fR to see a demo.
.SH EXAMPLE
.nf 
// using rect as plot boundaries 
champ(-5:5,-5:5,rand(11,11),rand(11,11),1,[-10,-10,10,10],"011")
// using (x,y) to get boundaries 
xbasc()
champ(-5:5,-5:5,rand(11,11),rand(11,11),2,[-10,-10,10,10],"021")
.fi
.SH SEE ALSO
champ1, fchamp, plot2d
.SH AUTHOR
J.Ph.C.
