.TH plot3d3 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
plot3d3 - mesh plot surface defined by rectangular facets
.SH DESCRIPTION
.nf
plot3d3(X,Y,Z [,vect,theta,alpha,leg,flag,ebox])
plot3d3(X,Y,Z, <opt_args>)
.fi
.SH PARAMETERS
.TP 10
X,Y,Z
: 3 real matrices
.TP
vect
: real vector
.TP
flag
:  flag=[type,box], type and box have the same meaning as in plot3d.
.TP
<opt_args>
: This represents a sequence of statements \fVkey1=value1,
key2=value2\fR,... where \fVkey1\fR, \fVkey2,...\fR can be one of the
following: vect,flag (see above), theta, alpha ,leg,ebox (see \fVplot3d\fR)

.SH DESCRIPTION
\fVplot3d3\fR performs a mesh plot of a surface defined by rectangular facets.
(X,Y,Z) are three matrices which describe a surface.
The surface is composed of four sided polygons. 
.LP
The X-coordinates of a facet are given by X(i,j),X(i+1,j),X(i,j+1),X(i+1,j+1).
And similarly Y and Z are Y and Z coordinates.
.LP
The \fVvect\fR vector is used when multiple surfaces are coded 
in the same (X,Y,Z) matrices. \fVvect(j)\fR gives the line 
at which the coding of the jth surface begins. 
See \fVplot3d2\fR for a full description.
.SH EXAMPLE 
.nf
u = linspace(-%pi/2,%pi/2,40);
v = linspace(0,2*%pi,20);
X = cos(u)'*cos(v);
Y = cos(u)'*sin(v);
Z = sin(u)'*ones(v);
plot3d3(X,Y,Z);
.fi
.SH SEE ALSO
plot3d2, plot3d, param3d


