.TH eigenmarkov 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an 
.SH NAME
eigenmarkov - normalized left and right Markov eigenvectors 
.SH CALLING SEQUENCE
.nf
[M,Q]=eigenmarkov(P)
.fi
.SH PARAMETERS
.TP 10
P
: real N x N Markov matrix. Sum of entries in each row should add to one.
.TP
M
: real matrix with N columns.
.TP
Q
: real matrix with N rows.
.SH DESCRIPTION
Returns normalized left and right eigenvectors
associated with the eigenvalue 1 of the Markov transition matrix P.
If the multiplicity of this eigenvalue is m and P
is N x N, M is a m x N matrix and Q a N x m matrix.
M(k,:) is the probability distribution vector associated with the kth
ergodic set (recurrent class). M(k,x) is zero if x is not in the
k-th recurrent class.
Q(x,k) is the probability to end in the k-th recurrent class starting
from x. If \fVP^k\fR converges for large \fVk\fR (no eigenvalues on the
unit circle except 1), then the limit is \fVQ*M\fR (eigenprojection).
.SH EXAMPLE
.nf
//P has two recurrent classes (with 2 and 1 states) 2 transient states
P=genmarkov([2,1],2) 
[M,Q]=eigenmarkov(P);
P*Q-Q
Q*M-P^20
.fi
.SH SEE ALSO
genmarkov, classmarkov




