.TH lusolve G "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
lusolve - sparse linear system solver
.SH CALLING SEQUENCE
.nf
lusolve(hand,b)
lusolve(A,b)
.fi
.SH PARAMETERS
.TP
b 
: full real matrix
.TP
A
: real square sparse invertible matrix 
.TP
hand 
: handle to a previously computed sparse lu factors (output of lufact)
.SH DESCRIPTION
.Vb x=lusolve(hand,b)
solves the sparse linear system  \fVA*x = b\fR.
.LP
\fV[hand,rk]=lufact(A)\fR is the output of lufact.
.LP
.Vb x=lusolve(A,b) solves the sparse linear system  \fVA*x = b\fR.
.SH EXAMPLE
.nf
non_zeros=[1,2,3,4];rows_cols=[1,1;2,2;3,3;4,4];
sp=sparse(rows_cols,non_zeros);
[h,rk]=lufact(sp);x=lusolve(h,[1;1;1;1]);ludel(h)
rk,sp*x


non_zeros=[1,2,3,4];rows_cols=[1,1;2,2;3,3;4,4];
sp=sparse(rows_cols,non_zeros);
x=lusolve(sp,-ones(4,1));
sp*x

.fi
.SH SEE ALSO
sparse, lufact, slash, backslash

