.TH pvm_mytid 1 "May 1998" "Scilab // Group" "Scilab function"
.so ../sci.an
.SH NAME
pvm_mytid - returns the \fItid\fR of the calling process.
.SH CALLING SEQUENCE
.nf
[tid] = pvm_mytid()
.fi
.SH PARAMETERS
.TP 5
tid
: integer, the task identifier of the calling PVM process.
Values less than zero indicate an error.

.SH DESCRIPTION
\fVpvm_mytid\fR 
enrolls this process
into PVM on its first call. It also generates a unique
.I tid
if this process was not created by pvm_spawn.
pvm_mytid returns the
.I tid
of the calling process
and can be called multiple times in an application.
.PP
Any PVM system call (not just pvm_mytid) will enroll a task in PVM
if the task is not enrolled before the call.
.PP
The tid is a 32 bit positive integer created by the local pvmd.
The 32 bits are divided into fields that encode various
information about this process such as its location in
the virtual machine (i.e. local pvmd address),
the CPU number in the case where the process is on
a multiprocessor, and a process ID field. This information
is used by PVM and is not expected to be used by applications.
Applications should not attempt to predict or interpret the tid with
the exception of calling tidtohost()
.PP
If PVM has not been started before an application calls pvm_mytid
the returned
.I tid
will be < 0.

.SH EXAMPLE
.nf
tid = pvm_mytid()
.fi

.SH SEE ALSO
pvm_tidtohost, pvm_parent
