.TH steadycos  "May 2000" "Scilab Group" "Scicos function"
.so ../sci.an
.SH NAME
steadycos - Finds an equilibrium state of a system described by a scicos diagram
.SH CALLING SEQUENCE
.nf
[X,U,Y,XP]=steadycos(scs_m,X,U,Y,Indx,Indu,Indy [,Indxp [,param ] ])
.fi
.SH PARAMETERS
.TP 10
scs_m
: a Scicos data structure
.TP
X
: column vector. Continuous state. Can be set to [] if zero.
.TP
U
: column vector. Input. Can be set to [] if zero.
.TP
Y
: column vector. Output. Can be set to [] if zero.
.TP
Indx
:vector,  index of entries of X that are not fixed. If all can vary, set
to 1:$
.TP
Indu
: vector, index of entries of U that are not fixed. If all can vary, set
to 1:$
.TP
Indy
:vector,  index of entries of Y that are not fixed. If all can vary, set
to 1:$
.TP
 Indxp
:vector, index of entries of XP (derivative of X) that need not be
zero. If all can vary, set to \fV1:$\fR. Default [].
.TP
param
: list with two elements (default \fVlist(1.d-6,0)\fR)
.RS
.TP
param(1)
: scalar. Perturbation level for linearization; the
following variation is used  
\fVdel([x;u])_i = param(1)+param(1)*1d-4*abs([x;u])\fR
.TP
param(2)
: scalar. Time t
.RE
.SH DESCRIPTION
Finds an equilibrium state of a general
dynamical system described by a scicos diagram.
.TP
.SH SEE ALSO
scicos, scicos_main, lincos
.SH EXAMPLE
.nf
.fi
.SH AUTHOR
R. Nikoukhah
