/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.painter;

import java.awt.*;

import javax.swing.JTabbedPane;

import org.jvnet.substance.SubstanceTabbedPaneUI;

/**
 * Decay translucency {@link ControlBackgroundComposite}. The component is
 * painted translucent, the translucency is computed based on the distance to
 * the closest active sibling. Currently this composite is relevant only for
 * {@link JTabbedPane}s.
 * 
 * @author Kirill Grouchnikov
 */
public class DecayControlBackgroundComposite extends
		ControlBackgroundComposite {
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.painter.ControlBackgroundComposite#getBackgroundComposite(java.awt.Component,
	 *      java.awt.Container, int, boolean)
	 */
	public Composite getBackgroundComposite(Component component,
			Container container, int componentIndex, boolean isPaintedActive) {
		if (isPaintedActive)
			return AlphaComposite.SrcOver;

		if ((container instanceof JTabbedPane) && (componentIndex >= 0)) {
			JTabbedPane tabPane = (JTabbedPane) container;
			SubstanceTabbedPaneUI ui = (SubstanceTabbedPaneUI) tabPane.getUI();
			Rectangle tabRect = ui.getTabRectangle(componentIndex);
			Rectangle selectedTabRect = ui.getTabRectangle(tabPane
					.getSelectedIndex());
			int dx = selectedTabRect.x + selectedTabRect.width / 2 - tabRect.x
					- tabRect.width / 2;
			int dy = selectedTabRect.y + selectedTabRect.height / 2 - tabRect.y
					- tabRect.height / 2;
			double dist = Math.pow(dx * dx + dy * dy, 0.3);
			double decay = 1.0 - Math.log(1.0 + dist) / 7.0;
			if (decay < 0.2)
				decay = 0.2;
			return AlphaComposite.getInstance(AlphaComposite.SRC_OVER,
					(float) decay);
		}

		return AlphaComposite.SrcOver;
	}
}
