/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package org.jvnet.substance.skin;

import org.jvnet.substance.border.ClassicInnerBorderPainter;
import org.jvnet.substance.button.ClassicButtonShaper;
import org.jvnet.substance.color.LightGrayColorScheme;
import org.jvnet.substance.painter.*;
import org.jvnet.substance.painter.decoration.ArcDecorationPainter;
import org.jvnet.substance.painter.decoration.DecorationAreaType;
import org.jvnet.substance.painter.highlight.ClassicHighlightPainter;
import org.jvnet.substance.theme.*;
import org.jvnet.substance.theme.SubstanceTheme.ThemeKind;
import org.jvnet.substance.utils.SubstanceConstants.ColorShiftKind;
import org.jvnet.substance.watermark.SubstanceNullWatermark;

/**
 * <code>Creme</code> skin. This class is part of officially supported API.
 * 
 * @author Kirill Grouchnikov
 * @since version 3.1
 */
public class CremeSkin extends SubstanceAbstractSkin {
	/**
	 * Display name for <code>this</code> skin.
	 */
	public static String NAME = "Creme";

	/**
	 * Creates a new <code>Creme</code> skin.
	 */
	public CremeSkin() {
		SubstanceTheme activeTheme = new SubstanceLightAquaTheme().tint(0.3);
		SubstanceTheme defaultTheme = new SubstanceCremeTheme();
		SubstanceTheme disabledTheme = new SubstanceTheme(
				new LightGrayColorScheme(), "Tint Light Gray", ThemeKind.COLD)
				.tint(0.35);
		SubstanceTheme activeTitleTheme = defaultTheme;

		SubstanceComplexTheme theme = new SubstanceComplexTheme(NAME,
				ThemeKind.COLD, activeTheme, defaultTheme, disabledTheme,
				activeTitleTheme);

		theme.registerDecorationAreaTheme(activeTitleTheme, false,
				DecorationAreaType.PRIMARY_TITLE_PANE,
				DecorationAreaType.SECONDARY_TITLE_PANE,
				DecorationAreaType.HEADER, DecorationAreaType.GENERAL,
				DecorationAreaType.TOOLBAR);

		theme
				.setNonActivePainter(new SimplisticSoftBorderReverseGradientPainter());
		theme.setSelectedTabFadeStart(0.2);
		theme.setSelectedTabFadeEnd(0.4);
		this.theme = theme;
		// ((SubstanceComplexTheme) this.theme)
		// .setCellRendererBackgroundTheme(new SubstanceBlendBiTheme(
		// new SubstanceTerracottaTheme(),
		// new SubstanceSunGlareTheme(), 0.5).tint(0.2));
		// theme.addPaintAsActive(JScrollBar.class);
		this.buttonShaper = new ClassicButtonShaper();
		this.watermark = new SubstanceNullWatermark();
		this.gradientPainter = new ClassicGradientPainter();
		this.decorationPainter = new ArcDecorationPainter();
		this.borderPainter = new ClassicInnerBorderPainter(0.8f,
				ColorShiftKind.TINT);
		this.highlightPainter = new ClassicHighlightPainter();

		this.tabBackgroundComposite = new AlphaControlBackgroundComposite(0.75f);

		this.borderPainter = new ClassicInnerBorderPainter(0.9f,
				ColorShiftKind.TINT);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jvnet.substance.skin.SubstanceSkin#getDisplayName()
	 */
	public String getDisplayName() {
		return NAME;
	}
}
