package test;

import java.awt.BorderLayout;

import javax.swing.*;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;

public class TableRowMargin extends JFrame {
	public TableRowMargin() {
		this.setLayout(new BorderLayout());

		JTable table = new JTable(new DefaultTableModel() {
			@Override
			public int getRowCount() {
				return 10;
			}

			@Override
			public int getColumnCount() {
				return 2;
			}

			@Override
			public Object getValueAt(int row, int column) {
				return row + ":" + column;
			}

		}) {
			@Override
			public void setRowHeight(int rowHeight) {
				super.setRowHeight(50);
			}
		};

		table.setRowMargin(10);

		this.add(new JScrollPane(table), BorderLayout.CENTER);

		this.setSize(600, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TableRowMargin().setVisible(true);
			}
		});
	}
}