/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

import org.jvnet.substance.SubstanceLookAndFeel;

public class TableSkin extends JFrame {
	public TableSkin() {
		this.setLayout(new BorderLayout());

		JTable table = new JTable(new DefaultTableModel() {
			@Override
			public int getRowCount() {
				return 10;
			}

			@Override
			public int getColumnCount() {
				return 2;
			}

			@Override
			public Object getValueAt(int row, int column) {
				return row + ":" + column;
			}
		});

//		table.getColumnModel().getColumn(0).setCellRenderer(
//				new DefaultTableCellRenderer() {
//					@Override
//					public Component getTableCellRendererComponent(
//							JTable table, Object value, boolean isSelected,
//							boolean hasFocus, int row, int column) {
//						Component result = super
//								.getTableCellRendererComponent(table, value,
//										isSelected, hasFocus, row, column);
//
//						result
//								.setBackground(new Color(255 - row * 10, 255,
//										255));
//						result.setForeground(new Color(20 * row, 20 * row,
//								20 * row));
//
//						return result;
//					}
//				});
//
//		table.getColumnModel().getColumn(1).setCellRenderer(
//				new DefaultTableCellRenderer() {
//					@Override
//					public Component getTableCellRendererComponent(
//							JTable table, Object value, boolean isSelected,
//							boolean hasFocus, int row, int column) {
//						
//						Component result = super
//								.getTableCellRendererComponent(table, value,
//										isSelected, hasFocus, row, column);
//
//						result.setBackground(Color.yellow);
//						result.setForeground(Color.red);
//
//						return result;
//					}
//				});
		table.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);

		this.add(new JScrollPane(table), BorderLayout.CENTER);

		JPanel lafButtons = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		JButton setMetal = new JButton("Metal");
		setMetal.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager.setLookAndFeel(new MetalLookAndFeel());
							SwingUtilities.updateComponentTreeUI(TableSkin.this);
						}
						catch (Exception exc) {
							exc.printStackTrace();
						}
					}
				});
			}
		});
		lafButtons.add(setMetal);
		JButton setSubstance = new JButton("Substance");
		setSubstance.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						try {
							UIManager.setLookAndFeel(new SubstanceLookAndFeel());
							SwingUtilities.updateComponentTreeUI(TableSkin.this);
						}
						catch (Exception exc) {
							exc.printStackTrace();
						}
					}
				});
			}
		});
		lafButtons.add(setSubstance);
		this.add(lafButtons, BorderLayout.SOUTH);
		
		this.setSize(600, 400);
		this.setLocationRelativeTo(null);
		this.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new TableSkin().setVisible(true);
			}
		});
	}
}
