/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.check;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import javax.swing.JComboBox;
import javax.swing.JComponent;

import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.painter.*;

/**
 * A combobox that allows selection and application of a
 * {@link ControlBackgroundComposite}.
 * 
 * @author Kirill Grouchnikov
 */
public class BackgroundCompositeCombo extends JComboBox {
	/**
	 * Component to apply the selected {@link ControlBackgroundComposite}.
	 */
	protected JComponent component;

	/**
	 * Creates a new selector combobox.
	 * 
	 * @param component
	 *            Component to apply the selected
	 *            {@link ControlBackgroundComposite}.
	 */
	public BackgroundCompositeCombo(final JComponent component) {
		super(new Object[] { "default", "decay", "alpha 0.25", "alpha 0.5",
				"alpha 0.75" });
		this.component = component;
		this.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if (e.getStateChange() == ItemEvent.SELECTED) {
					Object selected = e.getItem();
					if ("default".equals(selected))
						component.putClientProperty(
								SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
								new DefaultControlBackgroundComposite());
					if ("decay".equals(selected))
						component.putClientProperty(
								SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
								new DecayControlBackgroundComposite());
					if ("alpha 0.25".equals(selected))
						component.putClientProperty(
								SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
								new AlphaControlBackgroundComposite(0.25f));
					if ("alpha 0.5".equals(selected))
						component.putClientProperty(
								SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
								new AlphaControlBackgroundComposite(0.5f));
					if ("alpha 0.75".equals(selected))
						component.putClientProperty(
								SubstanceLookAndFeel.BACKGROUND_COMPOSITE,
								new AlphaControlBackgroundComposite(0.75f));
					component.repaint();
				}
			}
		});
	}
}
