/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package test.check;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.*;
import javax.swing.border.TitledBorder;

import org.jvnet.lafwidget.LafWidgetUtilities;
import org.jvnet.lafwidget.animation.*;

/**
 * Test application panel for testing {@link JProgressBar} component.
 * 
 * @author Kirill Grouchnikov
 */
public class ProgressBarPanel extends JPanel {
	@RunOnEDT
	private final class ProgressBarFadeTrackerAdapter extends
			FadeTrackerAdapter {
		@Override
		public void fadePerformed(FadeKind fadeKind, float fadeCycle10) {
			delta(ProgressBarPanel.this, 1);
		}
	}

	/**
	 * ID of the looping task that updates the progress bars.
	 */
	private long progressFadeId;

	/**
	 * Custom fade kind for updating the progress bars.
	 */
	private static final FadeKind PROGRESS_FADE = new FadeKind(
			"substancelaf.testApp.progress", true);

	/**
	 * Button that starts the update of progress bars.
	 */
	private JButton startButton;

	/**
	 * Button that stops the update of progress bars.
	 */
	private JButton stopButton;

	/**
	 * Creates a new panel with progress bars.
	 */
	public ProgressBarPanel() {
		this.setLayout(new BorderLayout());

		JPanel bars = new ScrollablePanel();
		GridLayout gLayout = new GridLayout(1, 2);
		gLayout.setHgap(5);
		gLayout.setVgap(5);
		bars.setLayout(gLayout);

		JPanel horizPanel = new JPanel();
		horizPanel.setLayout(new BoxLayout(horizPanel, BoxLayout.Y_AXIS));
		bars.add(horizPanel);

		JPanel vertPanel = new JPanel();
		vertPanel.setLayout(new BoxLayout(vertPanel, BoxLayout.X_AXIS));
		bars.add(vertPanel);

		JProgressBar determinateEnHor = new JProgressBar(
				JProgressBar.HORIZONTAL, 0, 100);
		determinateEnHor.setIndeterminate(false);
		JPanel dehPanel = new JPanel();
		dehPanel.add(determinateEnHor);
		dehPanel.setBorder(new TitledBorder("Determ enabled"));

		JProgressBar determinateEnHorStr = new JProgressBar(
				JProgressBar.HORIZONTAL, 0, 100);
		determinateEnHorStr.setIndeterminate(false);
		determinateEnHorStr.setStringPainted(true);
		JPanel dehsPanel = new JPanel();
		dehsPanel.add(determinateEnHorStr);
		dehsPanel.setBorder(new TitledBorder("Determ enabled string"));

		JProgressBar indeterminateEnHor = new JProgressBar(
				JProgressBar.HORIZONTAL, 0, 100);
		indeterminateEnHor.setIndeterminate(true);
		indeterminateEnHor.setStringPainted(true);
		indeterminateEnHor.setString("In progress");
		JPanel iehPanel = new JPanel();
		iehPanel.add(indeterminateEnHor);
		iehPanel.setBorder(new TitledBorder("Indeterm enabled"));

		horizPanel.add(dehPanel);
		horizPanel.add(dehsPanel);
		horizPanel.add(iehPanel);

		JProgressBar determinateDisHor = new JProgressBar(
				JProgressBar.HORIZONTAL, 0, 100);
		determinateDisHor.setIndeterminate(false);
		determinateDisHor.setEnabled(false);
		JPanel ddhPanel = new JPanel();
		ddhPanel.add(determinateDisHor);
		ddhPanel.setBorder(new TitledBorder("Determ disabled"));

		JProgressBar determinateDisHorStr = new JProgressBar(
				JProgressBar.HORIZONTAL, 0, 100);
		determinateDisHorStr.setIndeterminate(false);
		determinateDisHorStr.setEnabled(false);
		determinateDisHorStr.setStringPainted(true);
		JPanel ddhsPanel = new JPanel();
		ddhsPanel.add(determinateDisHorStr);
		ddhsPanel.setBorder(new TitledBorder("Determ disabled string"));

		JProgressBar indeterminateDisHor = new JProgressBar(
				JProgressBar.HORIZONTAL, 0, 100);
		indeterminateDisHor.setIndeterminate(true);
		indeterminateDisHor.setEnabled(false);
		JPanel idhPanel = new JPanel();
		idhPanel.add(indeterminateDisHor);
		idhPanel.setBorder(new TitledBorder("Indeterm disabled"));

		horizPanel.add(ddhPanel);
		horizPanel.add(ddhsPanel);
		horizPanel.add(idhPanel);

		JProgressBar determinateEnVer = new JProgressBar(JProgressBar.VERTICAL,
				0, 100);
		determinateEnVer.setIndeterminate(false);
		determinateEnVer.setStringPainted(true);
		JPanel devPanel = new JPanel();
		devPanel.add(determinateEnVer);
		devPanel.setBorder(new TitledBorder("Determ enabled"));

		JProgressBar determinateEnVerRTL = new JProgressBar(
				JProgressBar.VERTICAL, 0, 100);
		determinateEnVerRTL.setIndeterminate(false);
		determinateEnVerRTL.setStringPainted(true);
		determinateEnVerRTL
				.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
		JPanel devRtlPanel = new JPanel();
		devRtlPanel.add(determinateEnVerRTL);
		devRtlPanel.setBorder(new TitledBorder("Determ enabled RTL"));

		JProgressBar indeterminateEnVer = new JProgressBar(
				JProgressBar.VERTICAL, 0, 100);
		indeterminateEnVer.setIndeterminate(true);
		indeterminateEnVer.setStringPainted(true);
		indeterminateEnVer.setString("In progress");
		JPanel ievPanel = new JPanel();
		ievPanel.add(indeterminateEnVer);
		ievPanel.setBorder(new TitledBorder("Indeterm enabled"));

		vertPanel.add(devPanel);
		vertPanel.add(devRtlPanel);
		vertPanel.add(ievPanel);

		JProgressBar determinateDisVer = new JProgressBar(
				JProgressBar.VERTICAL, 0, 100);
		determinateDisVer.setIndeterminate(false);
		determinateDisVer.setEnabled(false);
		JPanel ddvPanel = new JPanel();
		ddvPanel.add(determinateDisVer);
		ddvPanel.setBorder(new TitledBorder("Determ disabled"));

		JProgressBar indeterminateDisVer = new JProgressBar(
				JProgressBar.VERTICAL, 0, 100);
		indeterminateDisVer.setIndeterminate(true);
		indeterminateDisVer.setEnabled(false);
		JPanel idvPanel = new JPanel();
		idvPanel.add(indeterminateDisVer);
		idvPanel.setBorder(new TitledBorder("Indeterm disabled"));

		vertPanel.add(ddvPanel);
		vertPanel.add(idvPanel);

		this.add(new JScrollPane(bars), BorderLayout.CENTER);

		JPanel buttons = new JPanel();
		buttons.setLayout(new FlowLayout(FlowLayout.CENTER));
		this.startButton = new JButton("start");
		this.startButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				progressFadeId = FadeTracker.getInstance().trackFadeLooping(
						PROGRESS_FADE,
						LafWidgetUtilities.getAnimationKind(
								ProgressBarPanel.this).derive(0.2f),
						ProgressBarPanel.this, null, false,
						new ProgressBarFadeTrackerAdapter(), -1, false);
				startButton.setEnabled(false);
				stopButton.setEnabled(true);
			}
		});

		this.stopButton = new JButton("stop");
		this.stopButton.setEnabled(false);
		this.stopButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				FadeTracker.getInstance().cancelFadeInstance(progressFadeId);
				stopButton.setEnabled(false);
				startButton.setEnabled(true);
			}
		});

		JButton plus10Button = new JButton("plus 10");
		plus10Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				delta(ProgressBarPanel.this, 10);
			}
		});
		buttons.add(plus10Button);

		JButton minus10Button = new JButton("minus 10");
		minus10Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				delta(ProgressBarPanel.this, -10);
			}
		});
		buttons.add(minus10Button);

		JButton plus1Button = new JButton("plus 1");
		plus1Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				delta(ProgressBarPanel.this, 1);
			}
		});
		buttons.add(plus1Button);

		JButton minus1Button = new JButton("minus 1");
		minus1Button.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				delta(ProgressBarPanel.this, -1);
			}
		});
		buttons.add(minus1Button);

		JButton resetButton = new JButton("reset");
		resetButton.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				reset(ProgressBarPanel.this);
			}
		});

		buttons.add(this.startButton);
		buttons.add(this.stopButton);
		buttons.add(resetButton);

		this.add(buttons, BorderLayout.SOUTH);
	}

	protected static void delta(Component c, int delta) {
		if (c instanceof JProgressBar) {
			JProgressBar pb = (JProgressBar) c;
			if (!pb.isIndeterminate()) {
				int newValue = pb.getValue() + delta;
				if (newValue < pb.getMinimum())
					newValue = pb.getMinimum();
				if (newValue > pb.getMaximum())
					newValue = pb.getMaximum();
				pb.setValue(newValue);
			}
		}
		if (c instanceof Container) {
			Container cont = (Container) c;
			for (int i = 0; i < cont.getComponentCount(); i++) {
				delta(cont.getComponent(i), delta);
			}
		}
	}

	protected static void reset(Component c) {
		if (c instanceof JProgressBar) {
			JProgressBar pb = (JProgressBar) c;
			if (!pb.isIndeterminate()) {
				pb.setValue(pb.getMinimum());
			}
		}
		if (c instanceof Container) {
			Container cont = (Container) c;
			for (int i = 0; i < cont.getComponentCount(); i++) {
				reset(cont.getComponent(i));
			}
		}
	}
}