package test.contrib;

import java.awt.*;
import java.awt.event.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.*;
import javax.swing.text.*;

public class ComboKeys {

	public static void main(String[] args) throws Exception {
		// UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		UIManager.setLookAndFeel("org.jvnet.substance.SubstanceLookAndFeel");
		// UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");

		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame frame = new JFrame("Combo Keys");
				frame.add(createCombo(), BorderLayout.NORTH);
				frame.setSize(200, 100);
				frame.setLocationRelativeTo(null);
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				frame.addWindowListener(new WindowAdapter() {
					@Override
					public void windowOpened(WindowEvent e) {
						super.windowOpened(e);
						dumpKeymapName("WindowOpened", combo);
					}
				});
				frame.setVisible(true);
			}
		});
	}

	static JComboBox combo;

	static JComponent createCombo() {
		combo = new JComboBox();
		combo.setEditable(true);

		combo.addPropertyChangeListener("editor", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent evt) {
				Object newO = evt.getNewValue();
				Object oldO = evt.getOldValue();
				System.err.println("PropChange: combo editor:" + " old="
						+ (oldO != null ? oldO.getClass().getName() : "null")
						+ " new="
						+ (newO != null ? newO.getClass().getName() : "null"));
			}
		});

		Font font = combo.getFont();
		combo.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));

		JTextComponent text = (JTextComponent) combo.getEditor()
				.getEditorComponent();
		Keymap keymap = JTextComponent.addKeymap("combo", text.getKeymap());
		JTextComponent.KeyBinding[] bindings = { new JTextComponent.KeyBinding(
				KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), "foo"), };
		Action[] actions = { new TextAction("foo") {
			public void actionPerformed(ActionEvent e) {
				System.err.println("LOCAL ACTION");
				Toolkit.getDefaultToolkit().beep();
			}
		} };
		JTextComponent.loadKeymap(keymap, bindings, actions);
		text.setKeymap(keymap);
		dumpKeymapName("After Construct", combo);

		return combo;
	}

	static void dumpKeymapName(String tag, JComboBox combo) {
		JTextComponent text = (JTextComponent) combo.getEditor()
				.getEditorComponent();
		Keymap keymap = text.getKeymap();
		System.err.println(tag + ": KeymapName: " + keymap.getName());
	}
}