package test.contrib;

import java.awt.BorderLayout;
import java.awt.event.*;

import javax.swing.*;

import org.jvnet.substance.SubstanceLookAndFeel;


public class FrameDemo extends JFrame
{
    public FrameDemo()
    {
        setTitle("Frame Demo");

        JButton button = new JButton("New Frame");
        button.addActionListener(new ActionListener()
        {
            public void actionPerformed(ActionEvent e)
            {
                new MyFrame();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(20, 20));
        mainPanel.add(new JLabel("     Press the button to make a new frame     "), BorderLayout.CENTER);
        mainPanel.add(button, BorderLayout.SOUTH);
        setContentPane(mainPanel);
        setLocation(100, 100);
        pack();
        setVisible(true);
    }


    /**
     * Create the GUI and show it.  For thread safety,
     * this method should be invoked from the
     * event-dispatching thread.
     */
    private static void createAndShowGUI()
    {
        //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        UIManager.put(SubstanceLookAndFeel.NO_EXTRA_ELEMENTS, Boolean.TRUE);
        try
        {
            UIManager.setLookAndFeel(new SubstanceLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e)
        {
            // Do nothing
        }
        JDialog.setDefaultLookAndFeelDecorated(true);
        //%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

        //Make sure we have nice window decorations.
        JFrame.setDefaultLookAndFeelDecorated(true);

        //Create and set up the window.
        FrameDemo frame = new FrameDemo();
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        //Display the window.
        frame.setVisible(true);
    }

    public static void main(String[] args)
    {
        //Schedule a job for the event-dispatching thread:
        //creating and showing this application's GUI.
        javax.swing.SwingUtilities.invokeLater(new Runnable()
        {
            public void run()
            {
                createAndShowGUI();
            }
        });
    }

    private class MyFrame extends JFrame
    {
        public MyFrame()
        {
            super();
            setTitle("New Frame");
            addWindowListener(new WindowDetector());
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout(100, 100));
            JLabel label = new JLabel("NORTH");
            label.setHorizontalAlignment(JLabel.CENTER);
            mainPanel.add(label, BorderLayout.NORTH);
            label = new JLabel("SOUTH");
            label.setHorizontalAlignment(JLabel.CENTER);
            mainPanel.add(label, BorderLayout.SOUTH);
            mainPanel.add(new JLabel("EAST"), BorderLayout.EAST);
            mainPanel.add(new JLabel("WEST"), BorderLayout.WEST);
            mainPanel.add(new JLabel("CENTER"), BorderLayout.CENTER);
            setContentPane(mainPanel);
            setLocation(250, 250);
            pack();
            setVisible(true);
        }

        class WindowDetector extends WindowAdapter
        {
            public void windowDeactivated(WindowEvent e)
            {
            	System.out.println("Disposing");
                MyFrame.this.dispose();
                System.out.println("Disposed");
            }
        }
    }
}
