package test.contrib;

import java.awt.Color;
import java.awt.Container;
import java.util.Hashtable;

import javax.swing.*;

public class JSliderTest {
	public static void main(String[] args) {
		try {
			JFrame.setDefaultLookAndFeelDecorated(true);
			UIManager
					.setLookAndFeel("org.jvnet.substance.SubstanceLookAndFeel"); // works if commeted out
			JSlider s = new JSlider();
			s.setMinimum(0);
			s.setMaximum(2);
			s.setMajorTickSpacing(1);
			s.setPaintLabels(true);
			Hashtable labels = new Hashtable();
			JLabel l0 = new JLabel("Red");
			l0.setForeground(new Color(128, 0, 0));
			labels.put(new Integer(0), l0);
			JLabel l1 = new JLabel("Green");
			l1.setForeground(new Color(0, 128, 0));
			labels.put(new Integer(1), l1);
			JLabel l2 = new JLabel("Blue");
			l2.setForeground(new Color(0, 0, 128));
			labels.put(new Integer(2), l2);
			s.setLabelTable(labels);
			final JFrame frame = new JFrame("Slider Label Color"); // NON-NLS
			frame.addWindowListener(new java.awt.event.WindowAdapter() {
				@Override
				public void windowClosing(java.awt.event.WindowEvent e) {
					frame.dispose();
					System.exit(0);
				};
			});
			Container p = frame.getContentPane();
			p.add(s);
			frame.pack();
			frame.setVisible(true);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
