package test.contrib;

import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

import javax.swing.*;
import javax.swing.table.AbstractTableModel;

/**
 * This is a small class that creates a JTable with 7 rows, then it runs
 * startTest which adds 50 rows then updates the fonts and right after that adds
 * 50 more rows. This causes the program to throw a NullPointerException in the
 * SubstanceTableUI$TableStateListener
 * 
 * @author allak
 * 
 */
public class SubstanceTableTest {
	private JTable table;
	private LocalTableModel tableModel;

	public SubstanceTableTest() {
		tableModel = new LocalTableModel();
		tableModel.addRow(new String[] { "Test", "Test", "Test" });
		tableModel.addRow(new String[] { "Test", "Test", "Test" });
		tableModel.addRow(new String[] { "Test", "Test", "Test" });
		tableModel.addRow(new String[] { "Test", "Test", "Test" });
		tableModel.addRow(new String[] { "Test", "Test", "Test" });
		tableModel.addRow(new String[] { "Test", "Test", "Test" });
		tableModel.addRow(new String[] { "Test", "Test", "Test" });

		table = new JTable(tableModel);

	}

	public JTable getTable() {
		return table;
	}

	public void startTest() {
		for (int i = 0; i < 50; i++) {
			tableModel.addRow(new String[] { "Test", "Test", "Test" });
		}
		table.setFont(new Font("Arial", Font.BOLD, 15));
		for (int i = 0; i < 50; i++) {
			tableModel.addRow(new String[] { "Test", "Test", "Test" });
		}
	}

	private class LocalTableModel extends AbstractTableModel {

		private String[] columns = { "Column 1", "Column 2", "Column3" };
		private List<String[]> rows = new ArrayList<String[]>();

		public int getColumnCount() {
			return columns.length;
		}

		public int getRowCount() {
			return rows.size();
		}

		public Object getValueAt(int rowIndex, int columnIndex) {
			String[] values = rows.get(rowIndex);
			return values[columnIndex];
		}

		@Override
		public void setValueAt(Object value, int rowIndex, int columnIndex) {
			String[] values = rows.get(rowIndex);
			values[columnIndex] = (String) value;
			fireTableDataChanged();
		}

		public void addRow(String[] row) {
			rows.add(row);
			fireTableDataChanged();
		}

	}

	public static void main(String[] args) {
		try {
			UIManager
					.setLookAndFeel("org.jvnet.substance.SubstanceLookAndFeel");
		} catch (Exception e) {
			e.printStackTrace();
		}
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame frame = new JFrame();
				frame.setSize(new Dimension(500, 500));
				SubstanceTableTest test = new SubstanceTableTest();
				frame.getContentPane().add(test.getTable());
				frame.setVisible(true);
				test.startTest();
			}
		});
	}
}
