package test.contrib;

import java.awt.*;

import javax.swing.*;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

import org.jvnet.substance.SubstanceLookAndFeel;

public class SubstanceTreeTest extends JFrame {
	public SubstanceTreeTest() {

		setLayout(new CardLayout(4, 4));

		DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root");
		DefaultMutableTreeNode node = new DefaultMutableTreeNode("Node 1");
		DefaultMutableTreeNode node2 = new DefaultMutableTreeNode("Node 2");
		root.add(node);
		node.add(node2);
		JTree tree = new JTree(root);
		tree.setCellRenderer(new MyRenderer());

		add(tree, "Card0");

		pack();

		setPreferredSize(new Dimension(400, 300));
		setMinimumSize(new Dimension(400, 300));
	}

	public static void main(String[] args) {
		try {
			UIManager.setLookAndFeel(new SubstanceLookAndFeel());
		} catch (UnsupportedLookAndFeelException ulafe) {
		}
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				new SubstanceTreeTest().setVisible(true);
			}
		});
	}

	class MyRenderer extends DefaultTreeCellRenderer {
		public Component getTreeCellRendererComponent(JTree tree, Object value,
				boolean sel, boolean expanded, boolean leaf, int row,
				boolean hasFocus) {
			return super.getTreeCellRendererComponent(tree,
					value, sel, expanded, leaf, row, hasFocus);
		}
	}
}