package test.contrib.bug291;

import java.util.ArrayList;
import java.util.List;

import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TestTableModel implements TableModel {

	private List<AudioFile> songs;
	private List<TableModelListener> listeners;

	public TestTableModel() {
		songs = new ArrayList<AudioFile>();
		listeners = new ArrayList<TableModelListener>();
	}

	public void addTableModelListener(TableModelListener l) {
		listeners.add(l);
	}

	public int getColumnCount() {
		return 2;
	}

	public String getColumnName(int colIndex) {
		return "Column " + colIndex;
	}

	public int getRowCount() {
		return songs.size();
	}

	public Object getValueAt(int rowIndex, int colIndex) {
		AudioFile file = songs.get(rowIndex);

		return colIndex == 0 ? file.getName() : file.getArtist();
	}

	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}

	public void removeTableModelListener(TableModelListener l) {
		listeners.remove(l);
	}

	public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
	}

	public Class<?> getColumnClass(int columnIndex) {
		return String.class;
	}

	public void addSong(AudioFile song) {
		songs.add(song);

		TableModelEvent event;
		event = new TableModelEvent(this, this.getRowCount() - 1, this
				.getRowCount() - 1, TableModelEvent.ALL_COLUMNS,
				TableModelEvent.INSERT);

		for (int i = 0; i < listeners.size(); i++)
			listeners.get(i).tableChanged(event);
	}

	public void removeSongs(int[] rows) {
		for (int i = rows.length - 1; i >= 0; i--) {
			songs.remove(rows[i]);
		}

		TableModelEvent event;
		event = new TableModelEvent(this, TableModelEvent.ALL_COLUMNS,
				TableModelEvent.DELETE);

		for (int i = 0; i < listeners.size(); i++)
			listeners.get(i).tableChanged(event);
	}

}
