package test.contrib.classloader;

import java.io.File;
import java.net.URL;
import java.util.*;

import sun.misc.URLClassPath;

/**
 * Classpath resources. <BR>
 * This Class to access the resources whitch is into the class path and cache
 * the defined VM classes.
 * 
 * @author Mina R Waheeb
 * @since Dec 27, 2004
 * @see org.kemetex.kernel.UniversalClassLoader#addPath(Classpath)
 */
public class Classpath extends URLClassPath {

	/**
	 * Natives map
	 */
	private final HashMap<String, String> natives = new HashMap<String, String>(
			0);

	/**
	 * Cached classes
	 */
	protected final Vector<Class> cache = new Vector<Class>();

	/**
	 * Children classpaths
	 */
	protected final ArrayList<Classpath> children = new ArrayList<Classpath>();

	/**
	 * Creates a classpath for this URL's
	 * 
	 * @param arg0
	 *            the classpath urls
	 */
	public Classpath(URL[] arg0, File[] libs) {
		super(arg0);
		if (libs != null && libs.length != 0) {
			for (File lib : libs) {
				if (lib.isFile()) {
					natives.put(lib.getName(), lib.getAbsolutePath());
				}
			}
		}
	}

	/**
	 * Returns the absolute path name of a native library
	 * 
	 * @param libname
	 *            The library name
	 * @return The absolute path of the native library or null if there is no
	 *         any
	 */
	protected String findLibrary(String libname) {
		Set<String> names = natives.keySet();
		boolean dot = libname.indexOf('.') != -1;
		for (String name : names) {
			int index = name.indexOf('.');
			String lookup = index != -1 && !dot ? name.substring(0, index)
					: name;
			if (libname.equalsIgnoreCase(lookup)) {
				return natives.get(name);
			}
		}
		String path = null;
		for (Classpath cp : children) {
			if ((path = cp.findLibrary(libname)) != null) {
				break;
			}
		}
		return path;
	}

	/**
	 * Adds a defined VM class to the cache list
	 * 
	 * @param clazz
	 *            the class to be cached
	 * @see ClassLoader#defineClass(byte[], int, int)
	 */
	protected void linkClass(Class clazz) {
		cache.add(clazz);
	}

	/**
	 * Gets a cached class
	 * 
	 * @param name
	 *            the class name
	 * @return the class if the class has been cached using
	 *         <code>{@link #linkClass(Class) add }</code> or NULL overwise
	 * @see #linkClass(Class)
	 */
	protected Class findClass(String name) {
		for (Class klass : cache) {
			if (klass.getName().equals(name)) {
				return klass;
			}
		}
		Class klass = null;
		// StackOverflowError ?!!
		// Caused by dobule relation module But not in level 2 namespace.
		// NOTFIXED: findClass case StackOverflowError When the class NOT found
		// We may use limited depth lookup but i think this will not be fixed
		// until the next release
		for (Classpath path : children) {
			if ((klass = path.findClass(name)) != null) {
				break;
			}
		}
		return klass;
	}

	public URL find(String arg0, boolean arg1) {
		return super.findResource(arg0, arg1);
	}

	@Override
	public URL findResource(String arg0, boolean arg1) {
		URL url = null;
		if ((url = super.findResource(arg0, arg1)) != null) {
			return checkURL(url);
		}
		for (Classpath path : children) {
			if ((url = path.findResource(arg0, arg1)) != null) {
				break;
			}
		}
		return url;
	}

	// This method case double lookup :(
	protected Classpath findClasspath(String arg0, boolean arg1) {
		if (super.findResource(arg0, arg1) != null) {
			return this;
		}
		Classpath cp = null;
		for (Classpath path : children) {
			if ((cp = path.findClasspath(arg0, arg1)) != null) {
				break;
			}
		}
		return cp;
	}

	protected boolean contains(Classpath path) {
		if (this == path) {
			return true;
		}
		for (Classpath cp : children) {
			if (cp.contains(path)) {
				return true;
			}
		}
		return false;
	}

	protected boolean addChildren(Classpath path) {
		return (path == null || path.contains(this)) ? false : children
				.add(path);
	}

}
