/*
 * Copyright (c) 2005-2008 Substance Kirill Grouchnikov. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 * 
 *  o Redistributions of source code must retain the above copyright notice, 
 *    this list of conditions and the following disclaimer. 
 *     
 *  o Redistributions in binary form must reproduce the above copyright notice, 
 *    this list of conditions and the following disclaimer in the documentation 
 *    and/or other materials provided with the distribution. 
 *     
 *  o Neither the name of Substance Kirill Grouchnikov nor the names of 
 *    its contributors may be used to endorse or promote products derived 
 *    from this software without specific prior written permission. 
 *     
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
package test.samples.substance.clientprop;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.*;

import org.jvnet.substance.SubstanceDefaultComboBoxRenderer;
import org.jvnet.substance.SubstanceLookAndFeel;
import org.jvnet.substance.skin.SubstanceBusinessBlackSteelLookAndFeel;
import org.jvnet.substance.theme.ThemeInfo;

/**
 * Test application that shows the use of the
 * {@link SubstanceLookAndFeel#ENABLE_NEGATED_THEMES} client property.
 * 
 * @author Kirill Grouchnikov
 * @see SubstanceLookAndFeel#ENABLE_NEGATED_THEMES
 */
public class EnableNegatedThemes extends JFrame {
	/**
	 * Creates the main frame for <code>this</code> sample.
	 */
	public EnableNegatedThemes() {
		super("Enable negated themes");

		setLayout(new BorderLayout());

		final JPanel panel = new JPanel(new FlowLayout());
		final JComboBox cb = new JComboBox(new Vector<ThemeInfo>(
				SubstanceLookAndFeel.getAllThemes().values()));
		cb.setRenderer(new SubstanceDefaultComboBoxRenderer(cb) {
			@Override
			public Component getListCellRendererComponent(JList list,
					Object value, int index, boolean isSelected,
					boolean cellHasFocus) {
				ThemeInfo ti = (ThemeInfo) value;
				return super.getListCellRendererComponent(list, ti
						.getDisplayName(), index, isSelected, cellHasFocus);
			}
		});
		panel.add(new JLabel("All themes:"));
		panel.add(cb);

		this.add(panel, BorderLayout.CENTER);

		JPanel controls = new JPanel(new FlowLayout(FlowLayout.RIGHT));
		final JCheckBox enableNegatedThemes = new JCheckBox(
				"enable negated themes");
		enableNegatedThemes.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				SwingUtilities.invokeLater(new Runnable() {
					public void run() {
						// based on the checkbox selection status, enable
						// negated themes
						UIManager.put(
								SubstanceLookAndFeel.ENABLE_NEGATED_THEMES,
								enableNegatedThemes.isSelected() ? Boolean.TRUE
										: null);
						// reset the combobox model to all available Substance
						// themes
						cb.setModel(new DefaultComboBoxModel(
								new Vector<ThemeInfo>(SubstanceLookAndFeel
										.getAllThemes().values())));
					}
				});
			}
		});
		controls.add(enableNegatedThemes);
		this.add(controls, BorderLayout.SOUTH);

		this.setSize(400, 200);
		setLocationRelativeTo(null);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	/**
	 * The main method for <code>this</code> sample. The arguments are
	 * ignored.
	 * 
	 * @param args
	 *            Ignored.
	 * @throws Exception
	 *             If some exception occured. Note that there is no special
	 *             treatment of exception conditions in <code>this</code>
	 *             sample code.
	 */
	public static void main(String[] args) throws Exception {
		UIManager.setLookAndFeel(new SubstanceBusinessBlackSteelLookAndFeel());
		JFrame.setDefaultLookAndFeelDecorated(true);
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				new EnableNegatedThemes().setVisible(true);
			}
		});
	}
}
