/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.HELPINFO;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MEASUREITEMSTRUCT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TRACKMOUSEEVENT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    public int handle;
    Composite parent;
    Cursor cursor;
    Menu menu;
    String toolTipText;
    Object layoutData;
    Accessible accessible;
    int drawCount;
    int foreground;
    int background;

    Control() {
    }

    public Control(Composite composite, int n) {
        super(composite, n);
        this.parent = composite;
        this.createWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(focusListener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseListener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseTrackListener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(mouseMoveListener);
        this.addListener(5, typedListener);
    }

    public void addPaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(paintListener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(traverseListener);
        this.addListener(31, typedListener);
    }

    abstract int callWindowProc(int var1, int var2, int var3);

    void checkMirrored() {
        int n;
        if ((this.style & 0x4000000) != 0 && ((n = OS.GetWindowLong(this.handle, -20)) & 0x400000) != 0) {
            this.style |= 0x8000000;
        }
    }

    public Point computeSize(int n, int n2) {
        return this.computeSize(n, n2, true);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 64;
        int n4 = 64;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 += n5 * 2, n4 += n5 * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            int n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) break;
                ++n;
            }
            if (n == controlArray.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createHandle() {
        int n;
        int n2 = this.widgetParent();
        this.handle = OS.CreateWindowEx(this.widgetExtStyle(), this.windowClass(), null, this.widgetStyle(), Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, n2, 0, OS.GetModuleHandle(null), this.widgetCreateStruct());
        if (this.handle == 0) {
            this.error(2);
        }
        if (((n = OS.GetWindowLong(this.handle, -16)) & 0x40000000) != 0) {
            OS.SetWindowLong(this.handle, -12, this.handle);
        }
        if (OS.IsDBLocale && n2 != 0) {
            int n3 = OS.ImmGetContext(n2);
            OS.ImmAssociateContext(this.handle, n3);
            OS.ImmReleaseContext(n2, n3);
        }
    }

    void createWidget() {
        this.background = -1;
        this.foreground = -1;
        this.checkOrientation(this.parent);
        this.createHandle();
        this.register();
        this.subclass();
        this.setDefaultFont();
        this.checkMirrored();
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return OS.GetSysColor(OS.COLOR_BTNFACE);
    }

    int defaultFont() {
        return this.display.systemFont();
    }

    int defaultForeground() {
        return OS.GetSysColor(OS.COLOR_WINDOWTEXT);
    }

    void deregister() {
        this.display.removeControl(this.handle);
    }

    void destroyWidget() {
        int n = this.handle;
        this.releaseHandle();
        if (n != 0) {
            OS.DestroyWindow(n);
        }
    }

    void drawBackground(int n) {
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        this.drawBackground(n, rECT);
    }

    void drawBackground(int n, RECT rECT) {
        int n2 = this.display.hPalette;
        if (n2 != 0) {
            OS.SelectPalette(n, n2, false);
            OS.RealizePalette(n);
        }
        int n3 = this.getBackgroundPixel();
        int n4 = this.findBrush(n3);
        OS.FillRect(n, rECT, n4);
    }

    void enableWidget(boolean bl) {
        OS.EnableWindow(this.handle, bl);
    }

    int findBrush(int n) {
        return this.parent.findBrush(n);
    }

    Cursor findCursor() {
        if (this.cursor != null) {
            return this.cursor;
        }
        return this.parent.findCursor();
    }

    Menu[] findMenus(Control control) {
        if (this.menu != null && this != control) {
            return new Menu[]{this.menu};
        }
        return new Menu[0];
    }

    char findMnemonic(String string) {
        int n = 0;
        int n2 = string.length();
        while (true) {
            if (n < n2 && string.charAt(n) != '&') {
                ++n;
                continue;
            }
            if (++n >= n2) {
                return '\u0000';
            }
            if (string.charAt(n) != '&') {
                return string.charAt(n);
            }
            if (++n >= n2) break;
        }
        return '\u0000';
    }

    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        shell2.fixShell(shell, this);
        decorations2.fixDecorations(decorations, this, menuArray);
    }

    void fixFocus(Control control) {
        Shell shell = this.getShell();
        Control control2 = this;
        while ((control2 = control2.parent) != null) {
            if (control2.setFocus()) {
                return;
            }
            if (control2 == shell) break;
        }
        shell.setSavedFocus(control);
        OS.SetFocus(0);
    }

    public boolean forceFocus() {
        this.checkWidget();
        Decorations decorations = this.menuShell();
        decorations.setSavedFocus(this);
        if (!(this.isEnabled() && this.isVisible() && this.isActive())) {
            return false;
        }
        if (this.isFocusControl()) {
            return true;
        }
        decorations.setSavedFocus(null);
        OS.SetFocus(this.handle);
        if (this.isDisposed()) {
            return false;
        }
        decorations.setSavedFocus(this);
        return this.isFocusControl();
    }

    void forceResize() {
        if (this.parent == null) {
            return;
        }
        WINDOWPOS[] wINDOWPOSArray = this.parent.lpwp;
        if (wINDOWPOSArray == null) {
            return;
        }
        int n = 0;
        while (n < wINDOWPOSArray.length) {
            WINDOWPOS wINDOWPOS = wINDOWPOSArray[n];
            if (wINDOWPOS != null && wINDOWPOS.hwnd == this.handle) {
                this.SetWindowPos(wINDOWPOS.hwnd, 0, wINDOWPOS.x, wINDOWPOS.y, wINDOWPOS.cx, wINDOWPOS.cy, wINDOWPOS.flags);
                wINDOWPOSArray[n] = null;
                return;
            }
            ++n;
        }
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getBackgroundPixel());
    }

    int getBackgroundPixel() {
        if (this.background == -1) {
            return this.defaultBackground();
        }
        return this.background;
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n = OS.GetWindowLong(this.handle, -20);
        if ((n & 0x200) != 0) {
            return OS.GetSystemMetrics(45);
        }
        if ((n & 0x20000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        int n2 = OS.GetWindowLong(this.handle, -16);
        if ((n2 & 0x800000) != 0) {
            return OS.GetSystemMetrics(5);
        }
        return 0;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = this.parent == null ? 0 : this.parent.handle;
        OS.MapWindowPoints(0, n, rECT, 2);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    int getCodePage() {
        if (OS.IsUnicode) {
            return 0;
        }
        int n = OS.SendMessage(this.handle, 49, 0, 0);
        LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
        OS.GetObject(n, LOGFONT.sizeof, lOGFONT);
        int n2 = lOGFONT.lfCharSet & 0xFF;
        int[] nArray = new int[8];
        if (OS.TranslateCharsetInfo(n2, nArray, 1)) {
            return nArray[1];
        }
        return OS.GetACP();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return OS.IsWindowEnabled(this.handle);
    }

    public Font getFont() {
        this.checkWidget();
        int n = OS.SendMessage(this.handle, 49, 0, 0);
        if (n == 0) {
            n = this.defaultFont();
        }
        return Font.win32_new(this.display, n);
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.win32_new(this.display, this.getForegroundPixel());
    }

    int getForegroundPixel() {
        if (this.foreground == -1) {
            return this.defaultForeground();
        }
        return this.foreground;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = this.parent == null ? 0 : this.parent.handle;
        OS.MapWindowPoints(0, n, rECT, 2);
        return new Point(rECT.left, rECT.top);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        if (OS.IsWinCE || (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return this.display.getPrimaryMonitor();
        }
        int n = OS.MonitorFromWindow(this.handle, 2);
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = 40;
        OS.GetMonitorInfo(n, mONITORINFO);
        Monitor monitor = new Monitor();
        monitor.handle = n;
        monitor.x = mONITORINFO.rcMonitor_left;
        monitor.y = mONITORINFO.rcMonitor_top;
        monitor.width = mONITORINFO.rcMonitor_right - mONITORINFO.rcMonitor_left;
        monitor.height = mONITORINFO.rcMonitor_bottom - mONITORINFO.rcMonitor_top;
        monitor.clientX = mONITORINFO.rcWork_left;
        monitor.clientY = mONITORINFO.rcWork_top;
        monitor.clientWidth = mONITORINFO.rcWork_right - mONITORINFO.rcWork_left;
        monitor.clientHeight = mONITORINFO.rcWork_bottom - mONITORINFO.rcWork_top;
        return monitor;
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int n = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++n;
            control = control.parent;
        }
        control = this;
        Control[] controlArray = new Control[n];
        while (control != shell) {
            controlArray[--n] = control;
            control = control.parent;
        }
        return controlArray;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        int n = rECT.right - rECT.left;
        int n2 = rECT.bottom - rECT.top;
        return new Point(n, n2);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (this.drawCount != 0) {
            return (this.state & 0x10) == 0;
        }
        int n = OS.GetWindowLong(this.handle, -16);
        return (n & 0x10000000) != 0;
    }

    boolean hasCursor() {
        RECT rECT = new RECT();
        if (!OS.GetClientRect(this.handle, rECT)) {
            return false;
        }
        if (OS.MapWindowPoints(this.handle, 0, rECT, 2) == 0) {
            return false;
        }
        POINT pOINT = new POINT();
        return OS.GetCursorPos(pOINT) && OS.PtInRect(rECT, pOINT);
    }

    boolean hasFocus() {
        int n = OS.GetFocus();
        while (n != 0) {
            if (n == this.handle) {
                return true;
            }
            if (this.display.getControl(n) != null) {
                return false;
            }
            n = OS.GetParent(n);
        }
        return false;
    }

    public int internal_new_GC(GCData gCData) {
        this.checkWidget();
        int n = gCData == null || gCData.ps == null ? OS.GetDC(this.handle) : OS.BeginPaint(this.handle, gCData.ps);
        if (n == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            if (!OS.IsWinCE && (OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) >= 262154) {
                int n2 = 0x6000000;
                if ((gCData.style & n2) != 0) {
                    gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
                } else {
                    int n3 = OS.GetLayout(n);
                    gCData.style = (n3 & 1) != 0 ? (gCData.style |= 0xC000000) : (gCData.style |= 0x2000000);
                }
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.display;
            gCData.foreground = this.getForegroundPixel();
            gCData.background = this.getBackgroundPixel();
            gCData.hFont = OS.SendMessage(this.handle, 49, 0, 0);
            gCData.hwnd = this.handle;
        }
        return n;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        this.checkWidget();
        if (gCData == null || gCData.ps == null) {
            OS.ReleaseDC(this.handle, n);
        } else {
            OS.EndPaint(this.handle, gCData.ps);
        }
    }

    boolean isActive() {
        Shell shell = this.display.getModalDialogShell();
        if (shell != null && shell != this.getShell()) {
            return false;
        }
        Shell shell2 = null;
        Shell[] shellArray = this.display.modalShells;
        if (shellArray != null) {
            int n = 196608;
            int n2 = shellArray.length;
            while (--n2 >= 0) {
                Shell shell3 = shellArray[n2];
                if (shell3 == null) continue;
                if ((shell3.style & n) != 0) {
                    Control control = this;
                    while (control != null) {
                        if (control == shell3) break;
                        control = control.parent;
                    }
                    if (control == shell3) break;
                    return false;
                }
                if ((shell3.style & 0x8000) == 0) continue;
                if (shell2 == null) {
                    shell2 = this.getShell();
                }
                if (shell3.parent != shell2) continue;
                return false;
            }
        }
        if (shell2 == null) {
            shell2 = this.getShell();
        }
        return shell2.getEnabled();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isReparentable() {
        this.checkWidget();
        return true;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point point = control.getSize();
            if (point.x == 0 || point.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return true;
                }
                ++n;
            }
        }
        return ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0;
    }

    boolean isTabItem() {
        int n;
        Control[] controlArray = this.parent._getTabList();
        if (controlArray != null) {
            n = 0;
            while (n < controlArray.length) {
                if (controlArray[n] == this) {
                    return false;
                }
                ++n;
            }
        }
        if (((n = OS.GetWindowLong(this.handle, -16)) & 0x10000) != 0) {
            return false;
        }
        int n2 = OS.SendMessage(this.handle, 135, 0, 0);
        if ((n2 & 0x100) != 0) {
            return false;
        }
        if ((n2 & 4) != 0) {
            return false;
        }
        if ((n2 & 1) != 0) {
            return false;
        }
        return (n2 & 2) == 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        if (OS.IsWindowVisible(this.handle)) {
            return true;
        }
        return this.getVisible() && this.parent.isVisible();
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char c) {
        return false;
    }

    boolean mnemonicMatch(char c) {
        return false;
    }

    public void moveAbove(Control control) {
        int n;
        this.checkWidget();
        int n2 = 0;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            n = control.handle;
            if (n == 0 || n == this.handle) {
                return;
            }
            n2 = OS.GetWindow(n, 3);
            if (n2 == 0 || n2 == n) {
                n2 = 0;
            }
        }
        n = 19;
        this.SetWindowPos(this.handle, n2, 0, 0, 0, 0, n);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        int n = 1;
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
            n = control.handle;
        }
        if (n == 0 || n == this.handle) {
            return;
        }
        int n2 = 19;
        this.SetWindowPos(this.handle, n, 0, 0, 0, 0, n2);
    }

    Accessible new_Accessible(Control control) {
        return Accessible.internal_new_Accessible(this);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean bl) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, bl));
    }

    public void redraw() {
        this.checkWidget();
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, null, true);
        } else {
            int n = 1029;
            OS.RedrawWindow(this.handle, null, 0, n);
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        if (OS.IsWinCE) {
            OS.InvalidateRect(this.handle, rECT, true);
        } else {
            int n5 = 1029;
            if (bl) {
                n5 |= 0x80;
            }
            OS.RedrawWindow(this.handle, rECT, 0, n5);
        }
    }

    void register() {
        this.display.addControl(this.handle, this);
    }

    void releaseChild() {
        this.parent.removeControl(this);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (OS.IsDBLocale) {
            OS.ImmAssociateContext(this.handle, 0);
        }
        if (this.toolTipText != null) {
            Shell shell = this.getShell();
            shell.setToolTipText(this.handle, null);
        }
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.deregister();
        this.unsubclass();
        this.parent = null;
        this.layoutData = null;
        if (this.accessible != null) {
            this.accessible.internal_dispose_Accessible();
        }
        this.accessible = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.checkWidget();
        if (focusListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, focusListener);
        this.eventTable.unhook(16, focusListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    public void removeMouseTrackListener(MouseTrackListener mouseTrackListener) {
        this.checkWidget();
        if (mouseTrackListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, mouseTrackListener);
        this.eventTable.unhook(7, mouseTrackListener);
        this.eventTable.unhook(32, mouseTrackListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.checkWidget();
        if (mouseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, mouseListener);
        this.eventTable.unhook(4, mouseListener);
        this.eventTable.unhook(8, mouseListener);
    }

    public void removeMouseMoveListener(MouseMoveListener mouseMoveListener) {
        this.checkWidget();
        if (mouseMoveListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, mouseMoveListener);
    }

    public void removePaintListener(PaintListener paintListener) {
        this.checkWidget();
        if (paintListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, paintListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.checkWidget();
        if (traverseListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, traverseListener);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        if (!this.setKeyState(event, n, n3, n4)) {
            return true;
        }
        return this.sendKeyEvent(n, n2, n3, n4, event);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendFocusEvent(int n, int n2) {
        Shell shell = this.getShell();
        this.sendEvent(n);
        switch (n) {
            case 15: {
                if (shell.isDisposed()) break;
                shell.setActiveControl(this);
                break;
            }
            case 16: {
                Control control;
                if (shell.isDisposed()) break;
                Display display = shell.display;
                Control control2 = control = n2 != -1 ? display.findControl(n2) : display.getFocusControl();
                if (control != null && shell == control.getShell()) break;
                shell.setActiveControl(null);
            }
        }
        return true;
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, int n5) {
        Event event = new Event();
        event.button = n2;
        event.x = (short)(n5 & 0xFFFF);
        event.y = (short)(n5 >> 16);
        this.setInputState(event, n);
        return this.sendMouseEvent(n, n3, n4, n5, event);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, Event event) {
        this.postEvent(n, event);
        return true;
    }

    public void setBackground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            n = color.handle;
        }
        this.setBackgroundPixel(n);
    }

    void setBackgroundPixel(int n) {
        if (this.background == n) {
            return;
        }
        this.background = n;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = 52;
        this.setBounds(n, n2, Math.max(0, n3), Math.max(0, n4), n5);
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        WINDOWPOS[] wINDOWPOSArray;
        if (this.parent == null) {
            this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
            return;
        }
        this.forceResize();
        WINDOWPOS[] wINDOWPOSArray2 = this.parent.lpwp;
        if (wINDOWPOSArray2 == null) {
            this.SetWindowPos(this.handle, 0, n, n2, n3, n4, n5);
            return;
        }
        int n6 = 0;
        while (n6 < wINDOWPOSArray2.length) {
            if (wINDOWPOSArray2[n6] == null) break;
            ++n6;
        }
        if (n6 == wINDOWPOSArray2.length) {
            wINDOWPOSArray = new WINDOWPOS[wINDOWPOSArray2.length + 4];
            System.arraycopy(wINDOWPOSArray2, 0, wINDOWPOSArray, 0, wINDOWPOSArray2.length);
            wINDOWPOSArray2 = wINDOWPOSArray;
            this.parent.lpwp = wINDOWPOSArray;
        }
        wINDOWPOSArray = new WINDOWPOS();
        wINDOWPOSArray.hwnd = this.handle;
        wINDOWPOSArray.x = n;
        wINDOWPOSArray.y = n2;
        wINDOWPOSArray.cx = n3;
        wINDOWPOSArray.cy = n4;
        wINDOWPOSArray.flags = n5;
        wINDOWPOSArray2[n6] = wINDOWPOSArray;
    }

    public void setBounds(Rectangle rectangle) {
        this.checkWidget();
        if (rectangle == null) {
            this.error(4);
        }
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void setCapture(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.SetCapture(this.handle);
        } else if (OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
    }

    void setCursor() {
        int n = 0x2000001;
        OS.SendMessage(this.handle, 32, this.handle, n);
    }

    public void setCursor(Cursor cursor) {
        Object object;
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            SWT.error(5);
        }
        this.cursor = cursor;
        if (OS.IsWinCE) {
            int n = cursor != null ? cursor.handle : 0;
            OS.SetCursor(n);
            return;
        }
        int n = OS.GetCapture();
        if (n == 0) {
            object = new POINT();
            if (!OS.GetCursorPos((POINT)object)) {
                return;
            }
            int n2 = n = OS.WindowFromPoint((POINT)object);
            while (n2 != 0 && n2 != this.handle) {
                n2 = OS.GetParent(n2);
            }
            if (n2 == 0) {
                return;
            }
        }
        if ((object = this.display.getControl(n)) == null) {
            object = this;
        }
        ((Control)object).setCursor();
    }

    void setDefaultFont() {
        int n = this.display.systemFont();
        OS.SendMessage(this.handle, 48, n, 0);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        Control control = null;
        boolean bl2 = false;
        if (!bl) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        this.enableWidget(bl);
        if (bl2) {
            this.fixFocus(control);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        int n = 0;
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            n = font.handle;
        }
        if (n == 0) {
            n = this.defaultFont();
        }
        OS.SendMessage(this.handle, 48, n, 1);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        int n = -1;
        if (color != null) {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            n = color.handle;
        }
        this.setForegroundPixel(n);
    }

    void setForegroundPixel(int n) {
        if (this.foreground == n) {
            return;
        }
        this.foreground = n;
        OS.InvalidateRect(this.handle, null, true);
    }

    public void setLayoutData(Object object) {
        this.checkWidget();
        this.layoutData = object;
    }

    public void setLocation(int n, int n2) {
        this.checkWidget();
        int n3 = 21;
        if (!OS.IsWinCE) {
            n3 |= 0x20;
        }
        this.setBounds(n, n2, 0, 0, n3);
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    boolean setRadioFocus() {
        return false;
    }

    boolean setRadioSelection(boolean bl) {
        return false;
    }

    public void setRedraw(boolean bl) {
        int n;
        this.checkWidget();
        if (this.drawCount == 0 && ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000000) == 0) {
            this.state |= 0x10;
        }
        if (bl) {
            if (--this.drawCount == 0) {
                OS.SendMessage(this.handle, 11, 1, 0);
                if ((this.state & 0x10) != 0) {
                    this.state &= 0xFFFFFFEF;
                    OS.ShowWindow(this.handle, 0);
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(this.handle, null, true);
                } else {
                    n = 1157;
                    OS.RedrawWindow(this.handle, null, 0, n);
                }
            }
        } else if (this.drawCount++ == 0) {
            OS.SendMessage(this.handle, 11, 0, 0);
        }
    }

    boolean setSavedFocus() {
        return this.forceFocus();
    }

    public void setSize(int n, int n2) {
        this.checkWidget();
        int n3 = 54;
        this.setBounds(0, 0, Math.max(0, n), Math.max(0, n2), n3);
    }

    public void setSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setSize(point.x, point.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.getShell();
        this.toolTipText = string;
        shell.setToolTipText(this.handle, this.toolTipText);
    }

    public void setVisible(boolean bl) {
        int n;
        this.checkWidget();
        if (this.drawCount != 0 ? (this.state & 0x10) == 0 == bl : ((n = OS.GetWindowLong(this.handle, -16)) & 0x10000000) != 0 == bl) {
            return;
        }
        if (bl) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
        }
        Control control = null;
        boolean bl2 = false;
        if (!bl) {
            control = this.display.getFocusControl();
            bl2 = this.isFocusAncestor(control);
        }
        if (this.drawCount != 0) {
            this.state = bl ? this.state & 0xFFFFFFEF : this.state | 0x10;
        } else {
            OS.ShowWindow(this.handle, bl ? 5 : 0);
            if (this.isDisposed()) {
                return;
            }
        }
        if (!bl) {
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (bl2) {
            this.fixFocus(control);
        }
    }

    boolean showMenu(int n, int n2) {
        Event event = new Event();
        event.x = n;
        event.y = n2;
        this.sendEvent(35, event);
        if (!event.doit) {
            return true;
        }
        if (this.menu != null && !this.menu.isDisposed()) {
            if (n != event.x || n2 != event.y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
            return true;
        }
        return false;
    }

    void sort(int[] nArray) {
        int n = nArray.length;
        int n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (nArray[n4] <= nArray[n4 + n2]) {
                        int n5 = nArray[n4];
                        nArray[n4] = nArray[n4 + n2];
                        nArray[n4 + n2] = n5;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    void subclass() {
        int n;
        int n2 = this.windowProc();
        if (n2 == (n = this.display.windowProc)) {
            return;
        }
        OS.SetWindowLong(this.handle, -4, n);
    }

    public Point toControl(int n, int n2) {
        this.checkWidget();
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.ScreenToClient(this.handle, pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int n, int n2) {
        this.checkWidget();
        POINT pOINT = new POINT();
        pOINT.x = n;
        pOINT.y = n2;
        OS.ClientToScreen(this.handle, pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateAccelerator(MSG mSG) {
        return this.menuShell().translateAccelerator(mSG);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(MSG mSG) {
        Decorations decorations;
        if (mSG.wParam < 32) {
            return false;
        }
        int n = mSG.hwnd;
        if (OS.GetKeyState(18) >= 0) {
            int n2 = OS.SendMessage(n, 135, 0, 0);
            if ((n2 & 4) != 0) {
                return false;
            }
            if ((n2 & 0x2000) == 0) {
                return false;
            }
        }
        if ((decorations = this.menuShell()).isVisible() && decorations.isEnabled()) {
            this.display.lastAscii = mSG.wParam;
            this.display.lastDead = false;
            this.display.lastNull = false;
            Event event = new Event();
            event.detail = 128;
            if (this.setKeyState(event, 31, mSG.wParam, mSG.lParam)) {
                return this.translateMnemonic(event, null) || decorations.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG) {
        int n = mSG.wParam;
        if (n == 18) {
            Shell shell = this.getShell();
            int n2 = shell.handle;
            OS.SendMessage(n2, 295, 3, 0);
            return false;
        }
        int n3 = mSG.hwnd;
        int n4 = 0;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = n;
        int n6 = 0;
        switch (n) {
            case 27: {
                bl2 = true;
                n6 = 27;
                int n7 = OS.SendMessage(n3, 135, 0, 0);
                if ((n7 & 4) != 0 && (n7 & 8) == 0) {
                    bl = false;
                }
                n4 = 2;
                break;
            }
            case 13: {
                bl2 = true;
                n6 = 13;
                int n7 = OS.SendMessage(n3, 135, 0, 0);
                if ((n7 & 4) != 0) {
                    bl = false;
                }
                n4 = 4;
                break;
            }
            case 9: {
                n6 = 9;
                int n7 = OS.GetKeyState(16) >= 0 ? 1 : 0;
                int n8 = OS.SendMessage(n3, 135, 0, 0);
                if ((n8 & 6) != 0) {
                    if ((n8 & 8) != 0) {
                        if (n7 != 0 && OS.GetKeyState(17) >= 0) {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (this.parent != null && (this.parent.style & 0x8000000) != 0 && (n == 37 || n == 39)) {
                    n7 = n7 != 0 ? 0 : 1;
                }
                n4 = n7 != 0 ? 16 : 8;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                if (OS.IsSP && (n == 37 || n == 39)) {
                    return false;
                }
                bl3 = true;
                int n7 = OS.SendMessage(n3, 135, 0, 0);
                if ((n7 & 1) != 0) {
                    bl = false;
                }
                int n8 = n != 40 && n != 39 ? 0 : 1;
                n4 = n8 != 0 ? 64 : 32;
                break;
            }
            case 33: 
            case 34: {
                bl2 = true;
                bl3 = true;
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                int n7 = OS.SendMessage(n3, 135, 0, 0);
                if ((n7 & 4) != 0 && (n7 & 8) == 0) {
                    bl = false;
                }
                n4 = n == 33 ? 256 : 512;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = bl;
        event.detail = n4;
        this.display.lastKey = n5;
        this.display.lastAscii = n6;
        this.display.lastVirtual = bl3;
        this.display.lastDead = false;
        this.display.lastNull = false;
        if (!this.setKeyState(event, 31, mSG.wParam, mSG.lParam)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                int n9 = shell.handle;
                OS.SendMessage(n9, 295, 3, 0);
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (bl2 && control != null);
        return false;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int n) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = n;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean bl) {
        Control control = this.computeTabRoot();
        Control control2 = this.computeTabGroup();
        Control[] controlArray = control.computeTabList();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == control2) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control3 = controlArray[n2];
            if (control3.isDisposed() || !control3.setTabGroupFocus()) continue;
            return true;
        }
        if (control2.isDisposed()) {
            return false;
        }
        return control2.setTabGroupFocus();
    }

    boolean traverseItem(boolean bl) {
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (controlArray[n2] == this) break;
            ++n2;
        }
        if (n2 == n) {
            return false;
        }
        int n3 = n2;
        int n4 = bl ? 1 : -1;
        while ((n2 = (n2 + n4 + n) % n) != n3) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !control.isTabItem() || !control.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseMnemonic(char c) {
        return this.mnemonicHit(c);
    }

    boolean traversePage(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    void unsubclass() {
        int n = this.display.windowProc;
        int n2 = this.windowProc();
        if (n == n2) {
            return;
        }
        OS.SetWindowLong(this.handle, -4, n2);
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean bl) {
        if (OS.IsWinCE) {
            OS.UpdateWindow(this.handle);
        } else {
            int n = 256;
            if (bl) {
                n |= 0x80;
            }
            OS.RedrawWindow(this.handle, null, 0, n);
        }
    }

    void updateFont(Font font, Font font2) {
        Font font3 = this.getFont();
        if (font3.equals(font)) {
            this.setFont(font2);
        }
    }

    CREATESTRUCT widgetCreateStruct() {
        return null;
    }

    int widgetExtStyle() {
        int n = 0;
        if (!OS.IsPPC && (this.style & 0x800) != 0) {
            n |= 0x200;
        }
        if ((OS.WIN32_MAJOR << 16 | OS.WIN32_MINOR) < 262154) {
            return n;
        }
        n |= 0x100000;
        if ((this.style & 0x4000000) != 0) {
            n |= 0x400000;
        }
        return n;
    }

    int widgetParent() {
        return this.parent.handle;
    }

    int widgetStyle() {
        int n = 0x54000000;
        if (OS.IsPPC && (this.style & 0x800) != 0) {
            n |= 0x800000;
        }
        return n;
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (composite == null) {
            this.error(4);
        }
        if (composite.isDisposed()) {
            SWT.error(5);
        }
        if (this.parent == composite) {
            return true;
        }
        if (!this.isReparentable()) {
            return false;
        }
        this.releaseChild();
        Shell shell = composite.getShell();
        Shell shell2 = this.getShell();
        Decorations decorations = composite.menuShell();
        Decorations decorations2 = this.menuShell();
        if (shell2 != shell || decorations2 != decorations) {
            Menu[] menuArray = shell2.findMenus(this);
            this.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        }
        if (OS.SetParent(this.handle, composite.handle) == 0) {
            return false;
        }
        this.parent = composite;
        int n = 19;
        this.SetWindowPos(this.handle, 1, 0, 0, 0, 0, n);
        return true;
    }

    abstract TCHAR windowClass();

    abstract int windowProc();

    int windowProc(int n, int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        switch (n2) {
            case 6: {
                lRESULT = this.WM_ACTIVATE(n3, n4);
                break;
            }
            case 258: {
                lRESULT = this.WM_CHAR(n3, n4);
                break;
            }
            case 771: {
                lRESULT = this.WM_CLEAR(n3, n4);
                break;
            }
            case 16: {
                lRESULT = this.WM_CLOSE(n3, n4);
                break;
            }
            case 273: {
                lRESULT = this.WM_COMMAND(n3, n4);
                break;
            }
            case 123: {
                lRESULT = this.WM_CONTEXTMENU(n3, n4);
                break;
            }
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: {
                lRESULT = this.WM_CTLCOLOR(n3, n4);
                break;
            }
            case 768: {
                lRESULT = this.WM_CUT(n3, n4);
                break;
            }
            case 2: {
                lRESULT = this.WM_DESTROY(n3, n4);
                break;
            }
            case 43: {
                lRESULT = this.WM_DRAWITEM(n3, n4);
                break;
            }
            case 22: {
                lRESULT = this.WM_ENDSESSION(n3, n4);
                break;
            }
            case 289: {
                lRESULT = this.WM_ENTERIDLE(n3, n4);
                break;
            }
            case 20: {
                lRESULT = this.WM_ERASEBKGND(n3, n4);
                break;
            }
            case 135: {
                lRESULT = this.WM_GETDLGCODE(n3, n4);
                break;
            }
            case 83: {
                lRESULT = this.WM_HELP(n3, n4);
                break;
            }
            case 276: {
                lRESULT = this.WM_HSCROLL(n3, n4);
                break;
            }
            case 646: {
                lRESULT = this.WM_IME_CHAR(n3, n4);
                break;
            }
            case 271: {
                lRESULT = this.WM_IME_COMPOSITION(n3, n4);
                break;
            }
            case 279: {
                lRESULT = this.WM_INITMENUPOPUP(n3, n4);
                break;
            }
            case 49: {
                lRESULT = this.WM_GETFONT(n3, n4);
                break;
            }
            case 61: {
                lRESULT = this.WM_GETOBJECT(n3, n4);
                break;
            }
            case 786: {
                lRESULT = this.WM_HOTKEY(n3, n4);
                break;
            }
            case 256: {
                lRESULT = this.WM_KEYDOWN(n3, n4);
                break;
            }
            case 257: {
                lRESULT = this.WM_KEYUP(n3, n4);
                break;
            }
            case 8: {
                lRESULT = this.WM_KILLFOCUS(n3, n4);
                break;
            }
            case 515: {
                lRESULT = this.WM_LBUTTONDBLCLK(n3, n4);
                break;
            }
            case 513: {
                lRESULT = this.WM_LBUTTONDOWN(n3, n4);
                break;
            }
            case 514: {
                lRESULT = this.WM_LBUTTONUP(n3, n4);
                break;
            }
            case 521: {
                lRESULT = this.WM_MBUTTONDBLCLK(n3, n4);
                break;
            }
            case 519: {
                lRESULT = this.WM_MBUTTONDOWN(n3, n4);
                break;
            }
            case 520: {
                lRESULT = this.WM_MBUTTONUP(n3, n4);
                break;
            }
            case 44: {
                lRESULT = this.WM_MEASUREITEM(n3, n4);
                break;
            }
            case 288: {
                lRESULT = this.WM_MENUCHAR(n3, n4);
                break;
            }
            case 287: {
                lRESULT = this.WM_MENUSELECT(n3, n4);
                break;
            }
            case 33: {
                lRESULT = this.WM_MOUSEACTIVATE(n3, n4);
                break;
            }
            case 673: {
                lRESULT = this.WM_MOUSEHOVER(n3, n4);
                break;
            }
            case 675: {
                lRESULT = this.WM_MOUSELEAVE(n3, n4);
                break;
            }
            case 512: {
                lRESULT = this.WM_MOUSEMOVE(n3, n4);
                break;
            }
            case 522: {
                lRESULT = this.WM_MOUSEWHEEL(n3, n4);
                break;
            }
            case 3: {
                lRESULT = this.WM_MOVE(n3, n4);
                break;
            }
            case 134: {
                lRESULT = this.WM_NCACTIVATE(n3, n4);
                break;
            }
            case 131: {
                lRESULT = this.WM_NCCALCSIZE(n3, n4);
                break;
            }
            case 132: {
                lRESULT = this.WM_NCHITTEST(n3, n4);
                break;
            }
            case 161: {
                lRESULT = this.WM_NCLBUTTONDOWN(n3, n4);
                break;
            }
            case 78: {
                lRESULT = this.WM_NOTIFY(n3, n4);
                break;
            }
            case 15: {
                lRESULT = this.WM_PAINT(n3, n4);
                break;
            }
            case 785: {
                lRESULT = this.WM_PALETTECHANGED(n3, n4);
                break;
            }
            case 528: {
                lRESULT = this.WM_PARENTNOTIFY(n3, n4);
                break;
            }
            case 770: {
                lRESULT = this.WM_PASTE(n3, n4);
                break;
            }
            case 792: {
                lRESULT = this.WM_PRINTCLIENT(n3, n4);
                break;
            }
            case 17: {
                lRESULT = this.WM_QUERYENDSESSION(n3, n4);
                break;
            }
            case 783: {
                lRESULT = this.WM_QUERYNEWPALETTE(n3, n4);
                break;
            }
            case 19: {
                lRESULT = this.WM_QUERYOPEN(n3, n4);
                break;
            }
            case 518: {
                lRESULT = this.WM_RBUTTONDBLCLK(n3, n4);
                break;
            }
            case 516: {
                lRESULT = this.WM_RBUTTONDOWN(n3, n4);
                break;
            }
            case 517: {
                lRESULT = this.WM_RBUTTONUP(n3, n4);
                break;
            }
            case 32: {
                lRESULT = this.WM_SETCURSOR(n3, n4);
                break;
            }
            case 7: {
                lRESULT = this.WM_SETFOCUS(n3, n4);
                break;
            }
            case 48: {
                lRESULT = this.WM_SETFONT(n3, n4);
                break;
            }
            case 26: {
                lRESULT = this.WM_SETTINGCHANGE(n3, n4);
                break;
            }
            case 11: {
                lRESULT = this.WM_SETREDRAW(n3, n4);
                break;
            }
            case 24: {
                lRESULT = this.WM_SHOWWINDOW(n3, n4);
                break;
            }
            case 5: {
                lRESULT = this.WM_SIZE(n3, n4);
                break;
            }
            case 262: {
                lRESULT = this.WM_SYSCHAR(n3, n4);
                break;
            }
            case 21: {
                lRESULT = this.WM_SYSCOLORCHANGE(n3, n4);
                break;
            }
            case 274: {
                lRESULT = this.WM_SYSCOMMAND(n3, n4);
                break;
            }
            case 260: {
                lRESULT = this.WM_SYSKEYDOWN(n3, n4);
                break;
            }
            case 261: {
                lRESULT = this.WM_SYSKEYUP(n3, n4);
                break;
            }
            case 275: {
                lRESULT = this.WM_TIMER(n3, n4);
                break;
            }
            case 772: {
                lRESULT = this.WM_UNDO(n3, n4);
                break;
            }
            case 277: {
                lRESULT = this.WM_VSCROLL(n3, n4);
                break;
            }
            case 71: {
                lRESULT = this.WM_WINDOWPOSCHANGED(n3, n4);
                break;
            }
            case 70: {
                lRESULT = this.WM_WINDOWPOSCHANGING(n3, n4);
            }
        }
        if (lRESULT != null) {
            return lRESULT.value;
        }
        return this.callWindowProc(n2, n3, n4);
    }

    LRESULT WM_ACTIVATE(int n, int n2) {
        return null;
    }

    LRESULT WM_CHAR(int n, int n2) {
        byte by;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by = (byte)(n & 0xFF))) {
            return null;
        }
        this.display.lastAscii = n;
        boolean bl = this.display.lastNull = n == 0;
        if (!this.sendKeyEvent(1, 258, n, n2)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_CLEAR(int n, int n2) {
        return null;
    }

    LRESULT WM_CLOSE(int n, int n2) {
        return null;
    }

    LRESULT WM_COMMAND(int n, int n2) {
        if (n2 == 0) {
            int n3;
            MenuItem menuItem;
            Decorations decorations = this.menuShell();
            if (decorations.isEnabled() && (menuItem = this.display.getMenuItem(n3 = n & 0xFFFF)) != null && menuItem.isEnabled()) {
                return menuItem.wmCommandChild(n, n2);
            }
            return null;
        }
        Control control = this.display.getControl(n2);
        if (control == null) {
            return null;
        }
        return control.wmCommandChild(n, n2);
    }

    LRESULT WM_CONTEXTMENU(int n, int n2) {
        if (n != this.handle) {
            return null;
        }
        if (OS.IsWinCE) {
            return null;
        }
        short s = 0;
        short s2 = 0;
        if (n2 != -1) {
            POINT pOINT = new POINT();
            short s3 = (short)(n2 & 0xFFFF);
            pOINT.x = s3;
            s = s3;
            short s4 = (short)(n2 >> 16);
            pOINT.y = s4;
            s2 = s4;
            OS.ScreenToClient(this.handle, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(this.handle, rECT);
            if (!OS.PtInRect(rECT, pOINT)) {
                return null;
            }
        } else {
            int n3 = OS.GetMessagePos();
            s = (short)(n3 & 0xFFFF);
            s2 = (short)(n3 >> 16);
        }
        return this.showMenu(s, s2) ? LRESULT.ZERO : null;
    }

    LRESULT WM_CTLCOLOR(int n, int n2) {
        Control control;
        int n3 = this.display.hPalette;
        if (n3 != 0) {
            OS.SelectPalette(n, n3, false);
            OS.RealizePalette(n);
        }
        if ((control = this.display.getControl(n2)) == null) {
            return null;
        }
        return control.wmColorChild(n, n2);
    }

    LRESULT WM_CUT(int n, int n2) {
        return null;
    }

    LRESULT WM_DESTROY(int n, int n2) {
        return null;
    }

    LRESULT WM_DRAWITEM(int n, int n2) {
        DRAWITEMSTRUCT dRAWITEMSTRUCT = new DRAWITEMSTRUCT();
        OS.MoveMemory(dRAWITEMSTRUCT, n2, 48);
        if (dRAWITEMSTRUCT.CtlType == 1) {
            MenuItem menuItem = this.display.getMenuItem(dRAWITEMSTRUCT.itemID);
            if (menuItem == null) {
                return null;
            }
            return menuItem.wmDrawChild(n, n2);
        }
        Control control = this.display.getControl(dRAWITEMSTRUCT.hwndItem);
        if (control == null) {
            return null;
        }
        return control.wmDrawChild(n, n2);
    }

    LRESULT WM_ENDSESSION(int n, int n2) {
        return null;
    }

    LRESULT WM_ENTERIDLE(int n, int n2) {
        return null;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        return null;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        return null;
    }

    LRESULT WM_GETFONT(int n, int n2) {
        return null;
    }

    LRESULT WM_GETOBJECT(int n, int n2) {
        int n3;
        if (this.accessible != null && (n3 = this.accessible.internal_WM_GETOBJECT(n, n2)) != 0) {
            return new LRESULT(n3);
        }
        return null;
    }

    LRESULT WM_HOTKEY(int n, int n2) {
        return null;
    }

    LRESULT WM_HELP(int n, int n2) {
        if (OS.IsWinCE) {
            return null;
        }
        HELPINFO hELPINFO = new HELPINFO();
        OS.MoveMemory(hELPINFO, n2, 28);
        Decorations decorations = this.menuShell();
        if (!decorations.isEnabled()) {
            return null;
        }
        if (hELPINFO.iContextType == 2) {
            MenuItem menuItem = this.display.getMenuItem(hELPINFO.iCtrlId);
            if (menuItem != null && menuItem.isEnabled()) {
                Widget widget = null;
                if (menuItem.hooks(28)) {
                    widget = menuItem;
                } else {
                    Menu menu = menuItem.parent;
                    if (menu.hooks(28)) {
                        widget = menu;
                    }
                }
                if (widget != null) {
                    int n3 = decorations.handle;
                    OS.SendMessage(n3, 31, 0, 0);
                    widget.postEvent(28);
                    return LRESULT.ONE;
                }
            }
            return null;
        }
        if (this.hooks(28)) {
            this.postEvent(28);
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_HSCROLL(int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        Control control = this.display.getControl(n2);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(n, n2);
    }

    LRESULT WM_IME_CHAR(int n, int n2) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n, n2)) {
            return LRESULT.ONE;
        }
        this.sendKeyEvent(2, 646, n, n2);
        display.lastAscii = 0;
        display.lastKey = 0;
        return LRESULT.ONE;
    }

    LRESULT WM_IME_COMPOSITION(int n, int n2) {
        return null;
    }

    LRESULT WM_INITMENUPOPUP(int n, int n2) {
        if (this.display.accelKeyHit) {
            return null;
        }
        Shell shell = this.getShell();
        Menu menu = shell.activeMenu;
        Menu menu2 = null;
        if (n2 >> 16 == 0) {
            menu2 = this.menuShell().findMenu(n);
        }
        Menu menu3 = menu2;
        while (menu3 != null && menu3 != menu) {
            menu3 = menu3.getParentMenu();
        }
        if (menu3 == null) {
            menu3 = shell.activeMenu;
            while (menu3 != null) {
                menu3.sendEvent(23);
                if (menu3.isDisposed()) break;
                menu3 = menu3.getParentMenu();
                Menu menu4 = menu2;
                while (menu4 != null && menu4 != menu3) {
                    menu4 = menu4.getParentMenu();
                }
                if (menu4 != null) break;
            }
        }
        if (menu2 != null && menu2.isDisposed()) {
            menu2 = null;
        }
        shell.activeMenu = menu2;
        if (menu2 != null && menu2 != menu) {
            menu2.sendEvent(22);
        }
        return null;
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        int n3;
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((n2 & 0x40000000) == 0) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte((byte)(n3 = (int)((byte)(n & 0xFF))))) {
            return null;
        }
        int n4 = n3 = OS.IsWinCE ? 0 : OS.MapVirtualKey(n, 2);
        if (OS.IsWinNT ? (n3 & Integer.MIN_VALUE) != 0 : (n3 & 0x8000) != 0) {
            return null;
        }
        MSG mSG = new MSG();
        int n5 = 10420226;
        if (OS.PeekMessage(mSG, this.handle, 259, 259, n5)) {
            this.display.lastDead = true;
            this.display.lastVirtual = n3 == 0;
            this.display.lastKey = this.display.lastVirtual ? n : n3;
            return null;
        }
        boolean bl = this.display.lastVirtual = n3 == 0 || this.display.numpadKey(n) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = n;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                if (this.display.asciiKey(this.display.lastKey) != 0) {
                    return null;
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            int n6;
            this.display.lastKey = OS.CharLower((short)n3);
            if (n == 3) {
                this.display.lastVirtual = true;
            }
            if ((n6 = this.display.asciiKey(n)) != 0) {
                if (n6 == 32) {
                    return null;
                }
                if (n6 != n) {
                    return null;
                }
                if (n == 3) {
                    return null;
                }
            }
            if (OS.GetKeyState(17) >= 0) {
                return null;
            }
            if (OS.GetKeyState(16) < 0) {
                this.display.lastAscii = this.display.shiftedKey(n);
                if (this.display.lastAscii == 0) {
                    this.display.lastAscii = n3;
                }
            } else {
                this.display.lastAscii = OS.CharLower((short)n3);
            }
            if (this.display.lastAscii == 64) {
                return null;
            }
            this.display.lastAscii = this.display.controlKey(this.display.lastAscii);
        }
        if (!this.sendKeyEvent(1, 256, n, n2)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_KEYUP(int n, int n2) {
        int n3;
        Display display = this.display;
        if (OS.IsWinCE && 193 <= n && n <= 198) {
            int n4;
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            Event event = new Event();
            event.detail = n - 193 + 1;
            int n5 = n4 = (n2 & 0x40000000) != 0 ? 34 : 33;
            if (this.setInputState(event, n4)) {
                this.sendEvent(n4, event);
            }
            return null;
        }
        if (!this.hooks(2) && !display.filters(2)) {
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            return null;
        }
        int n6 = n3 = OS.IsWinCE ? 0 : OS.MapVirtualKey(n, 2);
        if (OS.IsWinNT ? (n3 & Integer.MIN_VALUE) != 0 : (n3 & 0x8000) != 0) {
            return null;
        }
        if (display.lastDead) {
            return null;
        }
        boolean bl = display.lastVirtual = n3 == 0 || display.numpadKey(n) != 0;
        if (display.lastVirtual) {
            display.lastKey = n;
        } else {
            if (n == 3) {
                display.lastVirtual = true;
            }
            if (display.lastKey == 0) {
                display.lastAscii = 0;
                display.lastDead = false;
                display.lastNull = false;
                return null;
            }
        }
        LRESULT lRESULT = null;
        if (!this.sendKeyEvent(2, 257, n, n2)) {
            lRESULT = LRESULT.ONE;
        }
        display.lastAscii = 0;
        display.lastKey = 0;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        int n3 = this.callWindowProc(8, n, n2);
        this.sendFocusEvent(16, n);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (n3 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_LBUTTONDBLCLK(int n, int n2) {
        this.sendMouseEvent(3, 1, 513, n, n2);
        this.sendMouseEvent(8, 1, 515, n, n2);
        int n3 = this.callWindowProc(515, n, n2);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = this.hooks(29);
        if (bl3 && !OS.IsWinCE) {
            POINT pOINT = new POINT();
            pOINT.x = (short)(n2 & 0xFFFF);
            pOINT.y = (short)(n2 >> 16);
            OS.ClientToScreen(this.handle, pOINT);
            bl = OS.DragDetect(this.handle, pOINT);
            bl2 = OS.GetKeyState(1) < 0;
        }
        this.sendMouseEvent(3, 1, 513, n, n2);
        int n3 = this.callWindowProc(513, n, n2);
        if (OS.IsPPC) {
            boolean bl4;
            boolean bl5 = bl4 = this.menu != null && !this.menu.isDisposed();
            if (bl4 || this.hooks(35)) {
                short s = (short)(n2 & 0xFFFF);
                short s2 = (short)(n2 >> 16);
                SHRGINFO sHRGINFO = new SHRGINFO();
                sHRGINFO.cbSize = 20;
                sHRGINFO.hwndClient = this.handle;
                sHRGINFO.ptDown_x = s;
                sHRGINFO.ptDown_y = s2;
                sHRGINFO.dwFlags = 1;
                int n4 = OS.SHRecognizeGesture(sHRGINFO);
                if (n4 == 1000) {
                    this.showMenu(s, s2);
                }
            }
        }
        if (bl2 && OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        if (bl) {
            Event event = new Event();
            event.x = (short)(n2 & 0xFFFF);
            event.y = (short)(n2 >> 16);
            this.postEvent(29, event);
        } else if (bl3 && OS.GetKeyState(27) >= 0) {
            OS.SendMessage(this.handle, 514, n, n2);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_LBUTTONUP(int n, int n2) {
        this.sendMouseEvent(4, 1, 514, n, n2);
        int n3 = this.callWindowProc(514, n, n2);
        if ((n & 0x13) == 0 && OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
        return new LRESULT(n3);
    }

    LRESULT WM_MBUTTONDBLCLK(int n, int n2) {
        this.sendMouseEvent(3, 2, 519, n, n2);
        this.sendMouseEvent(8, 2, 521, n, n2);
        int n3 = this.callWindowProc(521, n, n2);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_MBUTTONDOWN(int n, int n2) {
        this.sendMouseEvent(3, 2, 519, n, n2);
        int n3 = this.callWindowProc(519, n, n2);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_MBUTTONUP(int n, int n2) {
        this.sendMouseEvent(4, 2, 520, n, n2);
        int n3 = this.callWindowProc(520, n, n2);
        if ((n & 0x13) == 0 && OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
        return new LRESULT(n3);
    }

    LRESULT WM_MEASUREITEM(int n, int n2) {
        MEASUREITEMSTRUCT mEASUREITEMSTRUCT = new MEASUREITEMSTRUCT();
        OS.MoveMemory(mEASUREITEMSTRUCT, n2, 24);
        if (mEASUREITEMSTRUCT.CtlType == 1) {
            MenuItem menuItem = this.display.getMenuItem(mEASUREITEMSTRUCT.itemID);
            if (menuItem == null) {
                return null;
            }
            return menuItem.wmMeasureChild(n, n2);
        }
        int n3 = OS.GetDlgItem(this.handle, mEASUREITEMSTRUCT.CtlID);
        Control control = this.display.getControl(n3);
        if (control == null) {
            return null;
        }
        return control.wmMeasureChild(n, n2);
    }

    LRESULT WM_MENUCHAR(int n, int n2) {
        int n3 = n >> 16;
        if (n3 == 0 || n3 == 8192) {
            this.display.mnemonicKeyHit = false;
            return new LRESULT(65536);
        }
        return null;
    }

    LRESULT WM_MENUSELECT(int n, int n2) {
        int n3 = n >> 16;
        Shell shell = this.getShell();
        if (n3 == -1 && n2 == 0) {
            Menu menu = shell.activeMenu;
            while (menu != null) {
                this.display.mnemonicKeyHit = true;
                menu.sendEvent(23);
                if (menu.isDisposed()) break;
                menu = menu.getParentMenu();
            }
            shell.activeMenu = null;
            return null;
        }
        if ((n3 & 0x2000) != 0) {
            return null;
        }
        if ((n3 & 0x80) != 0) {
            MenuItem menuItem = null;
            Decorations decorations = this.menuShell();
            if ((n3 & 0x10) != 0) {
                Menu menu;
                int n4 = n & 0xFFFF;
                MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
                mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
                mENUITEMINFO.fMask = 4;
                if (OS.GetMenuItemInfo(n2, n4, true, mENUITEMINFO) && (menu = decorations.findMenu(mENUITEMINFO.hSubMenu)) != null) {
                    menuItem = menu.cascade;
                }
            } else {
                Menu menu;
                Menu menu2 = decorations.findMenu(n2);
                if (menu2 != null) {
                    int n5 = n & 0xFFFF;
                    menuItem = this.display.getMenuItem(n5);
                }
                if ((menu = shell.activeMenu) != null) {
                    Menu menu3 = menu;
                    while (menu3 != null && menu3 != menu2) {
                        menu3 = menu3.getParentMenu();
                    }
                    if (menu3 == menu2) {
                        menu3 = menu;
                        while (menu3 != menu2) {
                            menu3.sendEvent(23);
                            if (menu3.isDisposed()) break;
                            menu3 = menu3.getParentMenu();
                        }
                        if (!shell.isDisposed()) {
                            if (menu2 != null && menu2.isDisposed()) {
                                menu2 = null;
                            }
                            shell.activeMenu = menu2;
                        }
                        if (menuItem != null && menuItem.isDisposed()) {
                            menuItem = null;
                        }
                    }
                }
            }
            if (menuItem != null) {
                menuItem.sendEvent(30);
            }
        }
        return null;
    }

    LRESULT WM_MOUSEACTIVATE(int n, int n2) {
        return null;
    }

    LRESULT WM_MOUSEHOVER(int n, int n2) {
        this.sendMouseEvent(32, 0, 673, n, n2);
        return null;
    }

    LRESULT WM_MOUSELEAVE(int n, int n2) {
        int n3 = OS.GetMessagePos();
        POINT pOINT = new POINT();
        pOINT.x = (short)(n3 & 0xFFFF);
        pOINT.y = (short)(n3 >> 16);
        OS.ScreenToClient(this.handle, pOINT);
        n2 = pOINT.x | pOINT.y << 16;
        this.sendMouseEvent(7, 0, 675, n, n2);
        return null;
    }

    LRESULT WM_MOUSEMOVE(int n, int n2) {
        int n3 = OS.GetMessagePos();
        if (n3 != this.display.lastMouse) {
            if (!OS.IsWinCE) {
                boolean bl;
                boolean bl2 = this.hooks(6) || this.display.filters(6);
                boolean bl3 = this.hooks(7) || this.display.filters(7);
                boolean bl4 = bl = this.hooks(32) || this.display.filters(32);
                if (bl2 || bl3 || bl) {
                    TRACKMOUSEEVENT tRACKMOUSEEVENT = new TRACKMOUSEEVENT();
                    tRACKMOUSEEVENT.cbSize = 16;
                    tRACKMOUSEEVENT.dwFlags = 0x40000000;
                    tRACKMOUSEEVENT.hwndTrack = this.handle;
                    OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    if (tRACKMOUSEEVENT.dwFlags == 0) {
                        tRACKMOUSEEVENT.dwFlags = 3;
                        tRACKMOUSEEVENT.hwndTrack = this.handle;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                        if (bl2) {
                            MSG mSG = new MSG();
                            int n4 = 10420227;
                            while (OS.PeekMessage(mSG, 0, 675, 675, n4)) {
                                OS.TranslateMessage(mSG);
                                OS.DispatchMessage(mSG);
                            }
                            this.sendMouseEvent(6, 0, 512, n, n2);
                        }
                    } else {
                        tRACKMOUSEEVENT.dwFlags = 1;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    }
                }
            }
            this.display.lastMouse = n3;
            this.sendMouseEvent(5, 0, 512, n, n2);
        }
        return null;
    }

    LRESULT WM_MOUSEWHEEL(int n, int n2) {
        return null;
    }

    LRESULT WM_MOVE(int n, int n2) {
        this.sendEvent(10);
        return null;
    }

    LRESULT WM_NCACTIVATE(int n, int n2) {
        return null;
    }

    LRESULT WM_NCCALCSIZE(int n, int n2) {
        return null;
    }

    LRESULT WM_NCHITTEST(int n, int n2) {
        if (!OS.IsWindowEnabled(this.handle)) {
            return null;
        }
        if (!this.isActive()) {
            return new LRESULT(-1);
        }
        return null;
    }

    LRESULT WM_NCLBUTTONDOWN(int n, int n2) {
        return null;
    }

    LRESULT WM_NOTIFY(int n, int n2) {
        NMHDR nMHDR = new NMHDR();
        OS.MoveMemory(nMHDR, n2, 12);
        int n3 = nMHDR.hwndFrom;
        if (n3 == 0) {
            return null;
        }
        Control control = this.display.getControl(n3);
        if (control == null) {
            return null;
        }
        return control.wmNotifyChild(n, n2);
    }

    LRESULT WM_PAINT(int n, int n2) {
        Object object;
        if (!this.hooks(9) && !this.filters(9)) {
            return null;
        }
        int n3 = 0;
        if (OS.IsWinCE) {
            object = new RECT();
            OS.GetUpdateRect(this.handle, (RECT)object, false);
            n3 = this.callWindowProc(15, n, n2);
            OS.InvalidateRect(this.handle, (RECT)object, false);
        } else {
            int n4 = OS.CreateRectRgn(0, 0, 0, 0);
            OS.GetUpdateRgn(this.handle, n4, false);
            n3 = this.callWindowProc(15, n, n2);
            OS.InvalidateRgn(this.handle, n4, false);
            OS.DeleteObject(n4);
        }
        object = new PAINTSTRUCT();
        GCData gCData = new GCData();
        gCData.ps = object;
        GC gC = GC.win32_new(this, gCData);
        Event event = new Event();
        event.gc = gC;
        event.x = ((PAINTSTRUCT)object).left;
        event.y = ((PAINTSTRUCT)object).top;
        event.width = ((PAINTSTRUCT)object).right - ((PAINTSTRUCT)object).left;
        event.height = ((PAINTSTRUCT)object).bottom - ((PAINTSTRUCT)object).top;
        this.sendEvent(9, event);
        event.gc = null;
        gC.dispose();
        if (n3 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_PALETTECHANGED(int n, int n2) {
        return null;
    }

    LRESULT WM_PARENTNOTIFY(int n, int n2) {
        return null;
    }

    LRESULT WM_PASTE(int n, int n2) {
        return null;
    }

    LRESULT WM_PRINTCLIENT(int n, int n2) {
        return null;
    }

    LRESULT WM_QUERYENDSESSION(int n, int n2) {
        return null;
    }

    LRESULT WM_QUERYNEWPALETTE(int n, int n2) {
        return null;
    }

    LRESULT WM_QUERYOPEN(int n, int n2) {
        return null;
    }

    LRESULT WM_RBUTTONDBLCLK(int n, int n2) {
        this.sendMouseEvent(3, 3, 516, n, n2);
        this.sendMouseEvent(8, 3, 518, n, n2);
        int n3 = this.callWindowProc(518, n, n2);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_RBUTTONDOWN(int n, int n2) {
        this.sendMouseEvent(3, 3, 516, n, n2);
        int n3 = this.callWindowProc(516, n, n2);
        if (OS.GetCapture() != this.handle) {
            OS.SetCapture(this.handle);
        }
        return new LRESULT(n3);
    }

    LRESULT WM_RBUTTONUP(int n, int n2) {
        this.sendMouseEvent(4, 3, 517, n, n2);
        int n3 = this.callWindowProc(517, n, n2);
        if ((n & 0x13) == 0 && OS.GetCapture() == this.handle) {
            OS.ReleaseCapture();
        }
        return new LRESULT(n3);
    }

    LRESULT WM_SETCURSOR(int n, int n2) {
        short s = (short)(n2 & 0xFFFF);
        if (s == 1) {
            Control control = this.display.getControl(n);
            if (control == null) {
                return null;
            }
            Cursor cursor = control.findCursor();
            if (cursor != null) {
                OS.SetCursor(cursor.handle);
                return LRESULT.ONE;
            }
        }
        return null;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        int n3 = this.callWindowProc(7, n, n2);
        this.sendFocusEvent(15, n);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (n3 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n3);
    }

    LRESULT WM_SETTINGCHANGE(int n, int n2) {
        return null;
    }

    LRESULT WM_SETFONT(int n, int n2) {
        return null;
    }

    LRESULT WM_SETREDRAW(int n, int n2) {
        return null;
    }

    LRESULT WM_SHOWWINDOW(int n, int n2) {
        return null;
    }

    LRESULT WM_SIZE(int n, int n2) {
        this.sendEvent(11);
        return null;
    }

    LRESULT WM_SYSCHAR(int n, int n2) {
        Display display = this.display;
        display.lastAscii = n;
        boolean bl = display.lastNull = n == 0;
        if (!this.hooks(1) && !display.filters(1)) {
            return null;
        }
        boolean bl2 = display.mnemonicKeyHit;
        display.mnemonicKeyHit = true;
        int n3 = this.callWindowProc(262, n, n2);
        boolean bl3 = false;
        if (!display.mnemonicKeyHit) {
            bl3 = !this.sendKeyEvent(1, 262, n, n2);
        }
        display.mnemonicKeyHit = bl2;
        return (bl3 |= display.mnemonicKeyHit) ? LRESULT.ONE : new LRESULT(n3);
    }

    LRESULT WM_SYSCOLORCHANGE(int n, int n2) {
        return null;
    }

    /*
     * Handled duff style switch with additional control
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    LRESULT WM_SYSCOMMAND(int n, int n2) {
        Decorations decorations;
        if ((n & 0xF000) == 0) {
            MenuItem menuItem;
            Decorations decorations2 = this.menuShell();
            if (!decorations2.isEnabled() || (menuItem = this.display.getMenuItem(n & 0xFFFF)) == null) return LRESULT.ZERO;
            menuItem.wmCommandChild(n, n2);
            return LRESULT.ZERO;
        }
        int n3 = n & 0xFFF0;
        int n4 = 0;
        block6: do {
            int n5;
            MenuItem[] menuItemArray;
            switch (n4 == 0 ? n3 : n4) {
                case 61536: {
                    int n6 = this.menuShell().handle;
                    int n7 = OS.GetWindowLong(n6, -16);
                    if ((n7 & 0x80000) != 0) return null;
                    return LRESULT.ZERO;
                }
                case 61696: {
                    char c2;
                    if (n2 == 0) {
                        n4 = 61552;
                        decorations = this.menuShell();
                        Menu menu = decorations.getMenuBar();
                        if (menu != null) continue block6;
                        n4 = 61552;
                        Control control = this.display.getFocusControl();
                        if (control == null) continue block6;
                        if (!control.hooks(1)) {
                            n4 = 61552;
                            if (!control.hooks(2)) continue block6;
                        }
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    if (!this.hooks(1)) {
                        n4 = 61552;
                        if (!this.hooks(2)) continue block6;
                    }
                    n4 = 61552;
                    if (n2 == 32) continue block6;
                    decorations = this.menuShell();
                    Menu menu = decorations.getMenuBar();
                    if (menu != null) {
                        n4 = 61552;
                        c2 = Display.mbcsToWcs(n2);
                        if (c2 == '\u0000') continue block6;
                        c2 = Character.toUpperCase(c2);
                        menuItemArray = menu.getItems();
                        n5 = 0;
                        if (true) {
                            n4 = 61552;
                            if (n5 >= menuItemArray.length) continue block6;
                        }
                    } else {
                        this.display.mnemonicKeyHit = false;
                        n4 = 61552;
                        continue block6;
                    }
                }
                case 61472: {
                    this.menuShell().saveFocus();
                    return null;
                }
                default: {
                    return null;
                }
                do {
                    char c;
                    char c2;
                    MenuItem menuItem = menuItemArray[n5];
                    String string = menuItem.getText();
                    char c3 = this.findMnemonic(string);
                    if (string.length() > 0 && c3 == '\u0000' && Character.toUpperCase(c = string.charAt(0)) == c2) {
                        this.display.mnemonicKeyHit = false;
                        return LRESULT.ZERO;
                    }
                    ++n5;
                    n4 = 61552;
                } while (n5 < menuItemArray.length);
                case 61552: 
                case 61568: 
            }
            break;
        } while (true);
        if ((decorations = this.menuShell()).isEnabled() && decorations.isActive()) return null;
        return LRESULT.ZERO;
    }

    LRESULT WM_SYSKEYDOWN(int n, int n2) {
        if (n != 121 && (n2 & 0x20000000) == 0) {
            return null;
        }
        switch (n) {
            case 115: {
                return null;
            }
        }
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((n2 & 0x40000000) == 0) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        int n3 = OS.IsWinCE ? 0 : OS.MapVirtualKey(n, 2);
        boolean bl = this.display.lastVirtual = n3 == 0 || this.display.numpadKey(n) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = n;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            this.display.lastKey = OS.CharLower((short)n3);
            if (OS.IsWinNT) {
                return null;
            }
            if (n != 13) {
                return null;
            }
            this.display.lastAscii = 13;
        }
        if (!this.sendKeyEvent(1, 260, n, n2)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT WM_SYSKEYUP(int n, int n2) {
        return this.WM_KEYUP(n, n2);
    }

    LRESULT WM_TIMER(int n, int n2) {
        return null;
    }

    LRESULT WM_UNDO(int n, int n2) {
        return null;
    }

    LRESULT WM_VSCROLL(int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        Control control = this.display.getControl(n2);
        if (control == null) {
            return null;
        }
        return control.wmScrollChild(n, n2);
    }

    LRESULT WM_WINDOWPOSCHANGED(int n, int n2) {
        return null;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        return null;
    }

    LRESULT wmColorChild(int n, int n2) {
        if (this.background == -1 && this.foreground == -1) {
            return null;
        }
        int n3 = this.foreground;
        int n4 = this.background;
        if (n3 == -1) {
            n3 = this.defaultForeground();
        }
        if (n4 == -1) {
            n4 = this.defaultBackground();
        }
        OS.SetTextColor(n, n3);
        OS.SetBkColor(n, n4);
        return new LRESULT(this.findBrush(n4));
    }

    LRESULT wmCommandChild(int n, int n2) {
        return null;
    }

    LRESULT wmDrawChild(int n, int n2) {
        return null;
    }

    LRESULT wmMeasureChild(int n, int n2) {
        return null;
    }

    LRESULT wmNotifyChild(int n, int n2) {
        return null;
    }

    LRESULT wmScrollChild(int n, int n2) {
        return null;
    }
}

