#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* about.c:
 *
 * implements the about box, displays the message in aboutm.h in a scrollable
 * ttext item */

#include "interface.h"

#include "treedata.h"

#include "aboutm.h"

static tframe about;
static tcanvas ac;
static ttext at;

int resize_about_frame(f, e)
tframe f;
tevent e;
{
    int w, h;

    if(tevent_type(e)==te_resize)
    {
        tevent_size(e, &w, &h);
		tcanvas_resize(ac, 0, 0, w, h, NULL, NULL);
		w-=30;
		ttext_resize(at, &w, &h);
        return(0);
    }
    else
        return(0);

}

int about_do_events(c, e)
tcanvas c;
tevent e;
{
	if(tevent_type(e)==te_repaint)
	{
		ttext_repaint(at);
	}
}

int create_about_frame(parent, args)
tframe parent;
targs args;
{
    about=tframe_new(parent, 50,50,400,500,0,1,0, "About Treetool", args);
    if(about==NULL)
		return(0);
	tframe_set_event_procedure(about, resize_about_frame);
	tframe_push_pin(about);

	ac=(tcanvas)tcanvas_new2(about, 0, 0, 400, 500, NULL, NULL,
		400, 800, 1, 1, 20, 10, 0, 0, 1, args);
	tcanvas_set_event_procedure(ac, about_do_events);
	tcanvas_resize(ac, 0, 0, 400, 500, NULL, NULL);
	tcanvas_pages(ac, 0);

	at=ttext_new(ac, 5, 5, tcanvas_width(ac), 10, globals->cfont,
		aboutm, globals->b, globals->w, args, 0);
	ttext_unselect(at);

    tframe_fit(about);
    tframe_hide(about);
	tframe_pull_pin(about);
    return(1);
}

int show_about_frame()
{
	moveframetoloc(about);
	tframe_push_pin(about);
    tframe_show(about);
}

int hide_about_frame()
{
    tframe_hide(about);
}

about_notbusy()
{
	if(about!=NULL)
		tframe_set_notbusy(about);
}

about_busy()
{
	if(about!=NULL)
		tframe_set_busy(about);
}
